/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.circuitbreaker;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Map;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.resilient.circuitbreaker.$CircuitBreakerConfig_NamedConfig_ConfigValueExtractor;
import ru.tinkoff.kora.resilient.circuitbreaker.KoraCircuitBreakerPredicate;

@ConfigValueExtractor
public interface CircuitBreakerConfig {
    public static final String DEFAULT = "default";

    default public Map<String, NamedConfig> circuitbreaker() {
        return Map.of();
    }

    default public NamedConfig getNamedConfig(@Nonnull String name) {
        NamedConfig defaultConfig = this.circuitbreaker().get(DEFAULT);
        NamedConfig namedConfig = this.circuitbreaker().getOrDefault(name, defaultConfig);
        if (namedConfig == null) {
            throw new IllegalStateException("CircuitBreaker no configuration is provided, but either '%s' or '%s' config is required".formatted(name, DEFAULT));
        }
        NamedConfig mergedConfig = CircuitBreakerConfig.merge(namedConfig, defaultConfig);
        if (mergedConfig.failureRateThreshold() == null) {
            throw new IllegalStateException("CircuitBreaker property '%s' is not configured in either '%s' or '%s' config".formatted("failureRateThreshold", name, DEFAULT));
        }
        if (mergedConfig.waitDurationInOpenState() == null) {
            throw new IllegalStateException("CircuitBreaker property '%s' is not configured in either '%s' or '%s' config".formatted("waitDurationInOpenState", name, DEFAULT));
        }
        if (mergedConfig.permittedCallsInHalfOpenState() == null) {
            throw new IllegalStateException("CircuitBreaker property '%s' is not configured in either '%s' or '%s' config".formatted("permittedCallsInHalfOpenState", name, DEFAULT));
        }
        if (mergedConfig.slidingWindowSize() == null) {
            throw new IllegalStateException("CircuitBreaker property '%s' is not configured in either '%s' or '%s' config".formatted("slidingWindowSize", name, DEFAULT));
        }
        if (mergedConfig.minimumRequiredCalls() == null) {
            throw new IllegalStateException("CircuitBreaker property '%s' is not configured in either '%s' or '%s' config".formatted("minimumRequiredCalls", name, DEFAULT));
        }
        if (mergedConfig.minimumRequiredCalls() < 1L) {
            throw new IllegalArgumentException("CircuitBreaker '%s' property '%s' can't be negative value, but was: %s".formatted(name, "minimumRequiredCalls", mergedConfig.minimumRequiredCalls()));
        }
        if (mergedConfig.slidingWindowSize() < 1L) {
            throw new IllegalArgumentException("CircuitBreaker '%s' property '%s' can't be negative value, but was: %s".formatted(name, "slidingWindowSize", mergedConfig.slidingWindowSize()));
        }
        if (mergedConfig.minimumRequiredCalls() > mergedConfig.slidingWindowSize()) {
            throw new IllegalArgumentException("CircuitBreaker '%s' property '%s' has value %s, it can't be greater than property '%s' which value was: %s".formatted(name, "minimumRequiredCalls", mergedConfig.minimumRequiredCalls(), "slidingWindowSize", mergedConfig.slidingWindowSize()));
        }
        if ((long)mergedConfig.permittedCallsInHalfOpenState().intValue() > mergedConfig.minimumRequiredCalls()) {
            throw new IllegalArgumentException("CircuitBreaker '%s' property '%s' has value %s, it can't be greater than property '%s' which value was: %s".formatted(name, "permittedCallsInHalfOpenState", mergedConfig.permittedCallsInHalfOpenState(), "minimumRequiredCalls", mergedConfig.minimumRequiredCalls()));
        }
        if (mergedConfig.failureRateThreshold() > 100 || mergedConfig.failureRateThreshold() < 1) {
            throw new IllegalArgumentException("CircuitBreaker '%s' failureRateThreshold is percentage and must be in range from 1 to 100, but was: %s".formatted(name, mergedConfig.failureRateThreshold()));
        }
        return mergedConfig;
    }

    private static NamedConfig merge(NamedConfig namedConfig, NamedConfig defaultConfig) {
        if (defaultConfig == null) {
            return namedConfig;
        }
        return new $CircuitBreakerConfig_NamedConfig_ConfigValueExtractor.NamedConfig_Impl(namedConfig.enabled() != null ? Boolean.TRUE.equals(namedConfig.enabled()) : defaultConfig.enabled() == null || Boolean.TRUE.equals(defaultConfig.enabled()), namedConfig.failureRateThreshold() == null ? defaultConfig.failureRateThreshold() : namedConfig.failureRateThreshold(), namedConfig.waitDurationInOpenState() == null ? defaultConfig.waitDurationInOpenState() : namedConfig.waitDurationInOpenState(), namedConfig.permittedCallsInHalfOpenState() == null ? defaultConfig.permittedCallsInHalfOpenState() : namedConfig.permittedCallsInHalfOpenState(), namedConfig.slidingWindowSize() == null ? defaultConfig.slidingWindowSize() : namedConfig.slidingWindowSize(), namedConfig.minimumRequiredCalls() == null ? defaultConfig.minimumRequiredCalls() : namedConfig.minimumRequiredCalls(), namedConfig.failurePredicateName() == null ? defaultConfig.failurePredicateName() : namedConfig.failurePredicateName());
    }

    @ConfigValueExtractor
    public static interface NamedConfig {
        @Nullable
        public Boolean enabled();

        @Nullable
        public Integer failureRateThreshold();

        @Nullable
        public Duration waitDurationInOpenState();

        @Nullable
        public Integer permittedCallsInHalfOpenState();

        @Nullable
        public Long slidingWindowSize();

        @Nullable
        public Long minimumRequiredCalls();

        default public String failurePredicateName() {
            return KoraCircuitBreakerPredicate.class.getCanonicalName();
        }
    }
}

