/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import ru.tinkoff.kora.resilient.retry.RetryConfig;
import ru.tinkoff.kora.resilient.retry.RetryExhaustedException;
import ru.tinkoff.kora.resilient.retry.RetryMetrics;
import ru.tinkoff.kora.resilient.retry.RetryPredicate;

public final class KoraRetryReactorBuilder {
    private static final Logger logger = LoggerFactory.getLogger(KoraRetryReactorBuilder.class);
    private final Map<String, Retry> retryableByName = new ConcurrentHashMap<String, Retry>();
    private final List<RetryPredicate> failurePredicates;
    private final RetryConfig config;
    private final RetryMetrics metrics;

    public KoraRetryReactorBuilder(RetryConfig config, List<RetryPredicate> failurePredicates, RetryMetrics metrics) {
        this.config = config;
        this.failurePredicates = failurePredicates;
        this.metrics = metrics;
    }

    @Nonnull
    public Retry get(@Nonnull String name) {
        return this.retryableByName.computeIfAbsent(name, k -> {
            RetryConfig.NamedConfig config = this.config.getNamedConfig(name);
            RetryPredicate failurePredicate = this.getFailurePredicate(config);
            logger.debug("Creating RetryReactor named '{}' with config {}", (Object)name, (Object)config);
            return new KoraReactorRetry(name, config, failurePredicate, this.metrics);
        });
    }

    private RetryPredicate getFailurePredicate(RetryConfig.NamedConfig config) {
        return this.failurePredicates.stream().filter(p -> p.name().equals(config.failurePredicateName())).findFirst().orElseThrow(() -> new IllegalArgumentException("FailurePredicateClassName " + config.failurePredicateName() + " is not present as bean, please declare it as bean"));
    }

    private static final class KoraReactorRetry
    extends Retry {
        private static final Logger logger = LoggerFactory.getLogger(KoraReactorRetry.class);
        private final String name;
        private final long delayNanos;
        private final long delayStepNanos;
        private final int attempts;
        private final RetryPredicate failurePredicate;
        private final RetryMetrics metrics;
        private final RetryConfig.NamedConfig config;

        private KoraReactorRetry(String name, long delayNanos, long delayStepNanos, int attempts, RetryPredicate failurePredicate, RetryMetrics metrics, RetryConfig.NamedConfig config) {
            this.name = name;
            this.delayNanos = delayNanos;
            this.delayStepNanos = delayStepNanos;
            this.attempts = attempts;
            this.failurePredicate = failurePredicate;
            this.metrics = metrics;
            this.config = config;
        }

        private KoraReactorRetry(String name, RetryConfig.NamedConfig config, RetryPredicate failurePredicate, RetryMetrics metric) {
            this(name, config.delay().toNanos(), config.delayStep().toNanos(), config.attempts(), failurePredicate, metric, config);
        }

        public Publisher<?> generateCompanion(Flux<Retry.RetrySignal> retrySignals) {
            return retrySignals.concatMap(retryWhenState -> {
                if (!this.config.enabled().booleanValue()) {
                    return Mono.empty();
                }
                Retry.RetrySignal signal = retryWhenState.copy();
                Throwable currentFailure = signal.failure();
                if (currentFailure == null) {
                    return Mono.error((Throwable)new IllegalStateException("Retry.RetrySignal#failure() not expected to be null"));
                }
                if (this.attempts == 0) {
                    return Mono.empty();
                }
                if (!this.failurePredicate.test(currentFailure)) {
                    logger.trace("RetryReactor '{}' rejected throwable: {}", (Object)this.name, (Object)currentFailure.getClass().getCanonicalName());
                    return Mono.error((Throwable)currentFailure);
                }
                if (signal.totalRetries() >= (long)this.attempts) {
                    logger.debug("RetryReactor '{}' exhausted all '{}' attempts", (Object)this.name, (Object)signal.totalRetries());
                    this.metrics.recordExhaustedAttempts(this.name, this.attempts);
                    RetryExhaustedException exception = new RetryExhaustedException(this.name, this.attempts, currentFailure);
                    exception.addSuppressed(currentFailure);
                    return Mono.error((Throwable)exception);
                }
                long nextDelayNanos = this.delayNanos + this.delayStepNanos * (signal.totalRetries() - 1L);
                Duration delayDuration = Duration.ofNanos(nextDelayNanos);
                logger.debug("RetryState '{}' initiating '{}' retry for '{}' due to exception: {}", new Object[]{this.name, signal.totalRetries(), delayDuration, currentFailure.getClass().getCanonicalName()});
                this.metrics.recordAttempt(this.name, nextDelayNanos);
                return Mono.delay((Duration)delayDuration);
            });
        }
    }
}

