/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.internal.loom.VirtualThreadExecutorHolder;
import ru.tinkoff.kora.resilient.retry.KoraRetryState;
import ru.tinkoff.kora.resilient.retry.Retry;
import ru.tinkoff.kora.resilient.retry.RetryConfig;
import ru.tinkoff.kora.resilient.retry.RetryExhaustedException;
import ru.tinkoff.kora.resilient.retry.RetryMetrics;
import ru.tinkoff.kora.resilient.retry.RetryPredicate;

final class KoraRetry
implements Retry {
    private static final Logger logger = LoggerFactory.getLogger(KoraRetry.class);
    private static final Retry.RetryState EMPTY_STATE = new KoraEmptyRetryState();
    final String name;
    final long delayNanos;
    final long delayStepNanos;
    final int attempts;
    final RetryPredicate failurePredicate;
    final RetryMetrics metrics;
    final RetryConfig.NamedConfig config;

    KoraRetry(String name, long delayNanos, long delayStepNanos, int attempts, RetryPredicate failurePredicate, RetryMetrics metrics, RetryConfig.NamedConfig config) {
        this.name = name;
        this.delayNanos = delayNanos;
        this.delayStepNanos = delayStepNanos;
        this.attempts = attempts;
        this.failurePredicate = failurePredicate;
        this.metrics = metrics;
        this.config = config;
    }

    KoraRetry(String name, RetryConfig.NamedConfig config, RetryPredicate failurePredicate, RetryMetrics metric) {
        this(name, config.delay().toNanos(), config.delayStep().toNanos(), config.attempts(), failurePredicate, metric, config);
    }

    @Override
    @Nonnull
    public Retry.RetryState asState() {
        if (Boolean.FALSE.equals(this.config.enabled())) {
            logger.debug("Retry '{}' is disabled", (Object)this.name);
            return EMPTY_STATE;
        }
        return new KoraRetryState(this.name, System.nanoTime(), this.delayNanos, this.delayStepNanos, this.attempts, this.failurePredicate, this.metrics, new AtomicInteger(0));
    }

    @Override
    public <E extends Throwable> void retry(@Nonnull Retry.RetryRunnable<E> runnable) throws RetryExhaustedException, E {
        this.internalRetry(() -> {
            runnable.run();
            return null;
        }, null);
    }

    @Override
    public <T, E extends Throwable> T retry(@Nonnull Retry.RetrySupplier<T, E> supplier) throws E {
        return this.internalRetry(supplier, null);
    }

    @Override
    public <T, E extends Throwable> T retry(@Nonnull Retry.RetrySupplier<T, E> supplier, @Nonnull Retry.RetrySupplier<T, E> fallback) throws E {
        return this.internalRetry(supplier, fallback);
    }

    @Override
    public <T> CompletionStage<T> retry(final @NotNull Supplier<CompletionStage<T>> supplier) {
        if (Boolean.FALSE.equals(this.config.enabled())) {
            logger.debug("Retry '{}' is disabled", (Object)this.name);
            return supplier.get();
        }
        if (this.attempts == 0) {
            return supplier.get();
        }
        final CompletableFuture result = new CompletableFuture();
        final Retry.RetryState retryState = this.asState();
        final Executor virtualExecutor = VirtualThreadExecutorHolder.executor();
        BiConsumer retryCallback = new BiConsumer<T, Throwable>(){

            @Override
            public void accept(T r, Throwable e) {
                Throwable ex;
                Throwable throwable = ex = e instanceof CompletionException ? e.getCause() : e;
                if (ex == null) {
                    result.complete(r);
                    return;
                }
                Retry.RetryState.RetryStatus state = retryState.onException(ex);
                if (state == Retry.RetryState.RetryStatus.ACCEPTED) {
                    Executor delayedExecutor = virtualExecutor != null ? CompletableFuture.delayedExecutor(retryState.getDelayNanos(), TimeUnit.NANOSECONDS, virtualExecutor) : CompletableFuture.delayedExecutor(retryState.getDelayNanos(), TimeUnit.NANOSECONDS);
                    delayedExecutor.execute(() -> this.lambda$accept$0((Supplier)supplier));
                } else if (state == Retry.RetryState.RetryStatus.REJECTED) {
                    retryState.close();
                    result.completeExceptionally(ex);
                } else {
                    retryState.close();
                    result.completeExceptionally(new RetryExhaustedException(KoraRetry.this.name, retryState.getAttemptsMax(), ex));
                }
            }

            private /* synthetic */ void lambda$accept$0(Supplier supplier2) {
                try {
                    CompletionStage resultRetry = (CompletionStage)supplier2.get();
                    resultRetry.whenComplete(this);
                }
                catch (Exception se) {
                    CompletableFuture.failedFuture(se).whenComplete((BiConsumer)this);
                }
            }
        };
        try {
            CompletionStage<T> superCall = supplier.get();
            superCall.whenComplete(retryCallback);
            return result;
        }
        catch (Exception e) {
            CompletableFuture.failedFuture(e).whenComplete(retryCallback);
            return result;
        }
    }

    /*
     * Unable to fully structure code
     */
    private <T, E extends Throwable> T internalRetry(Retry.RetrySupplier<T, E> consumer, @Nullable Retry.RetrySupplier<T, E> fallback) throws E {
        if (Boolean.FALSE.equals(this.config.enabled())) {
            KoraRetry.logger.debug("Retry '{}' is disabled", (Object)this.name);
            return consumer.get();
        }
        if (this.attempts == 0) {
            return consumer.get();
        }
        suppressed = new ArrayList<Exception>();
        state = this.asState();
        while (true) {
            try {
                var5_6 = consumer.get();
                return var5_6;
            }
            catch (Exception e) {
                status = state.onException(e);
                if (status == Retry.RetryState.RetryStatus.REJECTED) {
                    for (Exception exception : suppressed) {
                        e.addSuppressed(exception);
                    }
                    throw e;
                }
                if (status == Retry.RetryState.RetryStatus.ACCEPTED) {
                    suppressed.add(e);
                    state.doDelay();
                    continue;
                }
                if (status == Retry.RetryState.RetryStatus.EXHAUSTED) ** break;
                continue;
                if (fallback != null) {
                    try {
                        var7_11 = fallback.get();
                    }
                    catch (Exception ex) {
                        for (Exception exception : suppressed) {
                            ex.addSuppressed(exception);
                        }
                        throw ex;
                    }
                    return var7_11;
                }
                exhaustedException = new RetryExhaustedException(this.name, this.attempts, (Throwable)e);
                for (Exception exception : suppressed) {
                    exhaustedException.addSuppressed(exception);
                }
                throw exhaustedException;
            }
            break;
        }
        finally {
            if (state != null) {
                state.close();
            }
        }
    }

    private static class KoraEmptyRetryState
    implements Retry.RetryState {
        private KoraEmptyRetryState() {
        }

        @Override
        @NotNull
        public Retry.RetryState.RetryStatus onException(@NotNull Throwable throwable) {
            return Retry.RetryState.RetryStatus.REJECTED;
        }

        @Override
        public int getAttempts() {
            return 0;
        }

        @Override
        public int getAttemptsMax() {
            return 0;
        }

        @Override
        public long getDelayNanos() {
            return 0L;
        }

        @Override
        public void doDelay() {
        }

        @Override
        public void close() {
        }
    }
}

