/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import ru.tinkoff.kora.config.common.annotation.ConfigValueExtractor;
import ru.tinkoff.kora.resilient.retry.$RetryConfig_NamedConfig_ConfigValueExtractor;
import ru.tinkoff.kora.resilient.retry.KoraRetryPredicate;

@ConfigValueExtractor
public interface RetryConfig {
    public static final String DEFAULT = "default";

    default public Map<String, NamedConfig> retry() {
        return Map.of();
    }

    default public NamedConfig getNamedConfig(@Nonnull String name) {
        if (this.retry() == null) {
            throw new IllegalStateException("Retry no configuration is provided, but either '" + name + "' or 'default' config is required");
        }
        NamedConfig defaultConfig = this.retry().get(DEFAULT);
        NamedConfig namedConfig = this.retry().getOrDefault(name, defaultConfig);
        if (namedConfig == null) {
            throw new IllegalStateException("Retry no configuration is provided, but either '" + name + "' or 'default' config is required");
        }
        NamedConfig mergedConfig = RetryConfig.merge(namedConfig, defaultConfig);
        if (mergedConfig.delay() == null) {
            throw new IllegalArgumentException("Retry 'delay' is not configured in either '" + name + "' or 'default' config");
        }
        if (mergedConfig.attempts() == null) {
            throw new IllegalArgumentException("Retry 'attempts' is not configured in either '" + name + "' or 'default' config");
        }
        if (mergedConfig.attempts() < 0) {
            throw new IllegalArgumentException("Retry '" + name + "' attempts can't be less 0, but was " + mergedConfig.attempts());
        }
        return mergedConfig;
    }

    private static NamedConfig merge(NamedConfig namedConfig, NamedConfig defaultConfig) {
        if (defaultConfig == null) {
            if (namedConfig.delayStep() == null) {
                return new $RetryConfig_NamedConfig_ConfigValueExtractor.NamedConfig_Impl(namedConfig.enabled() != null ? Boolean.TRUE.equals(namedConfig.enabled()) : true, namedConfig.delay(), Duration.ZERO, namedConfig.attempts(), namedConfig.failurePredicateName());
            }
            return namedConfig;
        }
        return new $RetryConfig_NamedConfig_ConfigValueExtractor.NamedConfig_Impl(namedConfig.enabled() != null ? Boolean.TRUE.equals(namedConfig.enabled()) : defaultConfig.enabled() == null || Boolean.TRUE.equals(defaultConfig.enabled()), namedConfig.delay() == null ? defaultConfig.delay() : namedConfig.delay(), namedConfig.delayStep() == null ? Objects.requireNonNullElse(defaultConfig.delayStep(), Duration.ZERO) : namedConfig.delayStep(), namedConfig.attempts() == null ? defaultConfig.attempts() : namedConfig.attempts(), namedConfig.failurePredicateName() == null ? defaultConfig.failurePredicateName() : namedConfig.failurePredicateName());
    }

    @ConfigValueExtractor
    public static interface NamedConfig {
        @Nullable
        public Boolean enabled();

        @Nullable
        public Duration delay();

        @Nullable
        public Duration delayStep();

        @Nullable
        public Integer attempts();

        default public String failurePredicateName() {
            return KoraRetryPredicate.class.getCanonicalName();
        }
    }
}

