/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry.simple;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.util.retry.Retry;
import ru.tinkoff.kora.resilient.retry.Retrier;
import ru.tinkoff.kora.resilient.retry.RetrierFailurePredicate;
import ru.tinkoff.kora.resilient.retry.RetryAttemptException;
import ru.tinkoff.kora.resilient.retry.RetryException;
import ru.tinkoff.kora.resilient.retry.simple.SimpleReactorRetry;
import ru.tinkoff.kora.resilient.retry.simple.SimpleRetrierConfig;
import ru.tinkoff.kora.resilient.retry.simple.SimpleRetrierRetryState;
import ru.tinkoff.kora.resilient.retry.telemetry.RetryMetrics;

record SimpleRetrier(String name, long delayNanos, long delayStepNanos, int attempts, RetrierFailurePredicate failurePredicate, RetryMetrics metrics, ExecutorService executor) implements Retrier
{
    public SimpleRetrier(String name, SimpleRetrierConfig.NamedConfig config, RetrierFailurePredicate failurePredicate, RetryMetrics metrics, ExecutorService executors) {
        this(name, config.delay().toNanos(), config.delayStep().toNanos(), config.attempts(), failurePredicate, metrics, executors);
    }

    @Override
    @Nonnull
    public Retrier.RetryState asState() {
        return new SimpleRetrierRetryState(this.name, System.nanoTime(), this.delayNanos, this.delayStepNanos, this.attempts, this.failurePredicate, this.metrics, new AtomicInteger(0));
    }

    @Override
    @Nonnull
    public Retry asReactor() {
        return new SimpleReactorRetry(this.name, this.delayNanos, this.delayStepNanos, this.attempts, this.failurePredicate, this.metrics);
    }

    @Override
    public void retry(@Nonnull Runnable runnable) throws RetryException {
        this.internalRetry(e -> e.submit(runnable), null);
    }

    @Override
    public <T> T retry(@Nonnull Supplier<T> supplier) throws RetryException {
        return this.internalRetry(e -> e.submit(((Supplier)supplier)::get), null);
    }

    @Override
    public <T> T retry(@Nonnull Supplier<T> supplier, @Nonnull Supplier<T> fallback) throws RetryException {
        return this.internalRetry(e -> e.submit(((Supplier)supplier)::get), fallback);
    }

    private <T> T internalRetry(Function<ExecutorService, Future<T>> consumer, @Nullable Supplier<T> fallback) throws RetryException {
        Retrier.RetryState counter = this.asState();
        for (int i = 0; i < this.attempts; ++i) {
            try {
                return consumer.apply(this.executor).get(24L, TimeUnit.HOURS);
            }
            catch (Throwable e) {
                counter.checkRetry(e);
                counter.doDelay();
                continue;
            }
        }
        if (fallback != null) {
            return fallback.get();
        }
        throw new RetryAttemptException("All '" + this.attempts + "' attempts elapsed during retry");
    }
}

