/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry.simple;

import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.tinkoff.kora.resilient.retry.simple.SimpleRetrierFailurePredicate;

public record SimpleRetrierConfig(@Nullable Map<String, NamedConfig> retryable) {
    public static final String DEFAULT = "default";

    public NamedConfig getNamedConfig(@Nonnull String name) {
        if (this.retryable == null) {
            throw new IllegalStateException("Retryable no configuration is provided, but either '" + name + "' or 'default' config is required");
        }
        NamedConfig defaultConfig = this.retryable.get(DEFAULT);
        NamedConfig namedConfig = this.retryable.getOrDefault(name, defaultConfig);
        if (namedConfig == null) {
            throw new IllegalStateException("Retryable no configuration is provided, but either '" + name + "' or 'default' config is required");
        }
        NamedConfig mergedConfig = SimpleRetrierConfig.merge(namedConfig, defaultConfig);
        if (mergedConfig.delay == null) {
            throw new IllegalArgumentException("Retryable 'delay' is not configured in either '" + name + "' or 'default' config");
        }
        if (mergedConfig.attempts == null) {
            throw new IllegalArgumentException("Retryable 'attempts' is not configured in either '" + name + "' or 'default' config");
        }
        if (mergedConfig.attempts < 1) {
            throw new IllegalArgumentException("Retryable '" + name + "' attempts can't be less 1, but was " + mergedConfig.attempts);
        }
        return mergedConfig;
    }

    private static NamedConfig merge(NamedConfig namedConfig, NamedConfig defaultConfig) {
        if (defaultConfig == null) {
            return namedConfig;
        }
        return new NamedConfig(namedConfig.delay == null ? defaultConfig.delay : namedConfig.delay, namedConfig.delayStep == null ? defaultConfig.delayStep : namedConfig.delayStep, namedConfig.attempts == null ? defaultConfig.attempts : namedConfig.attempts, namedConfig.failurePredicateName == null ? defaultConfig.failurePredicateName : namedConfig.failurePredicateName);
    }

    public record NamedConfig(@Nullable Duration delay, @Nullable Duration delayStep, @Nullable Integer attempts, @Nullable String failurePredicateName) {
        public NamedConfig(@Nullable Duration delay, @Nullable Duration delayStep, @Nullable Integer attempts, @Nullable String failurePredicateName) {
            this.attempts = attempts;
            this.delay = delay;
            this.delayStep = delayStep == null ? Duration.ZERO : delayStep;
            this.failurePredicateName = failurePredicateName == null ? SimpleRetrierFailurePredicate.class.getCanonicalName() : failurePredicateName;
        }
    }
}

