/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry.simple;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.util.retry.Retry;
import ru.tinkoff.kora.resilient.retry.Retrier;
import ru.tinkoff.kora.resilient.retry.RetrierFailurePredicate;
import ru.tinkoff.kora.resilient.retry.RetryAttemptException;
import ru.tinkoff.kora.resilient.retry.simple.SimpleReactorRetry;
import ru.tinkoff.kora.resilient.retry.simple.SimpleRetrierConfig;
import ru.tinkoff.kora.resilient.retry.simple.SimpleRetryState;
import ru.tinkoff.kora.resilient.retry.telemetry.RetryMetrics;

final class SimpleRetrier
implements Retrier {
    private final String name;
    private final long delayNanos;
    private final long delayStepNanos;
    private final int attempts;
    private final RetrierFailurePredicate failurePredicate;
    private final RetryMetrics metrics;

    SimpleRetrier(String name, long delayNanos, long delayStepNanos, int attempts, RetrierFailurePredicate failurePredicate, RetryMetrics metrics) {
        this.name = name;
        this.delayNanos = delayNanos;
        this.delayStepNanos = delayStepNanos;
        this.attempts = attempts;
        this.failurePredicate = failurePredicate;
        this.metrics = metrics;
    }

    SimpleRetrier(String name, SimpleRetrierConfig.NamedConfig config, RetrierFailurePredicate failurePredicate, RetryMetrics metric) {
        this(name, config.delay().toNanos(), config.delayStep().toNanos(), config.attempts(), failurePredicate, metric);
    }

    @Override
    @Nonnull
    public Retrier.RetryState asState() {
        return new SimpleRetryState(this.name, System.nanoTime(), this.delayNanos, this.delayStepNanos, this.attempts, this.failurePredicate, this.metrics, new AtomicInteger(0));
    }

    @Override
    @Nonnull
    public Retry asReactor() {
        return new SimpleReactorRetry(this.name, this.delayNanos, this.delayStepNanos, this.attempts, this.failurePredicate, this.metrics);
    }

    @Override
    public void retry(@Nonnull Runnable runnable) {
        this.internalRetry(() -> {
            runnable.run();
            return null;
        }, null);
    }

    @Override
    public <T> T retry(@Nonnull Supplier<T> supplier) {
        return this.internalRetry(supplier, null);
    }

    @Override
    public <T> T retry(@Nonnull Supplier<T> supplier, @Nonnull Supplier<T> fallback) {
        return this.internalRetry(supplier, fallback);
    }

    /*
     * Unable to fully structure code
     */
    private <T> T internalRetry(Supplier<T> consumer, @Nullable Supplier<T> fallback) {
        suppressed = new ArrayList<Exception>();
        state = this.asState();
        while (true) {
            try {
                var5_6 = consumer.get();
                return var5_6;
            }
            catch (Exception e) {
                status = state.onException(e);
                if (status == Retrier.RetryState.RetryStatus.REJECTED) {
                    for (Exception exception : suppressed) {
                        e.addSuppressed(exception);
                    }
                    throw e;
                }
                if (status == Retrier.RetryState.RetryStatus.ACCEPTED) {
                    suppressed.add(e);
                    state.doDelay();
                    continue;
                }
                if (status == Retrier.RetryState.RetryStatus.EXHAUSTED) ** break;
                continue;
                if (fallback != null) {
                    try {
                        var7_11 = fallback.get();
                    }
                    catch (Exception ex) {
                        for (Exception exception : suppressed) {
                            ex.addSuppressed(exception);
                        }
                        throw ex;
                    }
                    return var7_11;
                }
                retryAttemptException = new RetryAttemptException(this.attempts, (Throwable)e);
                for (Exception exception : suppressed) {
                    retryAttemptException.addSuppressed(exception);
                }
                throw retryAttemptException;
            }
            break;
        }
        finally {
            if (state != null) {
                state.close();
            }
        }
    }
}

