/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry.simple;

import java.time.Duration;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;
import ru.tinkoff.kora.resilient.retry.RetrierFailurePredicate;
import ru.tinkoff.kora.resilient.retry.RetryAttemptException;
import ru.tinkoff.kora.resilient.retry.telemetry.RetryMetrics;

final class SimpleReactorRetry
extends Retry {
    private final String name;
    private final long delayNanos;
    private final long delayStepNanos;
    private final int attempts;
    private final RetrierFailurePredicate failurePredicate;
    private final RetryMetrics metrics;

    SimpleReactorRetry(String name, long delayNanos, long delayStepNanos, int attempts, RetrierFailurePredicate failurePredicate, RetryMetrics metrics) {
        this.name = name;
        this.delayNanos = delayNanos;
        this.delayStepNanos = delayStepNanos;
        this.attempts = attempts;
        this.failurePredicate = failurePredicate;
        this.metrics = metrics;
    }

    public Publisher<?> generateCompanion(Flux<Retry.RetrySignal> retrySignals) {
        return retrySignals.concatMap(retryWhenState -> {
            Retry.RetrySignal signal = retryWhenState.copy();
            Throwable currentFailure = signal.failure();
            if (currentFailure == null) {
                return Mono.error((Throwable)new IllegalStateException("Retry.RetrySignal#failure() not expected to be null"));
            }
            if (!this.failurePredicate.test(currentFailure)) {
                return Mono.error((Throwable)currentFailure);
            }
            if (signal.totalRetries() >= (long)this.attempts) {
                this.metrics.recordExhaustedAttempts(this.name, this.attempts);
                return Mono.error((Throwable)new RetryAttemptException("All '" + this.attempts + "' attempts elapsed during retry"));
            }
            long nextDelayNanos = this.delayNanos + this.delayStepNanos * (signal.totalRetries() - 1L);
            this.metrics.recordAttempt(this.name, nextDelayNanos);
            return Mono.delay((Duration)Duration.ofNanos(nextDelayNanos), (Scheduler)Schedulers.parallel());
        });
    }
}

