/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry.simple;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import ru.tinkoff.kora.resilient.retry.Retrier;
import ru.tinkoff.kora.resilient.retry.RetrierFailurePredicate;
import ru.tinkoff.kora.resilient.retry.RetryAttemptException;
import ru.tinkoff.kora.resilient.retry.RetryException;
import ru.tinkoff.kora.resilient.retry.telemetry.RetryMetrics;

record SimpleRetrierRetryState(String name, long started, long delayNanos, long delayStepNanos, int attemptsMax, RetrierFailurePredicate failurePredicate, RetryMetrics metrics, AtomicInteger attempts) implements Retrier.RetryState
{
    @Override
    public long getDelayNanos() {
        return this.delayNanos + this.delayStepNanos * (long)this.attempts.get();
    }

    @Override
    public boolean canRetry(@Nonnull Throwable throwable) {
        if (!this.failurePredicate.test(throwable)) {
            return false;
        }
        return this.attempts.incrementAndGet() <= this.attemptsMax;
    }

    @Override
    public void checkRetry(@Nonnull Throwable throwable) throws RetryException {
        if (!this.failurePredicate.test(throwable)) {
            RuntimeException runtimeException;
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                runtimeException = re;
            } else {
                runtimeException = new RetryException(throwable);
            }
            throw runtimeException;
        }
        if (this.attempts.incrementAndGet() > this.attemptsMax) {
            this.metrics.recordExhaustedAttempts(this.name, this.attemptsMax);
            throw new RetryAttemptException("All '" + this.attemptsMax + "' attempts elapsed during retry");
        }
    }

    @Override
    public void doDelay() {
        long nextDelayNanos = this.getDelayNanos();
        this.metrics.recordAttempt(this.name, nextDelayNanos);
        SimpleRetrierRetryState.sleepUninterruptibly(nextDelayNanos);
    }

    private static void sleepUninterruptibly(long sleepForNanos) {
        boolean interrupted = false;
        try {
            long remainingNanos = sleepForNanos;
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                    return;
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

