/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.resilient.retry.simple;

import java.time.Duration;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;
import ru.tinkoff.kora.resilient.retry.RetrierFailurePredicate;
import ru.tinkoff.kora.resilient.retry.RetryAttemptException;
import ru.tinkoff.kora.resilient.retry.simple.SimpleRetryState;
import ru.tinkoff.kora.resilient.retry.telemetry.RetryMetrics;

final class SimpleReactorRetry
extends Retry {
    private static final Logger logger = LoggerFactory.getLogger(SimpleRetryState.class);
    private final String name;
    private final long delayNanos;
    private final long delayStepNanos;
    private final int attempts;
    private final RetrierFailurePredicate failurePredicate;
    private final RetryMetrics metrics;

    SimpleReactorRetry(String name, long delayNanos, long delayStepNanos, int attempts, RetrierFailurePredicate failurePredicate, RetryMetrics metrics) {
        this.name = name;
        this.delayNanos = delayNanos;
        this.delayStepNanos = delayStepNanos;
        this.attempts = attempts;
        this.failurePredicate = failurePredicate;
        this.metrics = metrics;
    }

    public Publisher<?> generateCompanion(Flux<Retry.RetrySignal> retrySignals) {
        return retrySignals.concatMap(retryWhenState -> {
            Retry.RetrySignal signal = retryWhenState.copy();
            Throwable currentFailure = signal.failure();
            if (currentFailure == null) {
                return Mono.error((Throwable)new IllegalStateException("Retry.RetrySignal#failure() not expected to be null"));
            }
            if (!this.failurePredicate.test(currentFailure)) {
                logger.trace("RetryReactor '{}' rejected throwable: {}", (Object)this.name, (Object)currentFailure.getClass().getCanonicalName());
                return Mono.error((Throwable)currentFailure);
            }
            if (signal.totalRetries() >= (long)this.attempts) {
                logger.trace("RetryReactor '{}' exhausted all '{}' attempts", (Object)this.name, (Object)signal.totalRetries());
                this.metrics.recordExhaustedAttempts(this.name, this.attempts);
                return Mono.error((Throwable)new RetryAttemptException(this.attempts));
            }
            long nextDelayNanos = this.delayNanos + this.delayStepNanos * (signal.totalRetries() - 1L);
            Duration delayDuration = Duration.ofNanos(nextDelayNanos);
            logger.trace("RetryState '{}' initiating '{}' retry for '{}' due to throwable: {}", new Object[]{this.name, signal.totalRetries(), delayDuration, currentFailure.getClass().getCanonicalName()});
            this.metrics.recordAttempt(this.name, nextDelayNanos);
            return Mono.delay((Duration)delayDuration);
        });
    }
}

