/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.ksp;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSValueArgument;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.ksp.KsClassDeclarationsKt;
import com.squareup.kotlinpoet.ksp.OriginatingKSFilesKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.ksp.common.AnnotationUtils;
import ru.tinkoff.kora.ksp.common.KotlinPoetUtils;
import ru.tinkoff.kora.ksp.common.KspCommonUtilsKt;
import ru.tinkoff.kora.scheduling.ksp.QuartzSchedulingGenerator$generate$;
import ru.tinkoff.kora.scheduling.ksp.SchedulingTrigger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lru/tinkoff/kora/scheduling/ksp/QuartzSchedulingGenerator;", "", "env", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "cronScheduleBuilderClassName", "Lcom/squareup/kotlinpoet/ClassName;", "getEnv", "()Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "koraQuartzJobClassName", "schedulerClassName", "schedulingTelemetryClassName", "schedulingTelemetryFactoryClassName", "triggerBuilderClassName", "triggerClassName", "generate", "", "type", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "function", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "builder", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "trigger", "Lru/tinkoff/kora/scheduling/ksp/SchedulingTrigger;", "generateCronConfigRecord", "defaultCron", "", "generateJobClass", "method", "scheduling-ksp"})
public final class QuartzSchedulingGenerator {
    @NotNull
    private final SymbolProcessorEnvironment env;
    @NotNull
    private final ClassName koraQuartzJobClassName;
    @NotNull
    private final ClassName schedulingTelemetryClassName;
    @NotNull
    private final ClassName schedulingTelemetryFactoryClassName;
    @NotNull
    private final ClassName triggerClassName;
    @NotNull
    private final ClassName schedulerClassName;
    @NotNull
    private final ClassName triggerBuilderClassName;
    @NotNull
    private final ClassName cronScheduleBuilderClassName;

    public QuartzSchedulingGenerator(@NotNull SymbolProcessorEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.env = env;
        String[] stringArray = new String[]{"KoraQuartzJob"};
        this.koraQuartzJobClassName = new ClassName("ru.tinkoff.kora.scheduling.quartz", stringArray);
        stringArray = new String[]{"SchedulingTelemetry"};
        this.schedulingTelemetryClassName = new ClassName("ru.tinkoff.kora.scheduling.common.telemetry", stringArray);
        stringArray = new String[]{"SchedulingTelemetryFactory"};
        this.schedulingTelemetryFactoryClassName = new ClassName("ru.tinkoff.kora.scheduling.common.telemetry", stringArray);
        stringArray = new String[]{"Trigger"};
        this.triggerClassName = new ClassName("org.quartz", stringArray);
        stringArray = new String[]{"Scheduler"};
        this.schedulerClassName = new ClassName("org.quartz", stringArray);
        stringArray = new String[]{"TriggerBuilder"};
        this.triggerBuilderClassName = new ClassName("org.quartz", stringArray);
        stringArray = new String[]{"CronScheduleBuilder"};
        this.cronScheduleBuilderClassName = new ClassName("org.quartz", stringArray);
    }

    @NotNull
    public final SymbolProcessorEnvironment getEnv() {
        return this.env;
    }

    /*
     * WARNING - void declaration
     */
    public final void generate(@NotNull KSClassDeclaration type, @NotNull KSFunctionDeclaration function, @NotNull TypeSpec.Builder builder, @NotNull SchedulingTrigger trigger) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        ClassName jobClassName = this.generateJobClass(type, function);
        ClassName typeClassName = KsClassDeclarationsKt.toClassName((KSClassDeclaration)type);
        FunSpec.Builder component = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("_" + type.getSimpleName().getShortName() + "_" + function.getSimpleName().getShortName() + "_Job"), (TypeName)((TypeName)jobClassName), null, (int)2, null).addParameter("telemetryFactory", (TypeName)this.schedulingTelemetryFactoryClassName, new KModifier[0]).addParameter("target", (TypeName)typeClassName, new KModifier[0]);
        Object[] objectArray = trigger.getAnnotation().getShortName().getShortName();
        if (Intrinsics.areEqual((Object)objectArray, (Object)"ScheduleWithTrigger")) {
            void $this$findValue$iv;
            AnnotationUtils $this$findValue$iv2;
            AnnotationUtils annotationUtils = AnnotationUtils.INSTANCE;
            KSAnnotation kSAnnotation = trigger.getAnnotation();
            String name$iv = "value";
            boolean $i$f$findValue = false;
            Object object = SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv2.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KSValueArgument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    KSName kSName = it.getName();
                    Intrinsics.checkNotNull((Object)kSName);
                    return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                }
            })), (Function1)generate$$inlined$findValue$2.INSTANCE), (Function1)generate$$inlined$findValue$3.INSTANCE));
            Intrinsics.checkNotNull((Object)object);
            KSAnnotation tag = (KSAnnotation)object;
            AnnotationSpec.Builder builder2 = AnnotationSpec.Companion.builder(Reflection.getOrCreateKotlinClass(Tag.class));
            $this$findValue$iv2 = AnnotationUtils.INSTANCE;
            name$iv = tag;
            String name$iv2 = "value";
            boolean $i$f$findValue2 = false;
            Object object2 = SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv2){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KSValueArgument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    KSName kSName = it.getName();
                    Intrinsics.checkNotNull((Object)kSName);
                    return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                }
            })), (Function1)generate$$inlined$findValue$5.INSTANCE), (Function1)generate$$inlined$findValue$6.INSTANCE));
            Intrinsics.checkNotNull((Object)object2);
            AnnotationSpec tagAnnotationSpec = builder2.addMember(KotlinPoetUtils.INSTANCE.writeTagValue((List)object2, "value")).build();
            ParameterSpec triggerParameter = ParameterSpec.Companion.builder("trigger", (TypeName)this.triggerClassName, new KModifier[0]).addAnnotation(tagAnnotationSpec).build();
            component.addParameter(triggerParameter);
        } else if (Intrinsics.areEqual((Object)objectArray, (Object)"ScheduleWithCron")) {
            void $this$findValue$iv;
            AnnotationUtils $this$findValue$iv3;
            Object object;
            void $this$findValue$iv4;
            AnnotationUtils tagAnnotationSpec = AnnotationUtils.INSTANCE;
            KSAnnotation triggerParameter = trigger.getAnnotation();
            String name$iv = "identity";
            boolean $i$f$findValue22 = false;
            String it = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv4.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KSValueArgument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    KSName kSName = it.getName();
                    Intrinsics.checkNotNull((Object)kSName);
                    return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                }
            })), (Function1)generate$$inlined$findValue$8.INSTANCE), (Function1)generate$$inlined$findValue$9.INSTANCE));
            boolean $i$a$-let-QuartzSchedulingGenerator$generate$identity$22 = false;
            CharSequence $i$f$findValue22 = it;
            if ($i$f$findValue22 == null || StringsKt.isBlank((CharSequence)$i$f$findValue22)) {
                KSName kSName = type.getQualifiedName();
                Intrinsics.checkNotNull((Object)kSName);
                object = kSName.asString() + "#" + function.getSimpleName().getShortName();
            } else {
                object = it;
            }
            String identity = object;
            AnnotationUtils $i$a$-let-QuartzSchedulingGenerator$generate$identity$22 = AnnotationUtils.INSTANCE;
            $i$f$findValue22 = trigger.getAnnotation();
            String name$iv3 = "value";
            boolean $i$f$findValue = false;
            String string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv3.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv3){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KSValueArgument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    KSName kSName = it.getName();
                    Intrinsics.checkNotNull((Object)kSName);
                    return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                }
            })), (Function1)generate$$inlined$findValue$11.INSTANCE), (Function1)generate$$inlined$findValue$12.INSTANCE));
            if (string == null) {
                string = "";
            }
            String cron = string;
            Object[] this_$iv = new Object[]{cron};
            CodeBlock cronSchedule = CodeBlock.Companion.of("%S", this_$iv);
            $this$findValue$iv3 = AnnotationUtils.INSTANCE;
            name$iv3 = trigger.getAnnotation();
            String name$iv4 = "config";
            boolean $i$f$findValue3 = false;
            String configPath = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv4){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KSValueArgument it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    KSName kSName = it.getName();
                    Intrinsics.checkNotNull((Object)kSName);
                    return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                }
            })), (Function1)generate$$inlined$findValue$14.INSTANCE), (Function1)generate$$inlined$findValue$15.INSTANCE));
            CharSequence this_$iv2 = configPath;
            if (!(this_$iv2 == null || StringsKt.isBlank((CharSequence)this_$iv2))) {
                ClassName configClassName = this.generateCronConfigRecord(type, function, cron);
                Object[] objectArray2 = new String[]{"Config"};
                FunSpec.Builder b = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(configClassName.getSimpleName()), (TypeName)((TypeName)configClassName), null, (int)2, null).addParameter("config", (TypeName)new ClassName("com.typesafe.config", (String[])objectArray2), new KModifier[0]);
                if (!StringsKt.isBlank((CharSequence)cron)) {
                    objectArray2 = new Object[]{configPath, configClassName, cron};
                    b.addCode("if (!config.hasPath(%S)) {\n  return %T(%S);\n}\n", objectArray2);
                }
                objectArray2 = new Object[]{configPath, configClassName};
                b.addCode("val value = config.getValue(%S)\nif (value.valueType() != com.typesafe.config.ConfigValueType.STRING) {\n  throw ru.tinkoff.kora.config.common.extractor.ConfigValueExtractionException.unexpectedValueType(value, com.typesafe.config.ConfigValueType.STRING)\n}\nreturn %T(value.unwrapped().toString());", objectArray2);
                builder.addFunction(b.build());
                component.addParameter("config", (TypeName)configClassName, new KModifier[0]);
                cronSchedule = CodeBlock.Companion.of("config.cron", new Object[0]);
            }
            Object[] objectArray3 = new Object[]{this.triggerBuilderClassName, identity, this.cronScheduleBuilderClassName, cronSchedule.toString()};
            component.addCode("val trigger = %T.newTrigger()\n  .withIdentity(%S)\n  .withSchedule(%T.cronSchedule(%L))\n  .build();\n", objectArray3);
        }
        objectArray = new Object[]{typeClassName, function.getSimpleName().getShortName()};
        component.addCode("val telemetry = telemetryFactory.get(%T::class.java, %S);\n", objectArray);
        objectArray = new Object[]{jobClassName};
        component.addCode("return %T(telemetry, target, trigger);\n", objectArray);
        builder.addFunction(component.build());
    }

    private final ClassName generateJobClass(KSClassDeclaration type, KSFunctionDeclaration method) {
        CodeBlock codeBlock;
        boolean bl;
        Object[] $this$none$iv;
        String packageName;
        String className;
        block5: {
            className = KspCommonUtilsKt.getOuterClassesAsPrefix((KSAnnotated)((KSAnnotated)type)) + type.getSimpleName().getShortName() + "_" + method.getSimpleName().getShortName() + "_Job";
            packageName = type.getPackageName().asString();
            $this$none$iv = (Object[])method.getParameters();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object t : $this$none$iv) {
                    KSValueParameter it = (KSValueParameter)t;
                    boolean bl2 = false;
                    if (!(!it.getHasDefault())) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            $this$none$iv = new Object[]{method.getSimpleName().getShortName()};
            codeBlock = CodeBlock.Companion.of("{ ctx -> target.%L() }", $this$none$iv);
        } else {
            $this$none$iv = new Object[]{method.getSimpleName().getShortName()};
            codeBlock = CodeBlock.Companion.of("{ ctx -> target.%L(ctx) }", $this$none$iv);
        }
        CodeBlock callJob = codeBlock;
        ClassName typeClassName = KsClassDeclarationsKt.toClassName((KSClassDeclaration)type);
        Object[] objectArray = new KModifier[]{KModifier.PRIVATE, KModifier.FINAL};
        TypeSpec typeSpec = TypeSpec.Companion.classBuilder(className).superclass((TypeName)this.koraQuartzJobClassName).addSuperclassConstructorParameter(CodeBlock.Companion.of("telemetry", new Object[0])).addSuperclassConstructorParameter(callJob).addSuperclassConstructorParameter(CodeBlock.Companion.of("trigger", new Object[0])).addProperty(PropertySpec.Companion.builder("target", (TypeName)typeClassName, objectArray).initializer("target", new Object[0]).build()).primaryConstructor(FunSpec.Companion.constructorBuilder().addParameter("telemetry", (TypeName)this.schedulingTelemetryClassName, new KModifier[0]).addParameter("target", (TypeName)typeClassName, new KModifier[0]).addParameter("trigger", (TypeName)this.triggerClassName, new KModifier[0]).build()).build();
        FileSpec fileSpec = FileSpec.Companion.get(packageName, typeSpec);
        CodeGenerator codeGenerator = this.env.getCodeGenerator();
        KSFile kSFile = type.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        OriginatingKSFilesKt.writeTo((FileSpec)fileSpec, (CodeGenerator)codeGenerator, (boolean)false, (Iterable)CollectionsKt.listOf((Object)kSFile));
        objectArray = new String[]{className};
        return new ClassName(packageName, (String[])objectArray);
    }

    private final ClassName generateCronConfigRecord(KSClassDeclaration type, KSFunctionDeclaration function, String defaultCron) {
        String configClassName = KspCommonUtilsKt.getOuterClassesAsPrefix((KSAnnotated)((KSAnnotated)type)) + type.getSimpleName().getShortName() + "_" + function.getSimpleName().getShortName() + "_CronConfig";
        FunSpec.Builder constructor = FunSpec.Companion.constructorBuilder();
        if (StringsKt.isBlank((CharSequence)defaultCron)) {
            constructor.addParameter("cron", (TypeName)TypeNames.STRING, new KModifier[0]);
        } else {
            Object[] objectArray = new Object[]{defaultCron};
            constructor.addParameter(ParameterSpec.Companion.builder("cron", (TypeName)TypeNames.STRING, new KModifier[0]).defaultValue(CodeBlock.Companion.of("%S", objectArray)).build());
        }
        Object[] objectArray = new KModifier[]{KModifier.PUBLIC, KModifier.DATA};
        TypeSpec configType = TypeSpec.Companion.classBuilder(configClassName).addModifiers(objectArray).addProperty(PropertySpec.Companion.builder("cron", (TypeName)TypeNames.STRING, new KModifier[0]).initializer("cron", new Object[0]).build()).primaryConstructor(constructor.build()).build();
        FileSpec fileSpec = FileSpec.Companion.get(type.getPackageName().asString(), configType);
        CodeGenerator codeGenerator = this.env.getCodeGenerator();
        KSFile kSFile = type.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        OriginatingKSFilesKt.writeTo((FileSpec)fileSpec, (CodeGenerator)codeGenerator, (boolean)false, (Iterable)CollectionsKt.listOf((Object)kSFile));
        objectArray = new String[]{configClassName};
        return new ClassName(type.getPackageName().asString(), (String[])objectArray);
    }
}

