/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.scheduling.ksp;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSValueArgument;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.ksp.KsClassDeclarationsKt;
import com.squareup.kotlinpoet.ksp.KsTypesKt;
import com.squareup.kotlinpoet.ksp.OriginatingKSFilesKt;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.tinkoff.kora.ksp.common.AnnotationUtils;
import ru.tinkoff.kora.ksp.common.KspCommonUtils;
import ru.tinkoff.kora.ksp.common.KspCommonUtilsKt;
import ru.tinkoff.kora.ksp.common.exception.ProcessingErrorException;
import ru.tinkoff.kora.scheduling.ksp.JdkSchedulingGenerator$generateScheduleAtFixedRate$;
import ru.tinkoff.kora.scheduling.ksp.JdkSchedulingGenerator$generateScheduleOnce$;
import ru.tinkoff.kora.scheduling.ksp.JdkSchedulingGenerator$generateScheduleWithFixedDelay$;
import ru.tinkoff.kora.scheduling.ksp.SchedulingTrigger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J1\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u0019\"\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J(\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J(\u0010#\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J(\u0010$\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lru/tinkoff/kora/scheduling/ksp/JdkSchedulingGenerator;", "", "environment", "Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "(Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;)V", "getEnvironment", "()Lcom/google/devtools/ksp/processing/SymbolProcessorEnvironment;", "fixedDelayJobClassName", "Lcom/squareup/kotlinpoet/ClassName;", "fixedRateJobClassName", "runOnceJobClassName", "schedulingTelemetryFactoryClassName", "configComponent", "Lcom/squareup/kotlinpoet/FunSpec;", "packageName", "", "configClassName", "configPath", "configType", "Lcom/squareup/kotlinpoet/TypeSpec;", "type", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "function", "Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;", "params", "", "Lru/tinkoff/kora/scheduling/ksp/JdkSchedulingGenerator$ConfigParameter;", "(Lcom/google/devtools/ksp/symbol/KSClassDeclaration;Lcom/google/devtools/ksp/symbol/KSFunctionDeclaration;[Lru/tinkoff/kora/scheduling/ksp/JdkSchedulingGenerator$ConfigParameter;)Lcom/squareup/kotlinpoet/TypeSpec;", "generate", "", "builder", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "trigger", "Lru/tinkoff/kora/scheduling/ksp/SchedulingTrigger;", "generateScheduleAtFixedRate", "generateScheduleOnce", "generateScheduleWithFixedDelay", "ConfigParameter", "scheduling-ksp"})
public final class JdkSchedulingGenerator {
    @NotNull
    private final SymbolProcessorEnvironment environment;
    @NotNull
    private final ClassName fixedDelayJobClassName;
    @NotNull
    private final ClassName fixedRateJobClassName;
    @NotNull
    private final ClassName runOnceJobClassName;
    @NotNull
    private final ClassName schedulingTelemetryFactoryClassName;

    public JdkSchedulingGenerator(@NotNull SymbolProcessorEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
        String[] stringArray = new String[]{"FixedDelayJob"};
        this.fixedDelayJobClassName = new ClassName("ru.tinkoff.kora.scheduling.jdk", stringArray);
        stringArray = new String[]{"FixedRateJob"};
        this.fixedRateJobClassName = new ClassName("ru.tinkoff.kora.scheduling.jdk", stringArray);
        stringArray = new String[]{"RunOnceJob"};
        this.runOnceJobClassName = new ClassName("ru.tinkoff.kora.scheduling.jdk", stringArray);
        stringArray = new String[]{"SchedulingTelemetryFactory"};
        this.schedulingTelemetryFactoryClassName = new ClassName("ru.tinkoff.kora.scheduling.common.telemetry", stringArray);
    }

    @NotNull
    public final SymbolProcessorEnvironment getEnvironment() {
        return this.environment;
    }

    public final void generate(@NotNull KSClassDeclaration type, @NotNull KSFunctionDeclaration function, @NotNull TypeSpec.Builder builder, @NotNull SchedulingTrigger trigger) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        switch (trigger.getAnnotation().getShortName().asString()) {
            case "ScheduleAtFixedRate": {
                this.generateScheduleAtFixedRate(type, function, builder, trigger);
                break;
            }
            case "ScheduleWithFixedDelay": {
                this.generateScheduleWithFixedDelay(type, function, builder, trigger);
                break;
            }
            case "ScheduleOnce": {
                this.generateScheduleOnce(type, function, builder, trigger);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateScheduleAtFixedRate(KSClassDeclaration type, KSFunctionDeclaration function, TypeSpec.Builder builder, SchedulingTrigger trigger) {
        FunSpec.Builder componentFunction;
        block8: {
            CodeBlock codeBlock;
            ClassName unit;
            Long period;
            long initialDelay;
            String configName;
            String packageName;
            block5: {
                Object[] $this$findValue$iv22;
                block7: {
                    block6: {
                        KSAnnotation $this$findValue$iv;
                        void $this$findValue$iv3;
                        packageName = type.getPackageName().asString();
                        AnnotationUtils annotationUtils = AnnotationUtils.INSTANCE;
                        KSAnnotation kSAnnotation = trigger.getAnnotation();
                        String name$iv = "config";
                        boolean $i$f$findValue = false;
                        configName = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv3.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleAtFixedRate$$inlined$findValue$2.INSTANCE), (Function1)generateScheduleAtFixedRate$$inlined$findValue$3.INSTANCE));
                        ClassName typeClassName = KsClassDeclarationsKt.toClassName((KSClassDeclaration)type);
                        String jobFunName = KspCommonUtilsKt.getOuterClassesAsPrefix((KSAnnotated)((KSAnnotated)type)) + type.getSimpleName().getShortName() + "_" + function.getSimpleName().getShortName() + "_Job";
                        AnnotationUtils annotationUtils2 = AnnotationUtils.INSTANCE;
                        KSAnnotation kSAnnotation2 = trigger.getAnnotation();
                        String name$iv2 = "initialDelay";
                        boolean $i$f$findValue2 = false;
                        Long l = (Long)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv2){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleAtFixedRate$$inlined$findValue$5.INSTANCE), (Function1)generateScheduleAtFixedRate$$inlined$findValue$6.INSTANCE));
                        initialDelay = l != null ? l : 0L;
                        AnnotationUtils this_$iv = AnnotationUtils.INSTANCE;
                        $this$findValue$iv = trigger.getAnnotation();
                        name$iv2 = "period";
                        $i$f$findValue2 = false;
                        period = (Long)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv2){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleAtFixedRate$$inlined$findValue$8.INSTANCE), (Function1)generateScheduleAtFixedRate$$inlined$findValue$9.INSTANCE));
                        $this$findValue$iv = AnnotationUtils.INSTANCE;
                        name$iv2 = trigger.getAnnotation();
                        String name$iv3 = "unit";
                        boolean $i$f$findValue3 = false;
                        Object object = SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv22.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv3){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleAtFixedRate$$inlined$findValue$11.INSTANCE), (Function1)generateScheduleAtFixedRate$$inlined$findValue$12.INSTANCE));
                        Intrinsics.checkNotNull((Object)object);
                        unit = KsTypesKt.toClassName((KSType)((KSType)object));
                        $this$findValue$iv22 = new Object[]{typeClassName, function.getSimpleName().getShortName()};
                        componentFunction = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(jobFunName).addParameter("telemetryFactory", (TypeName)this.schedulingTelemetryFactoryClassName, new KModifier[0]).addParameter("service", (TypeName)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(ScheduledExecutorService.class)), new KModifier[0]).addParameter("target", (TypeName)typeClassName, new KModifier[0]), (TypeName)((TypeName)this.fixedRateJobClassName), null, (int)2, null).addCode("val telemetry = telemetryFactory.get(%T::class.java, %S);\n", $this$findValue$iv22);
                        $this$findValue$iv22 = configName;
                        if (!($this$findValue$iv22 == null || StringsKt.isBlank((CharSequence)$this$findValue$iv22))) break block5;
                        if (period == null) break block6;
                        long $this$findValue$iv22 = 0L;
                        if (period != $this$findValue$iv22) break block7;
                    }
                    throw new ProcessingErrorException("Either period() or config() annotation parameter must be provided", (KSAnnotated)function);
                }
                $this$findValue$iv22 = new Object[]{Reflection.getOrCreateKotlinClass(Duration.class), period, unit};
                FunSpec.Builder builder2 = componentFunction.addCode("val initialDelay = %T.of(%L, %L);\n", $this$findValue$iv22);
                $this$findValue$iv22 = new Object[]{Reflection.getOrCreateKotlinClass(Duration.class), period, unit};
                builder2.addCode("val period = %T.of(%L, %L);\n", $this$findValue$iv22);
                break block8;
            }
            JdkSchedulingGenerator jdkSchedulingGenerator = this;
            KSClassDeclaration kSClassDeclaration = type;
            KSFunctionDeclaration kSFunctionDeclaration = function;
            Object[] objectArray = new ConfigParameter[2];
            ConfigParameter[] configParameterArray = objectArray;
            int n = 0;
            String string = "period";
            ClassName className = ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Duration.class));
            Long l = period;
            if (l != null) {
                void it;
                long l2 = ((Number)l).longValue();
                ClassName className2 = className;
                String string2 = string;
                int n2 = n;
                ConfigParameter[] configParameterArray2 = configParameterArray;
                KSFunctionDeclaration kSFunctionDeclaration2 = kSFunctionDeclaration;
                KSClassDeclaration kSClassDeclaration2 = kSClassDeclaration;
                JdkSchedulingGenerator jdkSchedulingGenerator2 = jdkSchedulingGenerator;
                boolean bl = false;
                Object[] objectArray2 = new Object[]{Reflection.getOrCreateKotlinClass(Duration.class), (long)it, unit};
                CodeBlock codeBlock2 = CodeBlock.Companion.of("%T.of(%L, %L)", objectArray2);
                jdkSchedulingGenerator = jdkSchedulingGenerator2;
                kSClassDeclaration = kSClassDeclaration2;
                kSFunctionDeclaration = kSFunctionDeclaration2;
                configParameterArray = configParameterArray2;
                n = n2;
                string = string2;
                className = className2;
                codeBlock = codeBlock2;
            } else {
                codeBlock = null;
            }
            CodeBlock codeBlock3 = codeBlock;
            ClassName className3 = className;
            String string3 = string;
            configParameterArray[n] = new ConfigParameter(string3, className3, codeBlock3);
            Object[] objectArray3 = new Object[]{Reflection.getOrCreateKotlinClass(Duration.class), initialDelay, unit};
            objectArray[1] = new ConfigParameter("initialDelay", ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Duration.class)), CodeBlock.Companion.of("%T.of(%L, %L)", objectArray3));
            TypeSpec configType = jdkSchedulingGenerator.configType(kSClassDeclaration, kSFunctionDeclaration, (ConfigParameter[])objectArray);
            FileSpec fileSpec = FileSpec.Companion.get(packageName, configType);
            CodeGenerator codeGenerator = this.environment.getCodeGenerator();
            KSFile kSFile = type.getContainingFile();
            Intrinsics.checkNotNull((Object)kSFile);
            OriginatingKSFilesKt.writeTo((FileSpec)fileSpec, (CodeGenerator)codeGenerator, (boolean)false, (Iterable)CollectionsKt.listOf((Object)kSFile));
            objectArray = new String[1];
            Intrinsics.checkNotNull((Object)configType.getName());
            componentFunction.addParameter("config", (TypeName)new ClassName(packageName, (String[])objectArray), new KModifier[0]).addCode("val period = config.period;\n", new Object[0]).addCode("val initialDelay = config.initialDelay;\n", new Object[0]);
            String string4 = configType.getName();
            Intrinsics.checkNotNull((Object)string4);
            builder.addFunction(this.configComponent(packageName, string4, configName));
        }
        Object[] objectArray = new Object[]{this.fixedRateJobClassName, function.getSimpleName().getShortName()};
        componentFunction.addCode("return %T(telemetry, service, { target.%L() }, initialDelay, period);\n", objectArray);
        builder.addFunction(componentFunction.build());
    }

    /*
     * WARNING - void declaration
     */
    private final void generateScheduleWithFixedDelay(KSClassDeclaration type, KSFunctionDeclaration function, TypeSpec.Builder builder, SchedulingTrigger trigger) {
        FunSpec.Builder componentFunction;
        block8: {
            CodeBlock codeBlock;
            ClassName unit;
            Long delay;
            long initialDelay;
            String configName;
            String packageName;
            block5: {
                Object[] $this$findValue$iv22;
                block7: {
                    block6: {
                        KSAnnotation $this$findValue$iv;
                        void $this$findValue$iv3;
                        packageName = type.getPackageName().asString();
                        AnnotationUtils annotationUtils = AnnotationUtils.INSTANCE;
                        KSAnnotation kSAnnotation = trigger.getAnnotation();
                        String name$iv = "config";
                        boolean $i$f$findValue = false;
                        configName = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv3.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleWithFixedDelay$$inlined$findValue$2.INSTANCE), (Function1)generateScheduleWithFixedDelay$$inlined$findValue$3.INSTANCE));
                        ClassName typeClassName = KsClassDeclarationsKt.toClassName((KSClassDeclaration)type);
                        String jobFunName = KspCommonUtilsKt.getOuterClassesAsPrefix((KSAnnotated)((KSAnnotated)type)) + type.getSimpleName().getShortName() + "_" + function.getSimpleName().getShortName() + "_Job";
                        AnnotationUtils annotationUtils2 = AnnotationUtils.INSTANCE;
                        KSAnnotation kSAnnotation2 = trigger.getAnnotation();
                        String name$iv2 = "initialDelay";
                        boolean $i$f$findValue2 = false;
                        Long l = (Long)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv2){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleWithFixedDelay$$inlined$findValue$5.INSTANCE), (Function1)generateScheduleWithFixedDelay$$inlined$findValue$6.INSTANCE));
                        initialDelay = l != null ? l : 0L;
                        AnnotationUtils this_$iv = AnnotationUtils.INSTANCE;
                        $this$findValue$iv = trigger.getAnnotation();
                        name$iv2 = "delay";
                        $i$f$findValue2 = false;
                        delay = (Long)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv2){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleWithFixedDelay$$inlined$findValue$8.INSTANCE), (Function1)generateScheduleWithFixedDelay$$inlined$findValue$9.INSTANCE));
                        $this$findValue$iv = AnnotationUtils.INSTANCE;
                        name$iv2 = trigger.getAnnotation();
                        String name$iv3 = "unit";
                        boolean $i$f$findValue3 = false;
                        Object object = SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv22.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv3){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleWithFixedDelay$$inlined$findValue$11.INSTANCE), (Function1)generateScheduleWithFixedDelay$$inlined$findValue$12.INSTANCE));
                        Intrinsics.checkNotNull((Object)object);
                        unit = KsTypesKt.toClassName((KSType)((KSType)object));
                        $this$findValue$iv22 = new Object[]{typeClassName, function.getSimpleName().getShortName()};
                        componentFunction = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(jobFunName).addParameter("telemetryFactory", (TypeName)this.schedulingTelemetryFactoryClassName, new KModifier[0]).addParameter("service", (TypeName)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(ScheduledExecutorService.class)), new KModifier[0]).addParameter("target", (TypeName)typeClassName, new KModifier[0]), (TypeName)((TypeName)this.fixedDelayJobClassName), null, (int)2, null).addCode("val telemetry = telemetryFactory.get(%T::class.java, %S);\n", $this$findValue$iv22);
                        $this$findValue$iv22 = configName;
                        if (!($this$findValue$iv22 == null || StringsKt.isBlank((CharSequence)$this$findValue$iv22))) break block5;
                        if (delay == null) break block6;
                        long $this$findValue$iv22 = 0L;
                        if (delay != $this$findValue$iv22) break block7;
                    }
                    throw new ProcessingErrorException("Either delay() or config() annotation parameter must be provided", (KSAnnotated)function);
                }
                $this$findValue$iv22 = new Object[]{Reflection.getOrCreateKotlinClass(Duration.class), delay, unit};
                FunSpec.Builder builder2 = componentFunction.addCode("val initialDelay = %T.of(%L, %L);\n", $this$findValue$iv22);
                $this$findValue$iv22 = new Object[]{Reflection.getOrCreateKotlinClass(Duration.class), delay, unit};
                builder2.addCode("val delay = %T.of(%L, %L);\n", $this$findValue$iv22);
                break block8;
            }
            JdkSchedulingGenerator jdkSchedulingGenerator = this;
            KSClassDeclaration kSClassDeclaration = type;
            KSFunctionDeclaration kSFunctionDeclaration = function;
            Object[] objectArray = new ConfigParameter[2];
            ConfigParameter[] configParameterArray = objectArray;
            int n = 0;
            String string = "delay";
            ClassName className = ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Duration.class));
            Long l = delay;
            if (l != null) {
                void it;
                long l2 = ((Number)l).longValue();
                ClassName className2 = className;
                String string2 = string;
                int n2 = n;
                ConfigParameter[] configParameterArray2 = configParameterArray;
                KSFunctionDeclaration kSFunctionDeclaration2 = kSFunctionDeclaration;
                KSClassDeclaration kSClassDeclaration2 = kSClassDeclaration;
                JdkSchedulingGenerator jdkSchedulingGenerator2 = jdkSchedulingGenerator;
                boolean bl = false;
                Object[] objectArray2 = new Object[]{Reflection.getOrCreateKotlinClass(Duration.class), (long)it, unit};
                CodeBlock codeBlock2 = CodeBlock.Companion.of("%T.of(%L, %L)", objectArray2);
                jdkSchedulingGenerator = jdkSchedulingGenerator2;
                kSClassDeclaration = kSClassDeclaration2;
                kSFunctionDeclaration = kSFunctionDeclaration2;
                configParameterArray = configParameterArray2;
                n = n2;
                string = string2;
                className = className2;
                codeBlock = codeBlock2;
            } else {
                codeBlock = null;
            }
            CodeBlock codeBlock3 = codeBlock;
            ClassName className3 = className;
            String string3 = string;
            configParameterArray[n] = new ConfigParameter(string3, className3, codeBlock3);
            Object[] objectArray3 = new Object[]{Reflection.getOrCreateKotlinClass(Duration.class), initialDelay, unit};
            objectArray[1] = new ConfigParameter("initialDelay", ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Duration.class)), CodeBlock.Companion.of("%T.of(%L, %L)", objectArray3));
            TypeSpec configType = jdkSchedulingGenerator.configType(kSClassDeclaration, kSFunctionDeclaration, (ConfigParameter[])objectArray);
            FileSpec fileSpec = FileSpec.Companion.get(packageName, configType);
            CodeGenerator codeGenerator = this.environment.getCodeGenerator();
            KSFile kSFile = type.getContainingFile();
            Intrinsics.checkNotNull((Object)kSFile);
            OriginatingKSFilesKt.writeTo((FileSpec)fileSpec, (CodeGenerator)codeGenerator, (boolean)false, (Iterable)CollectionsKt.listOf((Object)kSFile));
            objectArray = new String[1];
            Intrinsics.checkNotNull((Object)configType.getName());
            componentFunction.addParameter("config", (TypeName)new ClassName(packageName, (String[])objectArray), new KModifier[0]).addCode("val delay = config.delay;\n", new Object[0]).addCode("val initialDelay = config.initialDelay;\n", new Object[0]);
            String string4 = configType.getName();
            Intrinsics.checkNotNull((Object)string4);
            builder.addFunction(this.configComponent(packageName, string4, configName));
        }
        Object[] objectArray = new Object[]{this.fixedDelayJobClassName, function.getSimpleName().getShortName()};
        componentFunction.addCode("return %T(telemetry, service, { target.%L() }, initialDelay, delay);\n", objectArray);
        builder.addFunction(componentFunction.build());
    }

    /*
     * WARNING - void declaration
     */
    private final void generateScheduleOnce(KSClassDeclaration type, KSFunctionDeclaration function, TypeSpec.Builder builder, SchedulingTrigger trigger) {
        FunSpec.Builder componentFunction;
        block8: {
            CodeBlock codeBlock;
            ClassName unit;
            Long delay;
            String configName;
            String packageName;
            block5: {
                Object[] $this$findValue$iv22;
                block7: {
                    block6: {
                        AnnotationUtils $this$findValue$iv;
                        void $this$findValue$iv3;
                        packageName = type.getPackageName().asString();
                        AnnotationUtils annotationUtils = AnnotationUtils.INSTANCE;
                        KSAnnotation kSAnnotation = trigger.getAnnotation();
                        String name$iv = "config";
                        boolean $i$f$findValue22 = false;
                        configName = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv3.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleOnce$$inlined$findValue$2.INSTANCE), (Function1)generateScheduleOnce$$inlined$findValue$3.INSTANCE));
                        ClassName typeClassName = KsClassDeclarationsKt.toClassName((KSClassDeclaration)type);
                        String jobFunName = KspCommonUtilsKt.getOuterClassesAsPrefix((KSAnnotated)((KSAnnotated)type)) + type.getSimpleName().getShortName() + "_" + function.getSimpleName().getShortName() + "_Job";
                        AnnotationUtils $i$f$findValue22 = AnnotationUtils.INSTANCE;
                        KSAnnotation kSAnnotation2 = trigger.getAnnotation();
                        String name$iv2 = "delay";
                        boolean $i$f$findValue = false;
                        delay = (Long)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv2){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleOnce$$inlined$findValue$5.INSTANCE), (Function1)generateScheduleOnce$$inlined$findValue$6.INSTANCE));
                        $this$findValue$iv = AnnotationUtils.INSTANCE;
                        name$iv2 = trigger.getAnnotation();
                        String name$iv3 = "unit";
                        boolean $i$f$findValue3 = false;
                        Object object = SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$this$findValue$iv22.getArguments()), (Function1)((Function1)new Function1<KSValueArgument, Boolean>(name$iv3){
                            final /* synthetic */ String $name;
                            {
                                this.$name = $name;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull KSValueArgument it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                KSName kSName = it.getName();
                                Intrinsics.checkNotNull((Object)kSName);
                                return Intrinsics.areEqual((Object)kSName.asString(), (Object)this.$name);
                            }
                        })), (Function1)generateScheduleOnce$$inlined$findValue$8.INSTANCE), (Function1)generateScheduleOnce$$inlined$findValue$9.INSTANCE));
                        Intrinsics.checkNotNull((Object)object);
                        unit = KsTypesKt.toClassName((KSType)((KSType)object));
                        $this$findValue$iv22 = new Object[]{typeClassName, function.getSimpleName().getShortName()};
                        componentFunction = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(jobFunName).addParameter("telemetryFactory", (TypeName)this.schedulingTelemetryFactoryClassName, new KModifier[0]).addParameter("service", (TypeName)ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(ScheduledExecutorService.class)), new KModifier[0]).addParameter("target", (TypeName)typeClassName, new KModifier[0]), (TypeName)((TypeName)this.runOnceJobClassName), null, (int)2, null).addCode("val telemetry = telemetryFactory.get(%T::class.java, %S);\n", $this$findValue$iv22);
                        $this$findValue$iv22 = configName;
                        if (!($this$findValue$iv22 == null || StringsKt.isBlank((CharSequence)$this$findValue$iv22))) break block5;
                        if (delay == null) break block6;
                        long $this$findValue$iv22 = 0L;
                        if (delay != $this$findValue$iv22) break block7;
                    }
                    throw new ProcessingErrorException("Either delay() or config() annotation parameter must be provided", (KSAnnotated)function);
                }
                $this$findValue$iv22 = new Object[]{Reflection.getOrCreateKotlinClass(Duration.class), delay, unit};
                componentFunction.addCode("val delay = %T.of(%L, %L);\n", $this$findValue$iv22);
                break block8;
            }
            JdkSchedulingGenerator jdkSchedulingGenerator = this;
            KSClassDeclaration kSClassDeclaration = type;
            KSFunctionDeclaration kSFunctionDeclaration = function;
            Object[] objectArray = new ConfigParameter[1];
            ConfigParameter[] configParameterArray = objectArray;
            int n = 0;
            String string = "delay";
            ClassName className = ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Duration.class));
            Long l = delay;
            if (l != null) {
                void it;
                long l2 = ((Number)l).longValue();
                ClassName className2 = className;
                String string2 = string;
                int n2 = n;
                ConfigParameter[] configParameterArray2 = configParameterArray;
                KSFunctionDeclaration kSFunctionDeclaration2 = kSFunctionDeclaration;
                KSClassDeclaration kSClassDeclaration2 = kSClassDeclaration;
                JdkSchedulingGenerator jdkSchedulingGenerator2 = jdkSchedulingGenerator;
                boolean bl = false;
                Object[] objectArray2 = new Object[]{Reflection.getOrCreateKotlinClass(Duration.class), (long)it, unit};
                CodeBlock codeBlock2 = CodeBlock.Companion.of("%T.of(%L, %L)", objectArray2);
                jdkSchedulingGenerator = jdkSchedulingGenerator2;
                kSClassDeclaration = kSClassDeclaration2;
                kSFunctionDeclaration = kSFunctionDeclaration2;
                configParameterArray = configParameterArray2;
                n = n2;
                string = string2;
                className = className2;
                codeBlock = codeBlock2;
            } else {
                codeBlock = null;
            }
            CodeBlock codeBlock3 = codeBlock;
            ClassName className3 = className;
            String string3 = string;
            configParameterArray[n] = new ConfigParameter(string3, className3, codeBlock3);
            TypeSpec configType = jdkSchedulingGenerator.configType(kSClassDeclaration, kSFunctionDeclaration, (ConfigParameter[])objectArray);
            FileSpec fileSpec = FileSpec.Companion.get(packageName, configType);
            CodeGenerator codeGenerator = this.environment.getCodeGenerator();
            KSFile kSFile = type.getContainingFile();
            Intrinsics.checkNotNull((Object)kSFile);
            OriginatingKSFilesKt.writeTo((FileSpec)fileSpec, (CodeGenerator)codeGenerator, (boolean)false, (Iterable)CollectionsKt.listOf((Object)kSFile));
            objectArray = new String[1];
            Intrinsics.checkNotNull((Object)configType.getName());
            componentFunction.addParameter("config", (TypeName)new ClassName(packageName, (String[])objectArray), new KModifier[0]).addCode("val delay = config.delay;\n", new Object[0]);
            String string4 = configType.getName();
            Intrinsics.checkNotNull((Object)string4);
            builder.addFunction(this.configComponent(packageName, string4, configName));
        }
        Object[] objectArray = new Object[]{this.runOnceJobClassName, function.getSimpleName().getShortName()};
        componentFunction.addCode("return %T(telemetry, service, { target.%L() }, delay);\n", objectArray);
        builder.addFunction(componentFunction.build());
    }

    private final FunSpec configComponent(String packageName, String configClassName, String configPath) {
        Object[] objectArray = new String[]{"Config"};
        ClassName className = new ClassName("com.typesafe.config", (String[])objectArray);
        objectArray = new String[]{"ConfigValueExtractor"};
        ClassName className2 = new ClassName("ru.tinkoff.kora.config.common.extractor", (String[])objectArray);
        objectArray = new TypeName[1];
        String[] stringArray = new String[]{configClassName};
        objectArray[0] = (TypeName)new ClassName(packageName, stringArray);
        FunSpec.Builder builder = FunSpec.Companion.builder(configClassName).addParameter("config", (TypeName)className, new KModifier[0]).addParameter("extractor", (TypeName)ParameterizedTypeName.Companion.get(className2, (TypeName[])objectArray), new KModifier[0]);
        objectArray = new Object[]{configPath};
        FunSpec.Builder builder2 = builder.addCode("val configValue = config.getValue(%S);\n", objectArray).addCode("return extractor.extract(configValue);\n", new Object[0]);
        objectArray = new String[]{configClassName};
        return FunSpec.Builder.returns$default((FunSpec.Builder)builder2, (TypeName)((TypeName)new ClassName(packageName, (String[])objectArray)), null, (int)2, null).build();
    }

    private final TypeSpec configType(KSClassDeclaration type, KSFunctionDeclaration function, ConfigParameter ... params) {
        String configClassName = KspCommonUtilsKt.getOuterClassesAsPrefix((KSAnnotated)((KSAnnotated)type)) + type.getSimpleName().getShortName() + "_" + function.getSimpleName().getShortName() + "_Config";
        FunSpec.Builder constructor = FunSpec.Companion.constructorBuilder();
        KModifier[] kModifierArray = new KModifier[]{KModifier.PUBLIC, KModifier.DATA};
        TypeSpec.Builder configType = KspCommonUtils.INSTANCE.generated(TypeSpec.Companion.classBuilder(configClassName).addModifiers(kModifierArray), Reflection.getOrCreateKotlinClass(JdkSchedulingGenerator.class));
        for (ConfigParameter param : params) {
            constructor.addParameter(ParameterSpec.Companion.builder(param.getName(), (TypeName)param.getType(), new KModifier[0]).defaultValue(param.getDefaultValue()).build());
            configType.addProperty(PropertySpec.Companion.builder(param.getName(), (TypeName)param.getType(), new KModifier[0]).initializer(param.getName(), new Object[0]).build());
        }
        return configType.primaryConstructor(constructor.build()).build();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lru/tinkoff/kora/scheduling/ksp/JdkSchedulingGenerator$ConfigParameter;", "", "name", "", "type", "Lcom/squareup/kotlinpoet/ClassName;", "defaultValue", "Lcom/squareup/kotlinpoet/CodeBlock;", "(Ljava/lang/String;Lcom/squareup/kotlinpoet/ClassName;Lcom/squareup/kotlinpoet/CodeBlock;)V", "getDefaultValue", "()Lcom/squareup/kotlinpoet/CodeBlock;", "getName", "()Ljava/lang/String;", "getType", "()Lcom/squareup/kotlinpoet/ClassName;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "scheduling-ksp"})
    private static final class ConfigParameter {
        @NotNull
        private final String name;
        @NotNull
        private final ClassName type;
        @Nullable
        private final CodeBlock defaultValue;

        public ConfigParameter(@NotNull String name, @NotNull ClassName type, @Nullable CodeBlock defaultValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final ClassName getType() {
            return this.type;
        }

        @Nullable
        public final CodeBlock getDefaultValue() {
            return this.defaultValue;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final ClassName component2() {
            return this.type;
        }

        @Nullable
        public final CodeBlock component3() {
            return this.defaultValue;
        }

        @NotNull
        public final ConfigParameter copy(@NotNull String name, @NotNull ClassName type, @Nullable CodeBlock defaultValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new ConfigParameter(name, type, defaultValue);
        }

        public static /* synthetic */ ConfigParameter copy$default(ConfigParameter configParameter, String string, ClassName className, CodeBlock codeBlock, int n, Object object) {
            if ((n & 1) != 0) {
                string = configParameter.name;
            }
            if ((n & 2) != 0) {
                className = configParameter.type;
            }
            if ((n & 4) != 0) {
                codeBlock = configParameter.defaultValue;
            }
            return configParameter.copy(string, className, codeBlock);
        }

        @NotNull
        public String toString() {
            return "ConfigParameter(name=" + this.name + ", type=" + this.type + ", defaultValue=" + this.defaultValue + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConfigParameter)) {
                return false;
            }
            ConfigParameter configParameter = (ConfigParameter)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)configParameter.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)configParameter.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.defaultValue, (Object)configParameter.defaultValue);
        }
    }
}

