/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64InputStream;

public class MultipartParser {
    private static final byte[] end = "--".getBytes(StandardCharsets.UTF_8);
    private static final byte[] br = "\r\n".getBytes(StandardCharsets.UTF_8);
    private static final Pattern BOUNDARY_PATTERN = Pattern.compile(".*boundary=(?<boundary>.*?[;$]).*");
    private static final Pattern START_PATTERN = Pattern.compile(".*start=(?<start>.*?[;$]).*");

    public static MultipartMeta parseMeta(String contentType) {
        Matcher boundary = BOUNDARY_PATTERN.matcher(contentType);
        Matcher start = START_PATTERN.matcher(contentType);
        if (!boundary.matches() || !start.matches()) {
            throw new IllegalStateException();
        }
        String boundaryStr = boundary.group("boundary");
        String startStr = start.group("start");
        if (boundaryStr.endsWith(";")) {
            boundaryStr = boundaryStr.substring(0, boundaryStr.length() - 1);
        }
        if (boundaryStr.startsWith("\"") && boundaryStr.endsWith("\"")) {
            boundaryStr = boundaryStr.substring(1, boundaryStr.length() - 1);
        }
        if (startStr.endsWith(";")) {
            startStr = startStr.substring(0, startStr.length() - 1);
        }
        if (startStr.startsWith("\"") && startStr.endsWith("\"")) {
            startStr = startStr.substring(1, startStr.length() - 1);
        }
        return new MultipartMeta(boundaryStr, startStr);
    }

    private static Part parse(byte[] data, int offset, int length) {
        int i;
        int start = offset;
        String contentType = null;
        String contentId = null;
        for (i = 0; i < length; ++i) {
            byte[] buf = "\r\n".getBytes(StandardCharsets.UTF_8);
            if (!MultipartParser.isMatch(data, buf, i + offset)) continue;
            String line = new String(data, start, i + offset - start, StandardCharsets.UTF_8);
            if (line.isEmpty()) break;
            String[] header = line.split(": ");
            if (header[0].equalsIgnoreCase("content-type")) {
                contentType = header[1];
            } else if (header[0].equalsIgnoreCase("content-id")) {
                contentId = header[1];
            }
            start = i + offset + 2;
        }
        return new Part(contentId, contentType, data, i + offset + 2, length - (i + 2));
    }

    public static Map<String, Part> parse(byte[] body, String boundaryString) {
        byte[] buf;
        int pos;
        byte[] boundary = ("--" + boundaryString).getBytes();
        HashMap<String, Part> result = new HashMap<String, Part>();
        int n = pos = MultipartParser.isMatch(body, br, 0) ? 2 : 0;
        if (!MultipartParser.isMatch(body, boundary, pos)) {
            throw new IllegalStateException("Can't read message: invalid start");
        }
        int blockStart = boundary.length + pos;
        while (Arrays.equals(buf = new byte[]{body[blockStart], body[blockStart + 1]}, br)) {
            blockStart = MultipartParser.readPart(body, blockStart + 2, boundary, result);
        }
        if (Arrays.equals(buf, end)) {
            return result;
        }
        throw new IllegalStateException("Can't read message: invalid separation symbol");
    }

    private static int readPart(byte[] body, int i, byte[] boundary, Map<String, Part> result) {
        for (int j = i; j < body.length; ++j) {
            if (!MultipartParser.isMatch(body, boundary, j)) continue;
            Part part = MultipartParser.parse(body, i, j - i);
            result.put(part.contentId, part);
            return j + boundary.length;
        }
        throw new IllegalStateException("Can't read message: no ending symbol");
    }

    public static boolean isMatch(byte[] input, byte[] pattern, int pos) {
        if (pos == input.length - 1) {
            return true;
        }
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == input[pos + i]) continue;
            return false;
        }
        return true;
    }

    public static void writeContentReplacedWithCids(List<Part> parts, OutputStream os) throws IOException {
        Part xml = parts.get(0);
        List<CidHref> cids = MultipartParser.findCids(parts);
        if (cids.isEmpty()) {
            MultipartParser.copyLarge(xml.getContentStream(), os);
            return;
        }
        int currentIndex = xml.offset();
        for (CidHref cid : cids) {
            os.write(xml.data(), currentIndex, cid.startIndex() - currentIndex);
            InputStream sidIs = cid.cidPart().getContentStream();
            MultipartParser.copyLarge((InputStream)new Base64InputStream(sidIs, true, -1, null), os);
            currentIndex = cid.endIndex();
        }
        int endIndex = xml.offset() + xml.length();
        int remainLength = endIndex - currentIndex;
        os.write(xml.data(), currentIndex, remainLength);
    }

    private static long copyLarge(InputStream input, OutputStream output) throws IOException {
        long count = 0L;
        byte[] buffer = new byte[8092];
        if (input != null) {
            int n;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
        }
        return count;
    }

    private static List<CidHref> findCids(List<Part> parts) {
        Part xml = parts.get(0);
        byte[] searchFor = "<xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"".getBytes(StandardCharsets.UTF_8);
        ArrayList<CidHref> result = new ArrayList<CidHref>(4);
        int lastCid = xml.offset();
        int endOfXml = xml.offset() + xml.length();
        int start = MultipartParser.indexOf(xml.data(), searchFor, lastCid, endOfXml);
        while (start > 0) {
            int end = MultipartParser.indexOf(xml.data(), "\"/>".getBytes(StandardCharsets.UTF_8), start, endOfXml);
            byte[] cidBytes = Arrays.copyOfRange(xml.data(), start + searchFor.length + 4, end);
            String cid = URLDecoder.decode(new String(cidBytes, StandardCharsets.UTF_8), StandardCharsets.UTF_8);
            Part cidPart = parts.stream().filter(part -> part.contentId().equals(String.format("<%s>", cid))).findFirst().orElseThrow(() -> new IllegalStateException("No part with cid " + cid));
            lastCid = end + 3;
            result.add(new CidHref(start, end + 3, cid, cidPart));
            start = MultipartParser.indexOf(xml.data(), searchFor, lastCid, endOfXml);
        }
        return result;
    }

    private static int indexOf(byte[] array, byte[] smallerArray, int startFrom, int endOnExclusive) {
        for (int i = startFrom; i < endOnExclusive && i < array.length - smallerArray.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < smallerArray.length; ++j) {
                if (array[i + j] == smallerArray[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    public record MultipartMeta(String boundary, String start) {
    }

    public record Part(String contentId, String contentType, byte[] data, int offset, int length) {
        public InputStream getContentStream() {
            return new ByteArrayInputStream(this.data, this.offset, this.length - 2);
        }

        public byte[] getContentArray() {
            return Arrays.copyOfRange(this.data, this.offset, this.length - 2);
        }
    }

    private record CidHref(int startIndex, int endIndex, String cid, Part cidPart) {
    }
}

