/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.common.util.ReactorUtils;
import ru.tinkoff.kora.http.client.common.HttpClient;
import ru.tinkoff.kora.http.client.common.HttpClientException;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequestBuilder;
import ru.tinkoff.kora.http.client.common.response.BlockingHttpResponse;
import ru.tinkoff.kora.soap.client.common.InvalidHttpResponseSoapException;
import ru.tinkoff.kora.soap.client.common.MultipartParser;
import ru.tinkoff.kora.soap.client.common.SoapException;
import ru.tinkoff.kora.soap.client.common.SoapResult;
import ru.tinkoff.kora.soap.client.common.XmlTools;
import ru.tinkoff.kora.soap.client.common.envelope.SoapEnvelope;
import ru.tinkoff.kora.soap.client.common.envelope.SoapFault;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTelemetry;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTelemetryFactory;

public class SoapRequestExecutor {
    private final HttpClient httpClient;
    private final XmlTools xmlTools;
    private final String url;
    private final String soapAction;
    private final SoapClientTelemetry telemetry;
    private final Duration timeout;

    public SoapRequestExecutor(HttpClient httpClient, SoapClientTelemetryFactory telemetryFactory, XmlTools xmlTools, String service, String url, Duration timeout, String method, @Nullable String soapAction) {
        this.httpClient = httpClient;
        this.xmlTools = xmlTools;
        this.url = url;
        this.timeout = timeout;
        this.soapAction = soapAction;
        this.telemetry = telemetryFactory.get(service, method, url);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public SoapResult call(SoapEnvelope requestEnvelope) throws SoapException {
        SoapClientTelemetry.SoapTelemetryContext telemetry = this.telemetry.get(requestEnvelope);
        byte[] requestXml = this.xmlTools.marshal(requestEnvelope);
        HttpClientRequestBuilder httpClientRequest = HttpClientRequest.post((String)this.url).body(requestXml).requestTimeout((int)this.timeout.toMillis()).header("content-type", "text/xml");
        if (this.soapAction != null) {
            httpClientRequest.header("SOAPAction", this.soapAction);
        }
        try (BlockingHttpResponse httpClientResponse = BlockingHttpResponse.from((Mono)this.httpClient.execute(httpClientRequest.build()));){
            SoapResult.Failure failure;
            block25: {
                InputStream body;
                block21: {
                    SoapResult.Success success;
                    block24: {
                        block22: {
                            SoapResult.Success success2;
                            block23: {
                                if (httpClientResponse.code() != 200 && httpClientResponse.code() != 500) {
                                    telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InvalidHttpCode(httpClientResponse.code()));
                                    throw this.parseInvalidHttpCodeResponse(httpClientResponse);
                                }
                                body = httpClientResponse.body();
                                try {
                                    if (httpClientResponse.code() != 200) break block21;
                                    String contentType = httpClientResponse.headers().getFirst("content-type");
                                    if (contentType == null || !contentType.toLowerCase().startsWith("multipart")) break block22;
                                    SoapResult.Success result = this.readMultipart(contentType, body);
                                    telemetry.success(result);
                                    success2 = result;
                                    if (body == null) break block23;
                                }
                                catch (Throwable throwable) {
                                    if (body != null) {
                                        try {
                                            body.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                body.close();
                            }
                            return success2;
                        }
                        SoapEnvelope responseEnvelope = this.xmlTools.unmarshal(body);
                        SoapResult.Success result = new SoapResult.Success(responseEnvelope.getBody().getAny().get(0));
                        telemetry.success(result);
                        success = result;
                        if (body == null) break block24;
                        body.close();
                    }
                    return success;
                }
                SoapResult.Failure result = this.readFailure(body);
                telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InternalServerError(result));
                failure = result;
                if (body == null) break block25;
                body.close();
            }
            return failure;
        }
        catch (IOException | HttpClientException e) {
            telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException(e));
            throw new SoapException(e);
        }
        catch (Exception e) {
            telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException(e));
            throw e;
        }
    }

    public Mono<SoapResult> callReactive(SoapEnvelope requestEnvelope) {
        return Mono.defer(() -> {
            SoapClientTelemetry.SoapTelemetryContext telemetry = this.telemetry.get(requestEnvelope);
            byte[] requestXml = this.xmlTools.marshal(requestEnvelope);
            HttpClientRequestBuilder httpClientRequest = HttpClientRequest.post((String)this.url).body(requestXml).header("content-type", "text/xml");
            if (this.soapAction != null) {
                httpClientRequest.header("SOAPAction", this.soapAction);
            }
            return this.httpClient.execute(httpClientRequest.build()).doOnError(e -> telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException((Throwable)e))).flatMap(httpClientResponse -> {
                if (httpClientResponse.code() != 200 && httpClientResponse.code() != 500) {
                    return ReactorUtils.toByteArrayMono((Flux)httpClientResponse.body()).handle((body, sink) -> {
                        telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InvalidHttpCode(httpClientResponse.code()));
                        sink.error((Throwable)new InvalidHttpResponseSoapException(httpClientResponse.code(), (byte[])body));
                    });
                }
                return ReactorUtils.toByteArrayMono((Flux)httpClientResponse.body()).onErrorMap(e -> {
                    telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException((Throwable)e));
                    return new SoapException((Throwable)e);
                }).map(body -> {
                    try {
                        if (httpClientResponse.code() == 200) {
                            String contentType = httpClientResponse.headers().getFirst("content-type");
                            if (contentType != null && contentType.toLowerCase().startsWith("multipart")) {
                                SoapResult.Success result = this.readMultipart(contentType, new ByteArrayInputStream((byte[])body));
                                telemetry.success(result);
                                return result;
                            }
                            SoapEnvelope responseEnvelope = this.xmlTools.unmarshal(new ByteArrayInputStream((byte[])body));
                            SoapResult.Success result = new SoapResult.Success(responseEnvelope.getBody().getAny().get(0));
                            telemetry.success(result);
                            return result;
                        }
                        SoapResult.Failure result = this.readFailure(new ByteArrayInputStream((byte[])body));
                        telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InternalServerError(result));
                        return result;
                    }
                    catch (IOException e) {
                        telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException(e));
                        throw new SoapException(e);
                    }
                });
            });
        });
    }

    private SoapException parseInvalidHttpCodeResponse(BlockingHttpResponse httpClientResponse) {
        InvalidHttpResponseSoapException invalidHttpResponseSoapException;
        block8: {
            InputStream body = httpClientResponse.body();
            try {
                byte[] responseBody = body.readAllBytes();
                invalidHttpResponseSoapException = new InvalidHttpResponseSoapException(httpClientResponse.code(), responseBody);
                if (body == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new SoapException(e);
                }
            }
            body.close();
        }
        return invalidHttpResponseSoapException;
    }

    private SoapResult.Success readMultipart(String contentType, InputStream body) throws IOException {
        MultipartParser.MultipartMeta multipartMeta = MultipartParser.parseMeta(contentType);
        Map<String, MultipartParser.Part> parts = MultipartParser.parse(body.readAllBytes(), multipartMeta.boundary());
        String xmlPartId = multipartMeta.start();
        SoapEnvelope responseEnvelope = (SoapEnvelope)this.xmlTools.unmarshal(parts, xmlPartId);
        Object responseBody = responseEnvelope.getBody().getAny().get(0);
        return new SoapResult.Success(responseBody);
    }

    private SoapResult.Failure readFailure(InputStream body) throws IOException {
        SoapEnvelope responseEnvelope = this.xmlTools.unmarshal(body);
        SoapFault fault = (SoapFault)responseEnvelope.getBody().getAny().get(0);
        String faultMessage = fault.getFaultcode().toString() + " " + fault.getFaultstring();
        return new SoapResult.Failure(fault, faultMessage);
    }
}

