/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common.jakarta;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.xml.bind.attachment.AttachmentUnmarshaller;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import ru.tinkoff.kora.soap.client.common.MultipartParser;

public class JakartaXopAttachmentUnmarshaller
extends AttachmentUnmarshaller {
    private final Map<String, MultipartParser.Part> parts;

    public JakartaXopAttachmentUnmarshaller(Map<String, MultipartParser.Part> parts) {
        this.parts = parts;
    }

    public DataHandler getAttachmentAsDataHandler(String cid) {
        if (cid.startsWith("cid:")) {
            cid = cid.replace("cid:", "");
        }
        cid = URLDecoder.decode("<" + cid + ">", StandardCharsets.UTF_8);
        final MultipartParser.Part c = this.parts.get(cid);
        final String finalCid = cid;
        DataSource ds = new DataSource(){

            public InputStream getInputStream() {
                return c.getContentStream();
            }

            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }

            public String getContentType() {
                return c.contentType();
            }

            public String getName() {
                return finalCid;
            }
        };
        return new DataHandler(ds);
    }

    public byte[] getAttachmentAsByteArray(String cid) {
        MultipartParser.Part c = this.parts.get(cid);
        return c.getContentArray();
    }

    public boolean isXOPPackage() {
        return this.parts.size() > 1;
    }
}

