/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.soap.client.common.SoapResult;
import ru.tinkoff.kora.soap.client.common.telemetry.DefaultSoapTelemetryContext;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientMetrics;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientMetricsFactory;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTelemetry;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTelemetryFactory;

public class DefaultSoapClientTelemetryFactory
implements SoapClientTelemetryFactory {
    private static final SoapClientTelemetry.SoapTelemetryContext NOOP_CTX = new SoapClientTelemetry.SoapTelemetryContext(){

        @Override
        public void success(SoapResult.Success result) {
        }

        @Override
        public void failure(SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure failure) {
        }
    };
    @Nullable
    private final SoapClientMetricsFactory metricsFactory;

    public DefaultSoapClientTelemetryFactory(@Nullable SoapClientMetricsFactory metricsFactory) {
        this.metricsFactory = metricsFactory;
    }

    @Override
    public SoapClientTelemetry get(String serviceName, String soapMethod, String url) {
        if (this.metricsFactory == null) {
            return envelope -> NOOP_CTX;
        }
        SoapClientMetrics metrics = this.metricsFactory.get(serviceName, soapMethod, url);
        return requestEnvelope -> new DefaultSoapTelemetryContext(metrics);
    }
}

