/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common;

import java.util.function.Function;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.tinkoff.kora.soap.client.common.envelope.SoapEnvelope;

public class SoapEnvelopeProcessors {
    public static Function<SoapEnvelope, SoapEnvelope> wssAuth(String username, String password) {
        return soapEnvelope -> {
            try {
                soapEnvelope.getHeader().getAny().add(SoapEnvelopeProcessors.buildWssHeader(username, password));
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            return soapEnvelope;
        };
    }

    private static Element buildWssHeader(String username, String password) throws ParserConfigurationException {
        String wsse = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
        String passwordTextType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
        Document document = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder().newDocument();
        Element security = document.createElementNS(wsse, "Security");
        security.setPrefix("wsse");
        Element usernameToken = document.createElementNS(wsse, "UsernameToken");
        usernameToken.setPrefix("wsse");
        Element usernameElement = document.createElementNS(wsse, "Username");
        usernameElement.setPrefix("wsse");
        Element passwordElement = document.createElementNS(wsse, "Password");
        passwordElement.setPrefix("wsse");
        usernameElement.appendChild(document.createTextNode(username));
        passwordElement.setAttribute("Type", passwordTextType);
        passwordElement.appendChild(document.createTextNode(password));
        usernameToken.appendChild(usernameElement);
        usernameToken.appendChild(passwordElement);
        security.appendChild(usernameToken);
        document.appendChild(security);
        return document.getDocumentElement();
    }
}

