/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.soap.client.common.SoapResult;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientMetrics;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTelemetry;

public class DefaultSoapTelemetryContext
implements SoapClientTelemetry.SoapTelemetryContext {
    @Nullable
    private final SoapClientMetrics metrics;
    private final long start = System.nanoTime();

    public DefaultSoapTelemetryContext(@Nullable SoapClientMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public void success(SoapResult.Success result) {
        long processingTime = System.nanoTime() - this.start;
        if (this.metrics != null) {
            this.metrics.recordSuccess(result, processingTime);
        }
    }

    @Override
    public void failure(SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure failure) {
        long processingTime = System.nanoTime() - this.start;
        if (this.metrics != null) {
            this.metrics.recordFailure(failure, processingTime);
        }
    }
}

