/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common.jakarta;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.attachment.AttachmentUnmarshaller;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import ru.tinkoff.kora.soap.client.common.MultipartParser;
import ru.tinkoff.kora.soap.client.common.SoapException;
import ru.tinkoff.kora.soap.client.common.SoapRequestMarshallingException;
import ru.tinkoff.kora.soap.client.common.SoapResponseUnmarshallingException;
import ru.tinkoff.kora.soap.client.common.XmlTools;
import ru.tinkoff.kora.soap.client.common.envelope.SoapEnvelope;
import ru.tinkoff.kora.soap.client.common.jakarta.JakartaXopAttachmentUnmarshaller;

public class JakartaXmlTools
implements XmlTools {
    private final JAXBContext jaxb;

    public JakartaXmlTools(JAXBContext jaxb) {
        this.jaxb = jaxb;
    }

    @Override
    public byte[] marshal(SoapEnvelope envelope) throws SoapException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Marshaller marshaller = this.jaxb.createMarshaller();
            marshaller.marshal((Object)envelope, (OutputStream)baos);
        }
        catch (JAXBException e) {
            throw new SoapRequestMarshallingException(e);
        }
        return baos.toByteArray();
    }

    @Override
    public SoapEnvelope unmarshal(InputStream is) throws SoapException {
        try {
            Unmarshaller unmarshaller = this.jaxb.createUnmarshaller();
            return (SoapEnvelope)unmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new SoapResponseUnmarshallingException(e);
        }
    }

    @Override
    public SoapEnvelope unmarshal(Map<String, MultipartParser.Part> parts, String xmlPartId) throws SoapException {
        MultipartParser.Part xmlPart = parts.get(xmlPartId);
        try {
            Unmarshaller unmarshaller = this.jaxb.createUnmarshaller();
            unmarshaller.setAttachmentUnmarshaller((AttachmentUnmarshaller)new JakartaXopAttachmentUnmarshaller(parts));
            return (SoapEnvelope)unmarshaller.unmarshal(xmlPart.getContentStream());
        }
        catch (JAXBException e) {
            throw new SoapResponseUnmarshallingException(e);
        }
    }
}

