/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common;

import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import ru.tinkoff.kora.common.DefaultComponent;
import ru.tinkoff.kora.soap.client.common.telemetry.DefaultSoapClientTelemetryFactory;
import ru.tinkoff.kora.soap.client.common.telemetry.Sl4fjSoapClientLoggerFactory;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientLogger;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientLoggerFactory;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientMetricsFactory;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTracerFactory;

public interface SoapClientModule {
    @DefaultComponent
    default public SoapClientLogger.SoapClientLoggerBodyMapper defaultSoapClientLoggerBodyMapper() {
        return new SoapClientLogger.SoapClientLoggerBodyMapper(){

            @Override
            public String mapRequest(String serviceName, String soapMethod, byte[] requestAsBytes) {
                return new String(requestAsBytes, StandardCharsets.UTF_8);
            }

            @Override
            public String mapResponseSuccess(String serviceName, String soapMethod, byte[] responseAsBytes) {
                return new String(responseAsBytes, StandardCharsets.UTF_8);
            }

            @Override
            public String mapResponseFailure(String serviceName, String soapMethod, byte[] responseAsBytes) {
                return new String(responseAsBytes, StandardCharsets.UTF_8);
            }
        };
    }

    @DefaultComponent
    default public SoapClientLoggerFactory defaultSoapClientLoggerFactory(SoapClientLogger.SoapClientLoggerBodyMapper mapper) {
        return new Sl4fjSoapClientLoggerFactory(mapper);
    }

    @DefaultComponent
    default public DefaultSoapClientTelemetryFactory defaultSoapClientTelemetryFactory(@Nullable SoapClientLoggerFactory loggerFactory, @Nullable SoapClientMetricsFactory metricsFactory, @Nullable SoapClientTracerFactory tracerFactory) {
        return new DefaultSoapClientTelemetryFactory(loggerFactory, metricsFactory, tracerFactory);
    }
}

