/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common;

import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import ru.tinkoff.kora.common.util.FlowUtils;
import ru.tinkoff.kora.http.client.common.HttpClient;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequest;
import ru.tinkoff.kora.http.client.common.request.HttpClientRequestBuilder;
import ru.tinkoff.kora.http.common.body.HttpBody;
import ru.tinkoff.kora.http.common.body.HttpBodyOutput;
import ru.tinkoff.kora.soap.client.common.InvalidHttpResponseSoapException;
import ru.tinkoff.kora.soap.client.common.MultipartParser;
import ru.tinkoff.kora.soap.client.common.SoapException;
import ru.tinkoff.kora.soap.client.common.SoapResult;
import ru.tinkoff.kora.soap.client.common.SoapServiceConfig;
import ru.tinkoff.kora.soap.client.common.XmlTools;
import ru.tinkoff.kora.soap.client.common.envelope.SoapEnvelope;
import ru.tinkoff.kora.soap.client.common.envelope.SoapFault;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTelemetry;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTelemetryFactory;

public class SoapRequestExecutor {
    private final HttpClient httpClient;
    private final XmlTools xmlTools;
    private final String url;
    private final String soapAction;
    private final SoapClientTelemetry telemetry;
    private final Duration timeout;

    @Deprecated
    public SoapRequestExecutor(HttpClient httpClient, SoapClientTelemetryFactory telemetryFactory, XmlTools xmlTools, String service, SoapServiceConfig config, String method, @Nullable String soapAction) {
        this(httpClient, telemetryFactory, xmlTools, "ru.tinkoff.kora.soap.client." + service, service, config, method, soapAction);
    }

    public SoapRequestExecutor(HttpClient httpClient, SoapClientTelemetryFactory telemetryFactory, XmlTools xmlTools, String serviceClass, String service, SoapServiceConfig config, String method, @Nullable String soapAction) {
        this.httpClient = httpClient;
        this.xmlTools = xmlTools;
        this.url = config.url();
        this.timeout = config.timeout();
        this.soapAction = soapAction;
        this.telemetry = telemetryFactory.get(config.telemetry(), serviceClass, service, method, this.url);
    }

    /*
     * Exception decompiling
     */
    public SoapResult call(SoapEnvelope requestEnvelope) throws SoapException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[TRYBLOCK]], but top level block is 48[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CompletionStage<SoapResult> callAsync(SoapEnvelope requestEnvelope) {
        SoapClientTelemetry.SoapTelemetryContext telemetry = this.telemetry.get(requestEnvelope);
        byte[] requestXml = this.xmlTools.marshal(requestEnvelope);
        telemetry.prepared(requestEnvelope, requestXml);
        HttpClientRequestBuilder httpClientRequest = HttpClientRequest.post((String)this.url).body((HttpBodyOutput)HttpBody.of((String)"text/xml", (byte[])requestXml));
        if (this.soapAction != null) {
            httpClientRequest.header("SOAPAction", this.soapAction);
        }
        return this.httpClient.execute(httpClientRequest.build()).whenComplete((response, error) -> {
            if (error != null) {
                telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException((Throwable)error), null);
            }
        }).thenCompose(httpClientResponse -> {
            if (httpClientResponse.code() != 200 && httpClientResponse.code() != 500) {
                return FlowUtils.toByteArrayFuture((Flow.Publisher)httpClientResponse.body()).handle((body, sink) -> {
                    telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InvalidHttpCode(httpClientResponse.code()), (byte[])body);
                    throw new InvalidHttpResponseSoapException(httpClientResponse.code(), (byte[])body);
                });
            }
            return FlowUtils.toByteArrayFuture((Flow.Publisher)httpClientResponse.body()).handle((body, error) -> {
                if (error != null) {
                    telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException((Throwable)error), (byte[])body);
                    throw new SoapException((Throwable)error);
                }
                try {
                    if (httpClientResponse.code() == 200) {
                        String contentType = httpClientResponse.headers().getFirst("content-type");
                        if (contentType != null && contentType.toLowerCase().startsWith("multipart")) {
                            ParseMultipartResult readMultipartResult = this.readMultipart(contentType, new ByteArrayInputStream((byte[])body));
                            SoapResult.Success result = readMultipartResult.result;
                            if (telemetry.logResponseBody()) {
                                telemetry.success(result, readMultipartResult.xmlPart().getContentArray());
                            } else {
                                telemetry.success(result, null);
                            }
                            return result;
                        }
                        SoapEnvelope responseEnvelope = this.xmlTools.unmarshal(new ByteArrayInputStream((byte[])body));
                        SoapResult.Success result = new SoapResult.Success(responseEnvelope.getBody().getAny().get(0));
                        if (telemetry.logResponseBody()) {
                            telemetry.success(result, (byte[])body);
                        } else {
                            telemetry.success(result, null);
                        }
                        return result;
                    }
                    SoapResult.Failure result = this.readFailure(new ByteArrayInputStream((byte[])body));
                    telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InternalServerError(result), (byte[])body);
                    return result;
                }
                catch (IOException e) {
                    telemetry.failure(new SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException(e), (byte[])body);
                    throw new SoapException(e);
                }
            });
        });
    }

    private SoapResult.Success readSuccess(InputStream body) throws IOException {
        byte[] bodyAsBytes = body.readAllBytes();
        try (ByteArrayInputStream bi = new ByteArrayInputStream(bodyAsBytes);){
            SoapEnvelope responseEnvelope = this.xmlTools.unmarshal(bi);
            SoapResult.Success success = new SoapResult.Success(responseEnvelope.getBody().getAny().get(0));
            return success;
        }
    }

    private ParseMultipartResult readMultipart(String contentType, InputStream body) throws IOException {
        MultipartParser.MultipartMeta multipartMeta = MultipartParser.parseMeta(contentType);
        byte[] bodyAsBytes = body.readAllBytes();
        Map<String, MultipartParser.Part> parts = MultipartParser.parse(bodyAsBytes, multipartMeta.boundary());
        String xmlPartId = multipartMeta.start();
        SoapEnvelope responseEnvelope = (SoapEnvelope)this.xmlTools.unmarshal(parts, xmlPartId);
        Object responseBody = responseEnvelope.getBody().getAny().get(0);
        return new ParseMultipartResult(new SoapResult.Success(responseBody), parts.get(xmlPartId));
    }

    private SoapResult.Failure readFailure(InputStream body) throws IOException {
        SoapEnvelope responseEnvelope = this.xmlTools.unmarshal(body);
        SoapFault fault = (SoapFault)responseEnvelope.getBody().getAny().get(0);
        String faultMessage = fault.getFaultcode().toString() + " " + fault.getFaultstring();
        return new SoapResult.Failure(fault, faultMessage);
    }

    private record ParseMultipartResult(SoapResult.Success result, MultipartParser.Part xmlPart) {
    }
}

