/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common.telemetry;

import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import ru.tinkoff.kora.logging.common.arg.StructuredArgument;
import ru.tinkoff.kora.soap.client.common.SoapResult;
import ru.tinkoff.kora.soap.client.common.envelope.SoapEnvelope;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientLogger;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTelemetry;

public class Sl4fjSoapClientLogger
implements SoapClientLogger {
    private final String serviceName;
    private final String soapMethod;
    private final SoapClientLogger.SoapClientLoggerBodyMapper mapper;
    private final Logger requestLog;
    private final Logger responseLog;

    public Sl4fjSoapClientLogger(SoapClientLogger.SoapClientLoggerBodyMapper mapper, Logger requestLog, Logger responseLog, String serviceName, String soapMethod) {
        this.mapper = mapper;
        this.requestLog = requestLog;
        this.responseLog = responseLog;
        this.serviceName = serviceName;
        this.soapMethod = soapMethod;
    }

    @Override
    public boolean logResponseBody() {
        return this.responseLog.isTraceEnabled();
    }

    @Override
    public void logRequest(SoapEnvelope requestEnvelope, byte[] requestAsBytes) {
        Marker marker = StructuredArgument.marker((String)"soapRequest", gen -> {
            gen.writeStartObject();
            gen.writeStringField("soapMethod", this.soapMethod);
            gen.writeStringField("soapService", this.serviceName);
            gen.writeEndObject();
        });
        if (this.requestLog.isTraceEnabled() && requestAsBytes != null) {
            this.requestLog.trace(marker, "SoapService requesting method: {}\n{}", (Object)this.soapMethod, (Object)this.mapper.mapRequest(this.serviceName, this.soapMethod, requestAsBytes));
        } else {
            this.requestLog.info(marker, "SoapService requesting method: {}", (Object)this.soapMethod);
        }
    }

    @Override
    public void logSuccess(SoapResult.Success result, @Nullable byte[] responseAsBytes) {
        Marker marker = StructuredArgument.marker((String)"soapResponse", gen -> {
            gen.writeStartObject();
            gen.writeStringField("soapMethod", this.soapMethod);
            gen.writeStringField("soapService", this.serviceName);
            gen.writeStringField("soapStatus", "success");
            gen.writeEndObject();
        });
        if (this.responseLog.isTraceEnabled() && responseAsBytes != null) {
            this.responseLog.trace(marker, "SoapService received 'success' for method: {}\n{}", (Object)this.soapMethod, (Object)this.mapper.mapResponseSuccess(this.serviceName, this.soapMethod, responseAsBytes));
        } else {
            this.responseLog.info(marker, "SoapService received 'success' for method: {}", (Object)this.soapMethod);
        }
    }

    @Override
    public void logFailure(SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure failure, @Nullable byte[] responseAsBytes) {
        Marker marker = StructuredArgument.marker((String)"soapResponse", gen -> {
            gen.writeStartObject();
            gen.writeStringField("soapMethod", this.soapMethod);
            gen.writeStringField("soapService", this.serviceName);
            gen.writeStringField("soapStatus", "success");
            if (failure instanceof SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InvalidHttpCode) {
                SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InvalidHttpCode ie = (SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InvalidHttpCode)failure;
                gen.writeNumberField("soapHttpCode", ie.code());
            } else if (failure instanceof SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InternalServerError) {
                SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InternalServerError se = (SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InternalServerError)failure;
                gen.writeStringField("soapFaultCode", se.result().fault().getFaultcode().toString());
                gen.writeStringField("soapFaultActor", se.result().fault().getFaultactor());
            } else if (failure instanceof SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException) {
                SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException pe = (SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException)failure;
                gen.writeStringField("exceptionType", pe.throwable().getClass().getCanonicalName());
            }
            gen.writeEndObject();
        });
        if (failure instanceof SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InternalServerError) {
            SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InternalServerError se = (SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.InternalServerError)failure;
            if (this.responseLog.isTraceEnabled() && responseAsBytes != null) {
                this.responseLog.trace(marker, "SoapService received 'failure' for method '{}' and message: {}\n{}", new Object[]{this.soapMethod, se.result().faultMessage(), this.mapper.mapResponseFailure(this.serviceName, this.soapMethod, responseAsBytes)});
            } else {
                this.responseLog.info(marker, "SoapService received 'failure' for method '{}' and message: {}", (Object)this.soapMethod, (Object)se.result().faultMessage());
            }
        } else if (failure instanceof SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException) {
            SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException pe = (SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure.ProcessException)failure;
            if (this.responseLog.isTraceEnabled()) {
                this.responseLog.trace(marker, "SoapService received 'failure' for method '{}' and cause:", (Object)this.soapMethod, (Object)pe.throwable());
            } else {
                this.responseLog.info(marker, "SoapService received 'failure' for method '{}' and cause: {}", (Object)this.soapMethod, (Object)pe.throwable().getMessage());
            }
        } else {
            this.responseLog.info(marker, "SoapService received 'failure' for method: {}", (Object)this.soapMethod);
        }
    }
}

