/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.soap.client.common.telemetry;

import jakarta.annotation.Nullable;
import ru.tinkoff.kora.common.Context;
import ru.tinkoff.kora.soap.client.common.SoapResult;
import ru.tinkoff.kora.soap.client.common.envelope.SoapEnvelope;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientLogger;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientLoggerFactory;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientMetrics;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientMetricsFactory;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTelemetry;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTelemetryFactory;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTracer;
import ru.tinkoff.kora.soap.client.common.telemetry.SoapClientTracerFactory;
import ru.tinkoff.kora.telemetry.common.TelemetryConfig;

public class DefaultSoapClientTelemetryFactory
implements SoapClientTelemetryFactory {
    private static final SoapClientTelemetry.SoapTelemetryContext NOOP_CTX = new SoapClientTelemetry.SoapTelemetryContext(){

        @Override
        public boolean logResponseBody() {
            return false;
        }

        @Override
        public void prepared(SoapEnvelope requestEnvelope, byte[] requestAsBytes) {
        }

        @Override
        public void success(SoapResult.Success success, @Nullable byte[] responseAsBytes) {
        }

        @Override
        public void failure(SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure failure, @Nullable byte[] responseAsBytes) {
        }
    };
    @Nullable
    private final SoapClientLoggerFactory loggerFactory;
    @Nullable
    private final SoapClientMetricsFactory metricsFactory;
    @Nullable
    private final SoapClientTracerFactory tracingFactory;

    public DefaultSoapClientTelemetryFactory(@Nullable SoapClientLoggerFactory loggerFactory, @Nullable SoapClientMetricsFactory metricsFactory, @Nullable SoapClientTracerFactory tracingFactory) {
        this.loggerFactory = loggerFactory;
        this.metricsFactory = metricsFactory;
        this.tracingFactory = tracingFactory;
    }

    @Override
    public SoapClientTelemetry get(TelemetryConfig config, String serviceClass, String serviceName, String soapMethod, String url) {
        SoapClientLogger logger;
        SoapClientTracer tracing = this.tracingFactory == null ? null : this.tracingFactory.get(config.tracing(), serviceClass, serviceName, soapMethod, url);
        final SoapClientMetrics metrics = this.metricsFactory == null ? null : this.metricsFactory.get(config.metrics(), serviceClass, serviceName, soapMethod, url);
        SoapClientLogger soapClientLogger = logger = this.loggerFactory == null ? null : this.loggerFactory.get(config.logging(), serviceClass, serviceName, soapMethod, url);
        if (tracing == null && metrics == null && logger == null) {
            return envelope -> NOOP_CTX;
        }
        return requestEnvelope -> {
            final long start = System.nanoTime();
            final SoapClientTracer.SoapClientSpan span = tracing == null ? null : tracing.createSpan(Context.current(), requestEnvelope);
            return new SoapClientTelemetry.SoapTelemetryContext(){

                @Override
                public boolean logResponseBody() {
                    return logger != null && logger.logResponseBody();
                }

                @Override
                public void prepared(SoapEnvelope requestEnvelope, byte[] requestAsBytes) {
                    if (logger != null) {
                        logger.logRequest(requestEnvelope, requestAsBytes);
                    }
                }

                @Override
                public void success(SoapResult.Success success, @Nullable byte[] responseAsBytes) {
                    long processingTime = System.nanoTime() - start;
                    if (metrics != null) {
                        metrics.recordSuccess(success, processingTime);
                    }
                    if (span != null) {
                        span.success(success);
                    }
                    if (logger != null) {
                        logger.logSuccess(success, responseAsBytes);
                    }
                }

                @Override
                public void failure(SoapClientTelemetry.SoapTelemetryContext.SoapClientFailure failure, @Nullable byte[] responseAsBytes) {
                    long processingTime = System.nanoTime() - start;
                    if (metrics != null) {
                        metrics.recordFailure(failure, processingTime);
                    }
                    if (span != null) {
                        span.failure(failure);
                    }
                    if (logger != null) {
                        logger.logFailure(failure, responseAsBytes);
                    }
                }
            };
        };
    }
}

