/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.RefreshableGraph;
import ru.tinkoff.kora.common.Component;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.common.annotation.Root;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphMock;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;
import ru.tinkoff.kora.test.extension.junit5.KoraAppGraph;
import ru.tinkoff.kora.test.extension.junit5.KoraAppTest;
import ru.tinkoff.kora.test.extension.junit5.KoraAppTestConfigModifier;
import ru.tinkoff.kora.test.extension.junit5.KoraAppTestGraphModifier;
import ru.tinkoff.kora.test.extension.junit5.KoraConfigFile;
import ru.tinkoff.kora.test.extension.junit5.KoraConfigModification;
import ru.tinkoff.kora.test.extension.junit5.KoraConfigString;
import ru.tinkoff.kora.test.extension.junit5.KoraGraphModification;
import ru.tinkoff.kora.test.extension.junit5.MockComponent;
import ru.tinkoff.kora.test.extension.junit5.TestComponent;
import ru.tinkoff.kora.test.extension.junit5.TestGraph;
import ru.tinkoff.kora.test.extension.junit5.TestGraphInitialized;

final class KoraJUnit5Extension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{KoraJUnit5Extension.class});
    private static final Logger logger = LoggerFactory.getLogger(KoraJUnit5Extension.class);
    private static final Map<Class<?>, Supplier<ApplicationGraphDraw>> GRAPH_SUPPLIER_MAP = new ConcurrentHashMap();

    KoraJUnit5Extension() {
    }

    @Nonnull
    private static KoraTestContext getKoraTestContext(ExtensionContext context) {
        ExtensionContext.Store storage = context.getStore(NAMESPACE);
        return (KoraTestContext)storage.get(KoraAppTest.class, KoraTestContext.class);
    }

    private static void prepareMocks(TestGraphInitialized graphInitialized) {
        logger.trace("Resetting mocks...");
        for (Node node : graphInitialized.graphDraw().getNodes()) {
            Object mockCandidate = graphInitialized.refreshableGraph().get(node);
            if (!MockUtil.isMock((Object)mockCandidate) && !MockUtil.isSpy((Object)mockCandidate)) continue;
            Mockito.reset((Object[])new Object[]{mockCandidate});
            if (!(mockCandidate instanceof Lifecycle)) continue;
            Lifecycle lifecycle = (Lifecycle)mockCandidate;
            Mockito.when((Object)lifecycle.init()).thenReturn((Object)Mono.empty());
            Mockito.when((Object)lifecycle.release()).thenReturn((Object)Mono.empty());
        }
    }

    private static void injectComponentsToFields(TestClassMetadata metadata, TestGraphInitialized graphInitialized, ExtensionContext context) {
        if (metadata.fieldsForInjection.isEmpty()) {
            return;
        }
        Object testInstance = context.getTestInstance().orElseThrow(() -> new ExtensionConfigurationException("@KoraAppTest can't get TestInstance for @TestComponent field injection"));
        for (Field field : metadata.fieldsForInjection) {
            Class<?>[] tags = KoraJUnit5Extension.parseTags(field);
            GraphCandidate candidate = new GraphCandidate(field.getType(), tags);
            logger.trace("Looking for test method '{}' field '{}' inject candidate: {}", new Object[]{context.getDisplayName(), field.getName(), candidate});
            Object component = KoraJUnit5Extension.getComponentOrThrow(graphInitialized, candidate);
            KoraJUnit5Extension.injectToField(testInstance, field, component);
        }
    }

    private static void injectToField(Object testInstance, Field field, Object value) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new ExtensionConfigurationException("Field '%s' annotated have illegal 'static' modifier".formatted(field.getName()));
        }
        if (Modifier.isFinal(field.getModifiers())) {
            throw new ExtensionConfigurationException("Field '%s' annotated have illegal 'final' modifier".formatted(field.getName()));
        }
        try {
            field.setAccessible(true);
            field.set(testInstance, value);
        }
        catch (Exception e) {
            throw new ExtensionConfigurationException("Failed to inject field '%s' due to: ".formatted(field.getName()) + e);
        }
    }

    public void beforeAll(ExtensionContext context) {
        KoraAppTest koraAppTest = KoraJUnit5Extension.findKoraAppTest(context).orElseThrow(() -> new ExtensionConfigurationException("@KoraAppTest not found"));
        ExtensionContext.Store storage = context.getStore(NAMESPACE);
        storage.put(KoraAppTest.class, (Object)new KoraTestContext(koraAppTest));
    }

    public void beforeEach(ExtensionContext context) {
        long started = System.nanoTime();
        KoraTestContext koraTestContext = KoraJUnit5Extension.getKoraTestContext(context);
        if (koraTestContext.metadata == null) {
            koraTestContext.metadata = KoraJUnit5Extension.getClassMetadata(koraTestContext.annotation, context);
        }
        if (koraTestContext.graph == null) {
            koraTestContext.graph = KoraJUnit5Extension.generateTestGraph(koraTestContext.metadata, context);
            koraTestContext.graph.initialize();
        }
        KoraJUnit5Extension.prepareMocks(koraTestContext.graph.initialized());
        KoraJUnit5Extension.injectComponentsToFields(koraTestContext.metadata, koraTestContext.graph.initialized(), context);
        logger.info("@KoraAppTest test method '{}' setup took: {}", (Object)context.getDisplayName(), (Object)Duration.ofNanos(System.nanoTime() - started));
    }

    public void afterEach(ExtensionContext context) {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getKoraTestContext(context);
        if (koraTestContext.annotation.initializeMode() == KoraAppTest.InitializeMode.PER_METHOD && koraTestContext.graph != null) {
            koraTestContext.graph.close();
            koraTestContext.graph = null;
        }
    }

    public void afterAll(ExtensionContext context) {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getKoraTestContext(context);
        if (koraTestContext.annotation.initializeMode() == KoraAppTest.InitializeMode.PER_CLASS && koraTestContext.graph != null) {
            koraTestContext.graph.close();
        }
    }

    private static Optional<KoraAppTest> findKoraAppTest(ExtensionContext context) {
        Optional current = Optional.of(context);
        while (current.isPresent()) {
            Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)current.get().getRequiredTestClass(), KoraAppTest.class);
            if (annotation.isPresent()) {
                return annotation;
            }
            current = current.get().getParent();
        }
        return Optional.empty();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        return Arrays.stream(parameterContext.getParameter().getDeclaredAnnotations()).anyMatch(a -> a.annotationType().equals(TestComponent.class) || a.annotationType().equals(MockComponent.class)) || parameterContext.getParameter().getType().equals(KoraAppGraph.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getKoraTestContext(context);
        GraphCandidate graphCandidate = KoraJUnit5Extension.getGraphCandidate(parameterContext);
        logger.trace("Looking for test method '{}' parameter '{}' inject candidate: {}", new Object[]{context.getDisplayName(), parameterContext.getParameter().getName(), graphCandidate});
        return KoraJUnit5Extension.getComponentOrThrow(koraTestContext.graph.initialized(), graphCandidate);
    }

    private static Optional<KoraGraphModification> getGraphModification(KoraAppTest koraAppTest, ExtensionContext context) {
        long started = System.nanoTime();
        List<GraphMock> mockComponentFromParameters = context.getTestMethod().filter(method -> !method.isSynthetic()).stream().flatMap(m -> Stream.of(m.getParameters())).filter(parameter -> parameter.getDeclaredAnnotation(MockComponent.class) != null).map(parameter -> {
            if (KoraAppGraph.class.isAssignableFrom(parameter.getType())) {
                throw new ExtensionConfigurationException("KoraAppGraph can't be target of @MockComponent");
            }
            Class<?>[] tag = KoraJUnit5Extension.parseTags(parameter);
            return new GraphMock(new GraphCandidate(parameter.getParameterizedType(), tag));
        }).toList();
        if (koraAppTest.initializeMode() == KoraAppTest.InitializeMode.PER_CLASS && !mockComponentFromParameters.isEmpty()) {
            throw new ExtensionConfigurationException("@KoraAppTest when run in 'InitializeMode.PER_CLASS' test can't inject @MockComponent in method parameters");
        }
        Object testInstance = context.getTestInstance().orElseThrow(() -> new ExtensionConfigurationException("@KoraAppTest can't get TestInstance for @TestComponent field injection"));
        List<GraphMock> mockComponentFromFields = ReflectionUtils.findFields(testInstance.getClass(), f -> !f.isSynthetic() && !Modifier.isFinal(f.getModifiers()) && !Modifier.isStatic(f.getModifiers()) && f.getAnnotation(MockComponent.class) != null, (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).stream().map(field -> {
            if (KoraAppGraph.class.isAssignableFrom(field.getType())) {
                throw new ExtensionConfigurationException("KoraAppGraph can't be target of @MockComponent");
            }
            Class<?>[] tag = KoraJUnit5Extension.parseTags(field);
            return new GraphMock(new GraphCandidate(field.getGenericType(), tag));
        }).toList();
        KoraGraphModification koraGraphModification = context.getTestInstance().filter(inst -> inst instanceof KoraAppTestGraphModifier).map(inst -> ((KoraAppTestGraphModifier)inst).graph()).map(graph -> {
            mockComponentFromFields.forEach(m -> graph.mockComponent(m.candidate().type(), m.candidate().tags()));
            mockComponentFromParameters.forEach(m -> graph.mockComponent(m.candidate().type(), m.candidate().tags()));
            return graph;
        }).orElseGet(() -> {
            if (mockComponentFromFields.isEmpty() && mockComponentFromParameters.isEmpty()) {
                return null;
            }
            KoraGraphModification graph = KoraGraphModification.create();
            mockComponentFromFields.forEach(m -> graph.mockComponent(m.candidate().type(), m.candidate().tags()));
            mockComponentFromParameters.forEach(m -> graph.mockComponent(m.candidate().type(), m.candidate().tags()));
            return graph;
        });
        logger.debug("@KoraAppTest graph modification collecting took: {}", (Object)Duration.ofNanos(System.nanoTime() - started));
        return Optional.ofNullable(koraGraphModification);
    }

    private static TestClassMetadata getClassMetadata(KoraAppTest koraAppTest, ExtensionContext context) {
        long started = System.nanoTime();
        Set<GraphCandidate> annotationCandidates = Arrays.stream(koraAppTest.components()).map(GraphCandidate::new).collect(Collectors.toSet());
        TestClassMetadata.Config koraAppConfig = context.getTestInstance().filter(inst -> inst instanceof KoraAppTestConfigModifier).map(inst -> {
            KoraConfigModification configModification = ((KoraAppTestConfigModifier)inst).config();
            return new TestClassMetadata.FileConfig(configModification);
        }).orElse(TestClassMetadata.Config.NONE);
        Object testInstance = context.getTestInstance().orElseThrow(() -> new ExtensionConfigurationException("@KoraAppTest can't get TestInstance for @TestComponent field injection"));
        List fieldsForInjection = ReflectionUtils.findFields(testInstance.getClass(), f -> !f.isSynthetic() && (f.getAnnotation(TestComponent.class) != null || f.getAnnotation(MockComponent.class) != null), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
        Set<GraphCandidate> fieldCandidates = fieldsForInjection.stream().filter(f -> f.getAnnotation(TestComponent.class) != null).map(field -> {
            Class<?>[] tags = KoraJUnit5Extension.parseTags(field);
            return new GraphCandidate(field.getType(), tags);
        }).collect(Collectors.toSet());
        logger.debug("@KoraAppTest metadata collecting took: {}", (Object)Duration.ofNanos(System.nanoTime() - started));
        return new TestClassMetadata(koraAppTest, fieldsForInjection, annotationCandidates, fieldCandidates, koraAppConfig);
    }

    private static GraphCandidate getGraphCandidate(ParameterContext parameterContext) {
        Type parameterType = parameterContext.getParameter().getParameterizedType();
        Class<?>[] tags = KoraJUnit5Extension.parseTags(parameterContext.getParameter());
        return new GraphCandidate(parameterType, tags);
    }

    private static Class<?>[] parseTags(AnnotatedElement object) {
        return Arrays.stream(object.getDeclaredAnnotations()).filter(a -> a.annotationType().equals(Tag.class)).map(a -> ((Tag)a).value()).findFirst().orElse(null);
    }

    private static Object getComponentOrThrow(TestGraphInitialized graphInitialized, GraphCandidate candidate) {
        return KoraJUnit5Extension.getComponent(graphInitialized, candidate).orElseThrow(() -> new ExtensionConfigurationException(candidate + " was not found in graph, expected type to implement " + Lifecycle.class + " or be a @" + Component.class.getSimpleName() + " or be a @" + Root.class.getSimpleName() + ", please check @KoraAppTest configuration"));
    }

    private static Optional<Object> getComponent(TestGraphInitialized graphInitialized, GraphCandidate candidate) {
        try {
            return KoraJUnit5Extension.getComponentFromGraph(graphInitialized, candidate);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return Optional.empty();
        }
    }

    private static Optional<Object> getComponentFromGraph(TestGraphInitialized graph, GraphCandidate candidate) {
        if (KoraAppGraph.class.equals((Object)candidate.type())) {
            return Optional.of(graph.koraAppGraph());
        }
        if (candidate.tags().isEmpty()) {
            return Optional.ofNullable(graph.graphDraw().findNodeByType(candidate.type())).map(v -> graph.refreshableGraph().get(v)).or(() -> graph.graphDraw().getNodes().stream().map(arg_0 -> ((RefreshableGraph)graph.refreshableGraph()).get(arg_0)).filter(v -> {
                Type patt18017$temp = candidate.type();
                if (patt18017$temp instanceof Class) {
                    Class tc = (Class)patt18017$temp;
                    return tc.isAssignableFrom(v.getClass());
                }
                return false;
            }).findFirst());
        }
        return Optional.of(GraphUtils.findNodeByType(graph.graphDraw(), candidate.type(), candidate.tagsAsArray())).filter(l -> !l.isEmpty()).map(v -> graph.refreshableGraph().get((Node)v.iterator().next())).or(() -> graph.graphDraw().getNodes().stream().filter(n -> Arrays.equals(n.tags(), candidate.tagsAsArray())).map(arg_0 -> ((RefreshableGraph)graph.refreshableGraph()).get(arg_0)).filter(v -> {
            Type patt18968$temp = candidate.type();
            if (patt18968$temp instanceof Class) {
                Class tc = (Class)patt18968$temp;
                return tc.isAssignableFrom(v.getClass());
            }
            return false;
        }).findFirst());
    }

    private static Set<GraphCandidate> scanGraphRoots(TestClassMetadata metadata, ExtensionContext context) {
        HashSet<GraphCandidate> roots;
        block4: {
            block3: {
                roots = new HashSet<GraphCandidate>(metadata.annotationComponents);
                roots.addAll(metadata.fieldComponents);
                if (metadata.annotation.initializeMode() != KoraAppTest.InitializeMode.PER_METHOD) break block3;
                for (Parameter parameter : context.getRequiredTestMethod().getParameters()) {
                    if (!parameter.isAnnotationPresent(TestComponent.class)) continue;
                    Class<?>[] tag = KoraJUnit5Extension.parseTags(parameter);
                    Type type = parameter.getParameterizedType();
                    roots.add(new GraphCandidate(type, tag));
                }
                break block4;
            }
            if (metadata.annotation.initializeMode() != KoraAppTest.InitializeMode.PER_CLASS) break block4;
            for (Method method : context.getRequiredTestClass().getDeclaredMethods()) {
                for (Parameter parameter : method.getParameters()) {
                    if (!parameter.isAnnotationPresent(TestComponent.class)) continue;
                    Class<?>[] tag = KoraJUnit5Extension.parseTags(parameter);
                    Type type = parameter.getParameterizedType();
                    roots.add(new GraphCandidate(type, tag));
                }
            }
        }
        return roots;
    }

    private static TestGraph generateTestGraph(TestClassMetadata metadata, ExtensionContext context) {
        Class<?> applicationClass = metadata.annotation.value();
        Supplier graphSupplier = GRAPH_SUPPLIER_MAP.computeIfAbsent(applicationClass, k -> {
            try {
                long startedLoading = System.nanoTime();
                Class<?> clazz = KoraJUnit5Extension.class.getClassLoader().loadClass(applicationClass.getName() + "Graph");
                Constructor<?>[] constructors = clazz.getConstructors();
                Supplier supplier = (Supplier)constructors[0].newInstance(new Object[0]);
                logger.debug("@KoraAppTest loading took: {}", (Object)Duration.ofNanos(System.nanoTime() - startedLoading));
                return supplier;
            }
            catch (ClassNotFoundException e) {
                throw new ExtensionConfigurationException("@KoraAppTest#value must be annotated with @KoraApp, but probably wasn't: " + applicationClass, (Throwable)e);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
        long startedSubgraph = System.nanoTime();
        ApplicationGraphDraw graphDraw = ((ApplicationGraphDraw)graphSupplier.get()).copy();
        Set<GraphCandidate> roots = KoraJUnit5Extension.scanGraphRoots(metadata, context);
        Node[] nodesForSubGraph = (Node[])roots.stream().flatMap(component -> GraphUtils.findNodeByTypeOrAssignable(graphDraw, component).stream()).toArray(Node[]::new);
        ApplicationGraphDraw subGraph = nodesForSubGraph.length == 0 ? graphDraw : graphDraw.subgraph(nodesForSubGraph);
        KoraJUnit5Extension.getGraphModification(metadata.annotation, context).ifPresent(koraGraphModification -> {
            for (GraphModification modification : koraGraphModification.getModifications()) {
                modification.accept(subGraph);
            }
        });
        logger.debug("@KoraAppTest subgraph took: {}", (Object)Duration.ofNanos(System.nanoTime() - startedSubgraph));
        return new TestGraph(subGraph, metadata);
    }

    static class KoraTestContext {
        volatile TestGraph graph;
        volatile TestClassMetadata metadata;
        final KoraAppTest annotation;

        KoraTestContext(KoraAppTest annotation) {
            this.annotation = annotation;
        }
    }

    record TestClassMetadata(KoraAppTest annotation, List<Field> fieldsForInjection, Set<GraphCandidate> annotationComponents, Set<GraphCandidate> fieldComponents, Config config) {

        static interface Config {
            public static final Config NONE = new Config(){

                @Override
                public void setup(ApplicationGraphDraw graphDraw) {
                }

                @Override
                public void cleanup() {
                }
            };

            public void setup(ApplicationGraphDraw var1) throws IOException;

            public void cleanup();
        }

        static class FileConfig
        implements Config {
            private final KoraConfigModification config;
            private final Map<String, String> systemProperties;
            private Properties prevProperties;

            public FileConfig(KoraConfigModification config) {
                this.config = config;
                this.systemProperties = config.systemProperties();
            }

            @Override
            public void setup(ApplicationGraphDraw graphDraw) throws IOException {
                this.prevProperties = (Properties)System.getProperties().clone();
                KoraConfigModification koraConfigModification = this.config;
                if (koraConfigModification instanceof KoraConfigFile) {
                    KoraConfigFile kf = (KoraConfigFile)koraConfigModification;
                    System.setProperty("config.resource", kf.configFile());
                } else {
                    koraConfigModification = this.config;
                    if (koraConfigModification instanceof KoraConfigString) {
                        KoraConfigString ks = (KoraConfigString)koraConfigModification;
                        String configFileName = "kora-app-test-config-" + UUID.randomUUID();
                        logger.trace("Preparing config setup with file name: {}", (Object)configFileName);
                        Path tmpFile = Files.createTempFile(configFileName, ".txt", new FileAttribute[0]);
                        Files.writeString(tmpFile, (CharSequence)ks.config(), StandardCharsets.UTF_8, new OpenOption[0]);
                        String configPath = tmpFile.toAbsolutePath().toString();
                        System.setProperty("config.file", configPath);
                    }
                }
                if (!this.systemProperties.isEmpty()) {
                    this.systemProperties.forEach(System::setProperty);
                }
            }

            @Override
            public void cleanup() {
                if (this.prevProperties != null) {
                    logger.trace("Cleaning up after config setup");
                    System.setProperties(this.prevProperties);
                    this.prevProperties = null;
                }
            }
        }
    }
}

