/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Graph;
import ru.tinkoff.kora.application.graph.Lifecycle;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphMock;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;
import ru.tinkoff.kora.test.extension.junit5.KoraAppGraph;
import ru.tinkoff.kora.test.extension.junit5.KoraAppTest;
import ru.tinkoff.kora.test.extension.junit5.KoraAppTestConfigModifier;
import ru.tinkoff.kora.test.extension.junit5.KoraAppTestGraphModifier;
import ru.tinkoff.kora.test.extension.junit5.KoraConfigFile;
import ru.tinkoff.kora.test.extension.junit5.KoraConfigModification;
import ru.tinkoff.kora.test.extension.junit5.KoraConfigString;
import ru.tinkoff.kora.test.extension.junit5.KoraGraphModification;
import ru.tinkoff.kora.test.extension.junit5.MockComponent;
import ru.tinkoff.kora.test.extension.junit5.TestComponent;
import ru.tinkoff.kora.test.extension.junit5.TestGraph;
import ru.tinkoff.kora.test.extension.junit5.TestGraphInitialized;

final class KoraJUnit5Extension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{KoraJUnit5Extension.class});
    private static final Logger logger = LoggerFactory.getLogger(KoraJUnit5Extension.class);
    private static final Map<Class<?>, Supplier<ApplicationGraphDraw>> GRAPH_SUPPLIER_MAP = new ConcurrentHashMap();

    KoraJUnit5Extension() {
    }

    @Nonnull
    private static KoraTestContext getKoraTestContext(ExtensionContext context) {
        ExtensionContext.Store storage = context.getStore(NAMESPACE);
        KoraTestContext koraTestContext = (KoraTestContext)storage.get(KoraAppTest.class, KoraTestContext.class);
        if (koraTestContext == null) {
            KoraAppTest koraAppTest = KoraJUnit5Extension.findKoraAppTest(context).orElseThrow(() -> new ExtensionConfigurationException("@KoraAppTest not found"));
            TestInstance.Lifecycle lifecycle = context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
            koraTestContext = new KoraTestContext(koraAppTest, lifecycle);
            storage.put(KoraAppTest.class, (Object)koraTestContext);
        }
        return koraTestContext;
    }

    private static void prepareMocks(TestGraphInitialized graphInitialized) {
        logger.trace("Resetting mocks...");
        for (Node node : graphInitialized.graphDraw().getNodes()) {
            Object mockCandidate = graphInitialized.refreshableGraph().get(node);
            if (!MockUtil.isMock((Object)mockCandidate) && !MockUtil.isSpy((Object)mockCandidate)) continue;
            Mockito.reset((Object[])new Object[]{mockCandidate});
            if (!(mockCandidate instanceof Lifecycle)) continue;
            Lifecycle lifecycle = (Lifecycle)mockCandidate;
            Mockito.when((Object)lifecycle.init()).thenReturn((Object)Mono.empty());
            Mockito.when((Object)lifecycle.release()).thenReturn((Object)Mono.empty());
        }
    }

    private static void injectComponentsToFields(TestClassMetadata metadata, TestGraphInitialized graphInitialized, ExtensionContext context) {
        if (metadata.fieldsForInjection.isEmpty()) {
            return;
        }
        Object testInstance = context.getTestInstance().orElseThrow(() -> new ExtensionConfigurationException("@KoraAppTest can't get TestInstance for @TestComponent field injection"));
        for (Field field : metadata.fieldsForInjection) {
            Class<?>[] tags = KoraJUnit5Extension.parseTags(field);
            GraphCandidate candidate = new GraphCandidate(field.getGenericType(), tags);
            logger.trace("Looking for test method '{}' field '{}' inject candidate: {}", new Object[]{context.getDisplayName(), field.getName(), candidate});
            Object component = KoraJUnit5Extension.getComponentFromGraph(graphInitialized, candidate);
            KoraJUnit5Extension.injectToField(testInstance, field, component);
        }
    }

    private static void injectToField(Object testInstance, Field field, Object value) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new ExtensionConfigurationException("Field '%s' annotated have illegal 'static' modifier".formatted(field.getName()));
        }
        if (Modifier.isFinal(field.getModifiers())) {
            throw new ExtensionConfigurationException("Field '%s' annotated have illegal 'final' modifier".formatted(field.getName()));
        }
        try {
            field.setAccessible(true);
            field.set(testInstance, value);
        }
        catch (Exception e) {
            throw new ExtensionConfigurationException("Failed to inject field '%s' due to: ".formatted(field.getName()) + e);
        }
    }

    public static KoraTestContext getInitializedKoraTestContext(InitMode initMode, ExtensionContext context) {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getKoraTestContext(context);
        if (koraTestContext.metadata == null) {
            koraTestContext.metadata = KoraJUnit5Extension.getClassMetadata(koraTestContext, initMode, context);
        }
        if (koraTestContext.graph == null) {
            koraTestContext.graph = KoraJUnit5Extension.generateTestGraph(koraTestContext.metadata, context);
            koraTestContext.graph.initialize();
        }
        return koraTestContext;
    }

    public void beforeAll(ExtensionContext context) {
        KoraJUnit5Extension.getKoraTestContext(context);
    }

    public void beforeEach(ExtensionContext context) {
        long started = System.nanoTime();
        KoraTestContext koraTestContext = KoraJUnit5Extension.getInitializedKoraTestContext(InitMode.METHOD, context);
        KoraJUnit5Extension.prepareMocks(koraTestContext.graph.initialized());
        KoraJUnit5Extension.injectComponentsToFields(koraTestContext.metadata, koraTestContext.graph.initialized(), context);
        logger.info("@KoraAppTest test method '{}' setup took: {}", (Object)context.getDisplayName(), (Object)Duration.ofNanos(System.nanoTime() - started));
    }

    public void afterEach(ExtensionContext context) {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getKoraTestContext(context);
        if (koraTestContext.lifecycle == TestInstance.Lifecycle.PER_METHOD && koraTestContext.graph != null) {
            koraTestContext.graph.close();
            koraTestContext.graph = null;
        }
    }

    public void afterAll(ExtensionContext context) {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getKoraTestContext(context);
        if (koraTestContext.lifecycle == TestInstance.Lifecycle.PER_CLASS && koraTestContext.graph != null) {
            koraTestContext.graph.close();
        }
    }

    private static Optional<KoraAppTest> findKoraAppTest(ExtensionContext context) {
        Optional current = Optional.of(context);
        while (current.isPresent()) {
            Class requiredTestClass = current.get().getRequiredTestClass();
            while (!requiredTestClass.equals(Object.class)) {
                Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)requiredTestClass, KoraAppTest.class);
                if (annotation.isPresent()) {
                    return annotation;
                }
                requiredTestClass = requiredTestClass.getSuperclass();
            }
            current = current.get().getParent();
        }
        return Optional.empty();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        return Arrays.stream(parameterContext.getParameter().getDeclaredAnnotations()).anyMatch(a -> a.annotationType().equals(TestComponent.class) || a.annotationType().equals(MockComponent.class)) || parameterContext.getParameter().getType().equals(KoraAppGraph.class) || parameterContext.getParameter().getType().equals(Graph.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getInitializedKoraTestContext(InitMode.CONSTRUCTOR, context);
        GraphCandidate graphCandidate = KoraJUnit5Extension.getGraphCandidate(parameterContext);
        logger.trace("Looking for test method '{}' parameter '{}' inject candidate: {}", new Object[]{context.getDisplayName(), parameterContext.getParameter().getName(), graphCandidate});
        return KoraJUnit5Extension.getComponentFromGraph(koraTestContext.graph.initialized(), graphCandidate);
    }

    private static Optional<KoraGraphModification> getGraphModification(ApplicationGraphDraw graphDraw, TestMethodMetadata metadata, ExtensionContext context) {
        long started = System.nanoTime();
        Set<GraphMock> mockComponentFromParameters = metadata.parameterMocks();
        Set<GraphMock> mockComponentFromFields = metadata.classMetadata().fieldMocks();
        Set<GraphMock> mockComponentFromConstructor = metadata.classMetadata().constructorMocks();
        HashSet<GraphMock> mocks = new HashSet<GraphMock>(mockComponentFromParameters);
        mocks.addAll(mockComponentFromFields);
        mocks.addAll(mockComponentFromConstructor);
        KoraGraphModification koraGraphModification = context.getTestInstance().filter(inst -> inst instanceof KoraAppTestGraphModifier).map(inst -> ((KoraAppTestGraphModifier)inst).graph()).map(graph -> {
            mocks.forEach(m -> graph.mockComponent(m.candidate().type(), m.candidate().tags()));
            return graph;
        }).orElseGet(() -> {
            if (mocks.isEmpty()) {
                return null;
            }
            KoraGraphModification graph = KoraGraphModification.create();
            mocks.forEach(m -> graph.mockComponent(m.candidate().type(), m.candidate().tags()));
            return graph;
        });
        logger.debug("@KoraAppTest graph modification collecting took: {}", (Object)Duration.ofNanos(System.nanoTime() - started));
        return Optional.ofNullable(koraGraphModification);
    }

    private static TestMethodMetadata getMethodMetadata(TestClassMetadata classMetadata, ExtensionContext context) {
        HashSet<GraphCandidate> parameterComponents;
        Set<GraphMock> parameterMocks;
        block9: {
            block8: {
                parameterMocks = context.getTestMethod().filter(method -> !method.isSynthetic()).stream().flatMap(m -> Stream.of(m.getParameters())).filter(parameter -> parameter.getDeclaredAnnotation(MockComponent.class) != null).map(parameter -> {
                    if (KoraAppGraph.class.isAssignableFrom(parameter.getType())) {
                        throw new ExtensionConfigurationException("KoraAppGraph can't be target of @MockComponent");
                    }
                    Class<?>[] tag = KoraJUnit5Extension.parseTags(parameter);
                    return new GraphMock(new GraphCandidate(parameter.getParameterizedType(), tag));
                }).collect(Collectors.toSet());
                if (classMetadata.lifecycle == TestInstance.Lifecycle.PER_CLASS && !parameterMocks.isEmpty()) {
                    throw new ExtensionConfigurationException("@KoraAppTest when run in 'TestInstance.Lifecycle.PER_CLASS' test can't inject @MockComponent in method parameters");
                }
                parameterComponents = new HashSet<GraphCandidate>();
                if (classMetadata.lifecycle != TestInstance.Lifecycle.PER_METHOD) break block8;
                if (classMetadata.initMode == InitMode.METHOD) {
                    for (Parameter parameter2 : context.getRequiredTestMethod().getParameters()) {
                        if (!parameter2.isAnnotationPresent(TestComponent.class)) continue;
                        Class<?>[] tag = KoraJUnit5Extension.parseTags(parameter2);
                        Type type = parameter2.getParameterizedType();
                        parameterComponents.add(new GraphCandidate(type, tag));
                    }
                } else {
                    for (Method method2 : context.getRequiredTestClass().getDeclaredMethods()) {
                        for (Parameter parameter3 : method2.getParameters()) {
                            if (!parameter3.isAnnotationPresent(TestComponent.class) && !parameter3.isAnnotationPresent(MockComponent.class)) continue;
                            throw new ExtensionConfigurationException("@TestComponent or @MockComponent can't be applied to method arguments when constructor injection is used, please use field injection");
                        }
                    }
                }
                break block9;
            }
            if (classMetadata.lifecycle != TestInstance.Lifecycle.PER_CLASS) break block9;
            for (Method method3 : context.getRequiredTestClass().getDeclaredMethods()) {
                for (Parameter parameter4 : method3.getParameters()) {
                    if (!parameter4.isAnnotationPresent(TestComponent.class)) continue;
                    Class<?>[] tag = KoraJUnit5Extension.parseTags(parameter4);
                    Type type = parameter4.getParameterizedType();
                    parameterComponents.add(new GraphCandidate(type, tag));
                }
            }
        }
        return new TestMethodMetadata(classMetadata, parameterComponents, parameterMocks);
    }

    private static TestClassMetadata getClassMetadata(KoraTestContext koraAppTest, InitMode initMode, ExtensionContext context) {
        long started = System.nanoTime();
        Set<GraphCandidate> annotationCandidates = Arrays.stream(koraAppTest.annotation.components()).map(GraphCandidate::new).collect(Collectors.toSet());
        TestClassMetadata.Config koraAppConfig = context.getTestInstance().filter(inst -> inst instanceof KoraAppTestConfigModifier).map(inst -> {
            KoraConfigModification configModification = ((KoraAppTestConfigModifier)inst).config();
            return new TestClassMetadata.FileConfig(configModification);
        }).orElse(TestClassMetadata.Config.NONE);
        Class testClass = (Class)context.getTestClass().orElseThrow(() -> new ExtensionConfigurationException("@KoraAppTest can't get TestInstance for @TestComponent field injection"));
        List fieldsForInjection = ReflectionUtils.findFields((Class)testClass, f -> !f.isSynthetic() && (f.getAnnotation(TestComponent.class) != null || f.getAnnotation(MockComponent.class) != null), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
        Set<GraphCandidate> fieldComponents = fieldsForInjection.stream().filter(f -> f.getAnnotation(TestComponent.class) != null).map(field -> {
            Class<?>[] tags = KoraJUnit5Extension.parseTags(field);
            return new GraphCandidate(field.getGenericType(), tags);
        }).collect(Collectors.toSet());
        Set<GraphMock> fieldMocks = fieldsForInjection.stream().filter(f -> f.getAnnotation(MockComponent.class) != null).map(field -> {
            Class<?>[] tags = KoraJUnit5Extension.parseTags(field);
            return new GraphMock(new GraphCandidate(field.getGenericType(), tags));
        }).collect(Collectors.toSet());
        HashSet<GraphCandidate> constructorComponents = new HashSet<GraphCandidate>();
        HashSet<GraphMock> constructorMocks = new HashSet<GraphMock>();
        if (initMode == InitMode.CONSTRUCTOR) {
            Constructor<?> constructor = context.getRequiredTestClass().getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            for (Parameter parameter : constructor.getParameters()) {
                Type type;
                Class<?>[] tag;
                if (parameter.isAnnotationPresent(TestComponent.class)) {
                    tag = KoraJUnit5Extension.parseTags(parameter);
                    type = parameter.getParameterizedType();
                    constructorComponents.add(new GraphCandidate(type, tag));
                    continue;
                }
                if (!parameter.isAnnotationPresent(MockComponent.class)) continue;
                tag = KoraJUnit5Extension.parseTags(parameter);
                type = parameter.getParameterizedType();
                constructorMocks.add(new GraphMock(new GraphCandidate(type, tag)));
            }
        }
        logger.debug("@KoraAppTest class metadata collecting took: {}", (Object)Duration.ofNanos(System.nanoTime() - started));
        return new TestClassMetadata(koraAppTest.annotation, koraAppTest.lifecycle, initMode, koraAppConfig, annotationCandidates, fieldsForInjection, fieldComponents, fieldMocks, constructorComponents, constructorMocks);
    }

    private static GraphCandidate getGraphCandidate(ParameterContext parameterContext) {
        Type parameterType = parameterContext.getParameter().getParameterizedType();
        Class<?>[] tags = KoraJUnit5Extension.parseTags(parameterContext.getParameter());
        return new GraphCandidate(parameterType, tags);
    }

    private static Class<?>[] parseTags(AnnotatedElement object) {
        return Arrays.stream(object.getDeclaredAnnotations()).filter(a -> a.annotationType().equals(Tag.class)).map(a -> ((Tag)a).value()).findFirst().orElse(null);
    }

    private static Object getComponentFromGraph(TestGraphInitialized graph, GraphCandidate candidate) {
        ArrayList<Object> objects;
        if (KoraAppGraph.class.equals((Object)candidate.type())) {
            return graph.koraAppGraph();
        }
        if (Graph.class.equals((Object)candidate.type())) {
            return graph.refreshableGraph();
        }
        List nodes = graph.graphDraw().findNodesByType(candidate.type(), (Class[])candidate.tagsAsArray());
        if (nodes.size() == 1) {
            return graph.refreshableGraph().get((Node)nodes.get(0));
        }
        if (nodes.size() > 1) {
            throw new ExtensionConfigurationException(candidate + " expected to have one suitable component, got " + nodes.size());
        }
        Type type = candidate.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            objects = new ArrayList();
            for (Node node : graph.graphDraw().getNodes()) {
                Object object = graph.refreshableGraph().get(node);
                if (!clazz.isInstance(object)) continue;
                if (candidate.tags().isEmpty() && node.tags().length == 0) {
                    objects.add(object);
                    continue;
                }
                if (candidate.tags().size() == 1 && candidate.tags().get(0).getCanonicalName().equals("ru.tinkoff.kora.common.Tag.Any")) {
                    objects.add(object);
                    continue;
                }
                if (!Arrays.equals(candidate.tagsAsArray(), node.tags())) continue;
                objects.add(object);
            }
            if (objects.size() == 1) {
                return objects.get(0);
            }
            if (objects.size() > 1) {
                throw new ExtensionConfigurationException(candidate + " expected to have one suitable component, got " + objects.size());
            }
        }
        if ((objects = candidate.type()) instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)((Object)objects);
            objects = new ArrayList<Object>();
            Class clazz = (Class)parameterizedType.getRawType();
            for (Node node : graph.graphDraw().getNodes()) {
                Object object = graph.refreshableGraph().get(node);
                if (!clazz.isInstance(object) || !KoraJUnit5Extension.doesExtendOrImplement(object.getClass(), parameterizedType)) continue;
                if (candidate.tags().isEmpty() && node.tags().length == 0) {
                    objects.add(object);
                    continue;
                }
                if (candidate.tags().size() == 1 && candidate.tags().get(0).getCanonicalName().equals("ru.tinkoff.kora.common.Tag.Any")) {
                    objects.add(object);
                    continue;
                }
                if (!Arrays.equals(candidate.tagsAsArray(), node.tags())) continue;
                objects.add(object);
            }
            if (objects.size() == 1) {
                return objects.get(0);
            }
            if (objects.size() > 1) {
                throw new ExtensionConfigurationException(candidate + " expected to have one suitable component, got " + objects.size());
            }
        }
        throw new ExtensionConfigurationException(candidate + " was not found in graph, please check @KoraAppTest configuration");
    }

    private static boolean doesImplement(Class<?> aClass, ParameterizedType parameterizedType) {
        for (Type genericInterface : aClass.getGenericInterfaces()) {
            if (!genericInterface.equals(parameterizedType)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesExtendOrImplement(Class<?> aClass, ParameterizedType parameterizedType) {
        if (KoraJUnit5Extension.doesImplement(aClass, parameterizedType)) {
            return true;
        }
        Type superclass = aClass.getGenericSuperclass();
        if (superclass == null) {
            return false;
        }
        if (superclass.equals(parameterizedType)) {
            return true;
        }
        if (superclass instanceof Class) {
            Class clazz = (Class)superclass;
            return KoraJUnit5Extension.doesExtendOrImplement(clazz, parameterizedType);
        }
        if (superclass instanceof ParameterizedType) {
            ParameterizedType clazz = (ParameterizedType)superclass;
            return KoraJUnit5Extension.doesExtendOrImplement((Class)clazz.getRawType(), parameterizedType);
        }
        return false;
    }

    private static Set<GraphCandidate> scanGraphRoots(TestMethodMetadata metadata, ExtensionContext context) {
        HashSet<GraphCandidate> roots = new HashSet<GraphCandidate>(metadata.classMetadata.annotationComponents);
        roots.addAll(metadata.classMetadata.fieldComponents);
        roots.addAll(metadata.parameterComponents);
        roots.addAll(metadata.classMetadata.constructorComponents);
        return roots;
    }

    private static TestGraph generateTestGraph(TestClassMetadata classMetadata, ExtensionContext context) {
        Set<Node<?>> mockCandidates;
        Class<?> applicationClass = classMetadata.annotation.value();
        Supplier graphSupplier = GRAPH_SUPPLIER_MAP.computeIfAbsent(applicationClass, k -> {
            try {
                long startedLoading = System.nanoTime();
                Class<?> clazz = KoraJUnit5Extension.class.getClassLoader().loadClass(applicationClass.getName() + "Graph");
                Constructor<?>[] constructors = clazz.getConstructors();
                Supplier supplier = (Supplier)constructors[0].newInstance(new Object[0]);
                logger.debug("@KoraAppTest loading took: {}", (Object)Duration.ofNanos(System.nanoTime() - startedLoading));
                return supplier;
            }
            catch (ClassNotFoundException e) {
                throw new ExtensionConfigurationException("@KoraAppTest#value must be annotated with @KoraApp, but probably wasn't: " + applicationClass, (Throwable)e);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
        long startedSubgraph = System.nanoTime();
        TestMethodMetadata methodMetadata = KoraJUnit5Extension.getMethodMetadata(classMetadata, context);
        ApplicationGraphDraw graphDraw = ((ApplicationGraphDraw)graphSupplier.get()).copy();
        Set<GraphCandidate> roots = KoraJUnit5Extension.scanGraphRoots(methodMetadata, context);
        Set nodesForSubGraph = roots.stream().flatMap(component -> GraphUtils.findNodeByTypeOrAssignable(graphDraw, component).stream()).collect(Collectors.toSet());
        ArrayList mocks = new ArrayList();
        for (GraphMock fieldMock : classMetadata.fieldMocks) {
            mockCandidates = GraphUtils.findNodeByTypeOrAssignable(graphDraw, fieldMock.candidate());
            mocks.addAll(mockCandidates);
        }
        for (GraphMock parameterMock : methodMetadata.parameterMocks) {
            mockCandidates = GraphUtils.findNodeByTypeOrAssignable(graphDraw, parameterMock.candidate());
            mocks.addAll(mockCandidates);
        }
        for (GraphMock constructorMock : methodMetadata.classMetadata.constructorMocks) {
            mockCandidates = GraphUtils.findNodeByTypeOrAssignable(graphDraw, constructorMock.candidate());
            mocks.addAll(mockCandidates);
        }
        ApplicationGraphDraw subGraph = nodesForSubGraph.isEmpty() ? (mocks.isEmpty() ? graphDraw : graphDraw.subgraph(mocks, (Iterable)graphDraw.getNodes())) : graphDraw.subgraph(mocks, nodesForSubGraph);
        KoraJUnit5Extension.getGraphModification(graphDraw, methodMetadata, context).ifPresent(koraGraphModification -> {
            for (GraphModification modification : koraGraphModification.getModifications()) {
                modification.accept(subGraph);
            }
        });
        logger.debug("@KoraAppTest subgraph took: {}", (Object)Duration.ofNanos(System.nanoTime() - startedSubgraph));
        return new TestGraph(subGraph, classMetadata);
    }

    static class KoraTestContext {
        volatile TestGraph graph;
        volatile TestClassMetadata metadata;
        final KoraAppTest annotation;
        final TestInstance.Lifecycle lifecycle;

        KoraTestContext(KoraAppTest annotation, TestInstance.Lifecycle lifecycle) {
            this.annotation = annotation;
            this.lifecycle = lifecycle;
        }
    }

    record TestClassMetadata(KoraAppTest annotation, TestInstance.Lifecycle lifecycle, InitMode initMode, Config config, Set<GraphCandidate> annotationComponents, List<Field> fieldsForInjection, Set<GraphCandidate> fieldComponents, Set<GraphMock> fieldMocks, Set<GraphCandidate> constructorComponents, Set<GraphMock> constructorMocks) {

        static interface Config {
            public static final Config NONE = new Config(){

                @Override
                public void setup(ApplicationGraphDraw graphDraw) {
                }

                @Override
                public void cleanup() {
                }
            };

            public void setup(ApplicationGraphDraw var1) throws IOException;

            public void cleanup();
        }

        static class FileConfig
        implements Config {
            private final KoraConfigModification config;
            private final Map<String, String> systemProperties;
            private Properties prevProperties;

            public FileConfig(KoraConfigModification config) {
                this.config = config;
                this.systemProperties = config.systemProperties();
            }

            @Override
            public void setup(ApplicationGraphDraw graphDraw) throws IOException {
                this.prevProperties = (Properties)System.getProperties().clone();
                KoraConfigModification koraConfigModification = this.config;
                if (koraConfigModification instanceof KoraConfigFile) {
                    KoraConfigFile kf = (KoraConfigFile)koraConfigModification;
                    System.setProperty("config.resource", kf.configFile());
                } else {
                    koraConfigModification = this.config;
                    if (koraConfigModification instanceof KoraConfigString) {
                        KoraConfigString ks = (KoraConfigString)koraConfigModification;
                        String configFileName = "kora-app-test-config-" + UUID.randomUUID();
                        logger.trace("Preparing config setup with file name: {}", (Object)configFileName);
                        Path tmpFile = Files.createTempFile(configFileName, ".txt", new FileAttribute[0]);
                        Files.writeString(tmpFile, (CharSequence)ks.config(), StandardCharsets.UTF_8, new OpenOption[0]);
                        String configPath = tmpFile.toAbsolutePath().toString();
                        System.setProperty("config.file", configPath);
                    }
                }
                if (!this.systemProperties.isEmpty()) {
                    this.systemProperties.forEach(System::setProperty);
                }
            }

            @Override
            public void cleanup() {
                if (this.prevProperties != null) {
                    logger.trace("Cleaning up after config setup");
                    System.setProperties(this.prevProperties);
                    this.prevProperties = null;
                }
            }
        }
    }

    static enum InitMode {
        CONSTRUCTOR,
        METHOD;

    }

    record TestMethodMetadata(TestClassMetadata classMetadata, Set<GraphCandidate> parameterComponents, Set<GraphMock> parameterMocks) {
    }
}

