/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import io.mockk.MockKKt;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import ru.tinkoff.kora.test.extension.junit5.KoraJUnit5Extension;

final class MockUtils {
    private static final boolean isMockitoAvailable = MockUtils.isClassPresent("org.mockito.internal.util.MockUtil");
    private static final boolean isMockkAvailable = MockUtils.isClassPresent("io.mockk.MockKKt");

    private MockUtils() {
    }

    private static boolean isClassPresent(String className) {
        try {
            return KoraJUnit5Extension.class.getClassLoader().loadClass(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static boolean haveAnyMockEngine() {
        return isMockitoAvailable || isMockkAvailable;
    }

    static void resetIfMock(Object mockCandidate) {
        if (isMockitoAvailable && (MockUtil.isMock((Object)mockCandidate) || MockUtil.isSpy((Object)mockCandidate))) {
            Mockito.reset((Object[])new Object[]{mockCandidate});
        }
        if (isMockkAvailable) {
            MockKKt.clearAllMocks((boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }
}

