/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import org.mockito.Mockito;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;

record GraphMock(GraphCandidate candidate, Class<?> mockClass) implements GraphModification
{
    GraphMock(GraphCandidate candidate) {
        this(candidate, GraphMock.getClassToMock(candidate));
    }

    @Override
    public void accept(ApplicationGraphDraw graphDraw) {
        Set<Node<?>> nodesToMock = GraphUtils.findNodeByTypeOrAssignable(graphDraw, this.candidate());
        if (nodesToMock.isEmpty()) {
            throw new IllegalArgumentException("Can't mock component %s because it is not present in graph".formatted(this.candidate.toString()));
        }
        for (Node<?> nodeToMock : nodesToMock) {
            GraphMock.replaceNode(graphDraw, nodeToMock, this.mockClass());
        }
    }

    private static Class<?> getClassToMock(GraphCandidate candidate) {
        ParameterizedType pt;
        Type type = candidate.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        Type type2 = candidate.type();
        if (type2 instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type2).getRawType()) instanceof Class) {
            Class clazz = (Class)type2;
            return clazz;
        }
        throw new IllegalArgumentException("Can't mock type: " + candidate);
    }

    private static <T> void replaceNode(ApplicationGraphDraw graphDraw, Node<?> node, Class<T> mockClass) {
        Node<?> casted = node;
        graphDraw.replaceNode(casted, g -> {
            Object mock = Mockito.mock((Class)mockClass);
            return mock;
        });
    }
}

