/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import io.mockk.impl.JvmMockKGateway;
import io.mockk.impl.annotations.SpyK;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;

record GraphMockkSpyk(GraphCandidate candidate, Class<?> mockClass, Object value, String spykName, boolean recordPrivateCalls) implements GraphModification
{
    static GraphModification ofField(GraphCandidate candidate, Field field, Object testClassInstance) {
        Class<?> classToMock = GraphMockkSpyk.getClassToMock(candidate);
        try {
            field.setAccessible(true);
            Object inst = field.get(testClassInstance);
            if (inst == null) {
                throw new IllegalArgumentException("Can't @SpyK component '%s' because it is null, initialize field first".formatted(candidate.toString()));
            }
            SpyK annotation = field.getAnnotation(SpyK.class);
            String name = Optional.of(annotation.name()).filter(n -> !n.isBlank()).orElseGet(field::getName);
            return new GraphMockkSpyk(candidate, classToMock, inst, name, annotation.recordPrivateCalls());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't extract @SpyK component '%s' from: %s".formatted(candidate.type(), testClassInstance));
        }
    }

    @Override
    public void accept(ApplicationGraphDraw graphDraw) {
        Set<Node<?>> nodesToMock = GraphUtils.findNodeByTypeOrAssignable(graphDraw, this.candidate());
        if (nodesToMock.isEmpty()) {
            throw new IllegalArgumentException("Can't @SpyK component '%s' because it is not present in graph".formatted(this.candidate.toString()));
        }
        for (Node<?> nodeToMock : nodesToMock) {
            this.replaceNode(graphDraw, nodeToMock, this.mockClass());
        }
    }

    private static Class<?> getClassToMock(GraphCandidate candidate) {
        ParameterizedType pt;
        Type type = candidate.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        Type type2 = candidate.type();
        if (type2 instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type2).getRawType()) instanceof Class) {
            Class clazz = (Class)type2;
            return clazz;
        }
        throw new IllegalArgumentException("Can't @SpyK using MockK for type: " + candidate);
    }

    private <T> void replaceNode(ApplicationGraphDraw graphDraw, Node<?> node, Class<T> mockClass) {
        Node<?> casted = node;
        graphDraw.replaceNode(casted, g -> {
            KClass kotlinClass = JvmClassMappingKt.getKotlinClass((Class)mockClass);
            return JvmMockKGateway.Companion.getDefaultImplementation().getMockFactory().spyk(kotlinClass, this.value, this.spykName, new KClass[0], true);
        });
    }
}

