/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Graph;
import ru.tinkoff.kora.application.graph.RefreshableGraph;
import ru.tinkoff.kora.test.extension.junit5.DefaultKoraAppGraph;
import ru.tinkoff.kora.test.extension.junit5.KoraJUnit5Extension;
import ru.tinkoff.kora.test.extension.junit5.TestGraphInitialized;

final class TestGraph
implements AutoCloseable {
    private static final Object LOCK = new Object();
    private static final Logger logger = LoggerFactory.getLogger(KoraJUnit5Extension.class);
    private final ApplicationGraphDraw graph;
    private final KoraJUnit5Extension.TestClassMetadata meta;
    private volatile TestGraphInitialized graphInitialized;

    TestGraph(ApplicationGraphDraw graph, KoraJUnit5Extension.TestClassMetadata meta) {
        this.graph = graph;
        this.meta = meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize() {
        logger.debug("@KoraAppTest graph initializing...");
        long started = System.nanoTime();
        Object object = LOCK;
        synchronized (object) {
            KoraJUnit5Extension.TestClassMetadata.Config config = this.meta.config();
            try {
                config.setup(this.graph);
                RefreshableGraph initGraph = this.graph.init();
                this.graphInitialized = new TestGraphInitialized(initGraph, this.graph, new DefaultKoraAppGraph(this.graph, (Graph)initGraph));
                logger.info("@KoraAppTest graph initialization took: {}", (Object)Duration.ofNanos(System.nanoTime() - started));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            finally {
                config.cleanup();
            }
        }
    }

    @Nonnull
    TestGraphInitialized initialized() {
        if (this.graphInitialized == null) {
            throw new IllegalStateException("TestGraphInitialized is not initialized!");
        }
        return this.graphInitialized;
    }

    @Override
    public void close() {
        if (this.graphInitialized != null) {
            long started = System.nanoTime();
            logger.debug("@KoraAppTest graph releasing...");
            try {
                this.graphInitialized.refreshableGraph().release();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.graphInitialized = null;
            logger.info("@KoraAppTest graph releasing took: {}", (Object)Duration.ofNanos(System.nanoTime() - started));
        }
    }
}

