/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import ru.tinkoff.kora.test.extension.junit5.GraphAddition;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphReplacementNoDeps;
import ru.tinkoff.kora.test.extension.junit5.GraphReplacementWithDeps;
import ru.tinkoff.kora.test.extension.junit5.KoraAppGraph;

public final class KoraGraphModification {
    private final List<GraphModification> modifications = new ArrayList<GraphModification>();

    private KoraGraphModification() {
    }

    public static KoraGraphModification create() {
        return new KoraGraphModification();
    }

    @Nonnull
    public <T> KoraGraphModification addComponent(@Nonnull Type typeToAdd, @Nonnull Supplier<T> instanceSupplier) {
        this.modifications.add(new GraphAddition(s -> instanceSupplier.get(), new GraphCandidate(typeToAdd)));
        return this;
    }

    @Nonnull
    public <T> KoraGraphModification addComponent(@Nonnull Type typeToAdd, @Nonnull List<Class<?>> tags, @Nonnull Supplier<T> instanceSupplier) {
        if (tags.isEmpty()) {
            return this.addComponent(typeToAdd, instanceSupplier);
        }
        this.modifications.add(new GraphAddition(s -> instanceSupplier.get(), new GraphCandidate(typeToAdd, tags)));
        return this;
    }

    @Nonnull
    public <T> KoraGraphModification addComponent(@Nonnull Type typeToAdd, @Nonnull Function<KoraAppGraph, T> instanceSupplier) {
        this.modifications.add(new GraphAddition(instanceSupplier, new GraphCandidate(typeToAdd)));
        return this;
    }

    @Nonnull
    public <T> KoraGraphModification addComponent(@Nonnull Type typeToAdd, @Nonnull List<Class<?>> tags, @Nonnull Function<KoraAppGraph, T> instanceSupplier) {
        if (tags.isEmpty()) {
            return this.addComponent(typeToAdd, instanceSupplier);
        }
        this.modifications.add(new GraphAddition(instanceSupplier, new GraphCandidate(typeToAdd, tags)));
        return this;
    }

    @Nonnull
    public <T> KoraGraphModification replaceComponent(@Nonnull Type typeToReplace, @Nonnull Supplier<? extends T> replacementSupplier) {
        this.modifications.add(new GraphReplacementWithDeps<Object>(g -> replacementSupplier.get(), new GraphCandidate(typeToReplace)));
        return this;
    }

    @Nonnull
    public <T> KoraGraphModification replaceComponent(@Nonnull Type typeToReplace, @Nonnull List<Class<?>> tags, @Nonnull Supplier<? extends T> replacementSupplier) {
        if (tags.isEmpty()) {
            return this.replaceComponent(typeToReplace, replacementSupplier);
        }
        this.modifications.add(new GraphReplacementWithDeps<Object>(g -> replacementSupplier.get(), new GraphCandidate(typeToReplace, tags)));
        return this;
    }

    @Nonnull
    public <T> KoraGraphModification replaceComponent(@Nonnull Type typeToReplace, @Nonnull Function<KoraAppGraph, ? extends T> replacementSupplier) {
        this.modifications.add(new GraphReplacementWithDeps<T>(replacementSupplier, new GraphCandidate(typeToReplace)));
        return this;
    }

    @Nonnull
    public <T> KoraGraphModification replaceComponent(@Nonnull Type typeToReplace, @Nonnull List<Class<?>> tags, @Nonnull Function<KoraAppGraph, ? extends T> replacementSupplier) {
        if (tags.isEmpty()) {
            return this.replaceComponent(typeToReplace, replacementSupplier);
        }
        this.modifications.add(new GraphReplacementWithDeps<T>(replacementSupplier, new GraphCandidate(typeToReplace, tags)));
        return this;
    }

    @Nonnull
    public <T> KoraGraphModification mockComponent(@Nonnull Type typeToMock, @Nonnull Supplier<? extends T> replacementSupplier) {
        this.modifications.add(new GraphReplacementNoDeps<Object>(g -> replacementSupplier.get(), new GraphCandidate(typeToMock)));
        return this;
    }

    @Nonnull
    public <T> KoraGraphModification mockComponent(@Nonnull Type typeToMock, @Nonnull List<Class<?>> tags, @Nonnull Supplier<? extends T> replacementSupplier) {
        if (tags.isEmpty()) {
            return this.mockComponent(typeToMock, replacementSupplier);
        }
        this.modifications.add(new GraphReplacementNoDeps<Object>(g -> replacementSupplier.get(), new GraphCandidate(typeToMock, tags)));
        return this;
    }

    @Nonnull
    List<GraphModification> getModifications() {
        return this.modifications;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KoraGraphModification)) {
            return false;
        }
        KoraGraphModification that = (KoraGraphModification)o;
        return Objects.equals(this.modifications, that.modifications);
    }

    public int hashCode() {
        return Objects.hash(this.modifications);
    }
}

