/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.KoraJUnit5Extension;

final class GraphUtils {
    private static final Class<?>[] TAG_ANY = new Class[]{Tag.Any.class};

    private GraphUtils() {
    }

    static <T> Set<Node<T>> findNodeByType(ApplicationGraphDraw graph, GraphCandidate candidate) {
        return GraphUtils.findNodeByType(graph, candidate.type(), candidate.tagsAsArray());
    }

    static <T> Set<Node<T>> findNodeByType(ApplicationGraphDraw graph, Type type, Class<?>[] tags) {
        if (tags == null || tags.length == 0) {
            Node node = graph.findNodeByType(type);
            return node == null ? Set.of() : Set.of(node);
        }
        if (Arrays.equals(TAG_ANY, tags)) {
            HashSet<Node<T>> nodes = new HashSet<Node<T>>();
            for (Node graphNode : graph.getNodes()) {
                if (graphNode.type().equals(type)) {
                    nodes.add(graphNode);
                    continue;
                }
                Type unwrappedType = GraphUtils.unwrap(graphNode.type());
                if (!unwrappedType.equals(type)) continue;
                nodes.add(graphNode);
            }
            return nodes;
        }
        for (Node graphNode : graph.getNodes()) {
            if (!Arrays.equals(tags, graphNode.tags())) continue;
            if (graphNode.type().equals(type)) {
                return Set.of(graphNode);
            }
            Type unwrappedType = GraphUtils.unwrap(graphNode.type());
            if (!unwrappedType.equals(type)) continue;
            return Set.of(graphNode);
        }
        return Set.of();
    }

    static Set<Node<?>> findNodeByTypeOrAssignable(ApplicationGraphDraw graph, GraphCandidate candidate) {
        return GraphUtils.findNodeByTypeOrAssignable(graph, candidate.type(), candidate.tagsAsArray());
    }

    static Set<Node<?>> findNodeByTypeOrAssignable(ApplicationGraphDraw graph, Type type, Class<?>[] tags) {
        if (tags == null || tags.length == 0) {
            HashSet nodes = new HashSet();
            for (Node graphNode : graph.getNodes()) {
                Type graphType = graphNode.type();
                if (graphType.equals(type)) {
                    nodes.add(graphNode);
                } else {
                    Type unwrappedType = GraphUtils.unwrap(graphType);
                    if (unwrappedType.equals(type)) {
                        nodes.add(graphNode);
                        graphType = unwrappedType;
                    }
                }
                Optional<Class<?>> typeClass = GraphUtils.tryCastType(type);
                Optional<Class<?>> graphClass = GraphUtils.tryCastType(graphType);
                if (!typeClass.isPresent() || !graphClass.isPresent() || !typeClass.get().isAssignableFrom(graphClass.get())) continue;
                nodes.add(graphNode);
            }
            return nodes;
        }
        if (Arrays.equals(TAG_ANY, tags)) {
            HashSet nodes = new HashSet();
            for (Node graphNode : graph.getNodes()) {
                Type graphType = graphNode.type();
                if (graphType.equals(type)) {
                    nodes.add(graphNode);
                } else {
                    Type unwrappedType = GraphUtils.unwrap(graphType);
                    if (unwrappedType.equals(type)) {
                        nodes.add(graphNode);
                        graphType = unwrappedType;
                    }
                }
                Optional<Class<?>> typeClass = GraphUtils.tryCastType(type);
                Optional<Class<?>> graphClass = GraphUtils.tryCastType(graphType);
                if (!typeClass.isPresent() || !graphClass.isPresent() || !typeClass.get().isAssignableFrom(graphClass.get())) continue;
                nodes.add(graphNode);
            }
            return nodes;
        }
        for (Node graphNode : graph.getNodes()) {
            if (!Arrays.equals(tags, graphNode.tags())) continue;
            if (graphNode.type().equals(type)) {
                return Set.of(graphNode);
            }
            Type unwrappedType = GraphUtils.unwrap(graphNode.type());
            if (unwrappedType.equals(type)) {
                return Set.of(graphNode);
            }
            Optional<Class<?>> typeClass = GraphUtils.tryCastType(type);
            Optional<Class<?>> graphClass = GraphUtils.tryCastType(graphNode.type());
            Optional<Class<?>> graphClassUnwrapped = GraphUtils.tryCastType(graphNode.type());
            if (typeClass.isPresent() && graphClass.isPresent() && typeClass.get().isAssignableFrom(graphClass.get())) {
                return Set.of(graphNode);
            }
            if (!typeClass.isPresent() || !graphClassUnwrapped.isPresent() || !typeClass.get().isAssignableFrom(graphClassUnwrapped.get())) continue;
            return Set.of(graphNode);
        }
        return Set.of();
    }

    static Type unwrap(Type type) {
        Class pct;
        ParameterizedType pt;
        Type type2;
        Class tc;
        if (type instanceof Class && Wrapped.class.isAssignableFrom(tc = (Class)type)) {
            return Arrays.stream(tc.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).filter(i -> {
                Class rt;
                Type patt5874$temp = ((ParameterizedType)i).getRawType();
                return patt5874$temp instanceof Class && Wrapped.class.isAssignableFrom(rt = (Class)patt5874$temp);
            }).findFirst().map(i -> ((ParameterizedType)i).getActualTypeArguments()[0]).filter(arg -> arg instanceof Class).orElse(type);
        }
        if (type instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type).getRawType()) instanceof Class && Wrapped.class.isAssignableFrom(pct = (Class)type2)) {
            return pt.getActualTypeArguments()[0];
        }
        return type;
    }

    static Optional<Class<?>> tryCastType(Type type) {
        try {
            if (type instanceof Class) {
                Class tc = (Class)type;
                return Optional.of(tc);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType tp = (ParameterizedType)type;
                return tp.getRawType() instanceof Class ? Optional.ofNullable((Class)tp.getRawType()) : Optional.ofNullable(KoraJUnit5Extension.class.getClassLoader().loadClass(tp.getRawType().getTypeName()));
            }
            return Optional.empty();
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

