/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.Answer;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;

record GraphMockitoMock(GraphCandidate candidate, Class<?> mockClass, String name, Mock annotation) implements GraphModification
{
    public static GraphModification ofAnnotated(GraphCandidate candidate, AnnotatedElement element, String defaultName) {
        Mock annotation = element.getAnnotation(Mock.class);
        String name = Optional.of(annotation.name()).filter(n -> !n.isBlank()).orElse(defaultName);
        return new GraphMockitoMock(candidate, GraphMockitoMock.getClassToMock(candidate), name, annotation);
    }

    @Override
    public void accept(ApplicationGraphDraw graphDraw) {
        Set<Node<?>> nodesToMock = GraphUtils.findNodeByTypeOrAssignable(graphDraw, this.candidate());
        if (nodesToMock.isEmpty()) {
            throw new IllegalArgumentException("Can't @Mock component '%s' because it is not present in graph".formatted(this.candidate.toString()));
        }
        for (Node<?> nodeToMock : nodesToMock) {
            this.replaceNode(graphDraw, nodeToMock, this.mockClass());
        }
    }

    private static Class<?> getClassToMock(GraphCandidate candidate) {
        ParameterizedType pt;
        Type type = candidate.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        Type type2 = candidate.type();
        if (type2 instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type2).getRawType()) instanceof Class) {
            Class clazz = (Class)type2;
            return clazz;
        }
        throw new IllegalArgumentException("Can't @Mock using Mockito for type: " + String.valueOf(candidate));
    }

    private <T> void replaceNode(ApplicationGraphDraw graphDraw, Node<T> node, Class<?> mockClass) {
        graphDraw.replaceNode(node, g -> {
            ParameterizedType pt;
            Class tc;
            MockSettings settings = new MockSettingsImpl().name(this.name).defaultAnswer((Answer)this.annotation.answer());
            if (!this.annotation.mockMaker().isBlank()) {
                settings = settings.mockMaker(this.annotation.mockMaker());
            }
            if (this.annotation.extraInterfaces().length != 0) {
                settings = settings.extraInterfaces(this.annotation.extraInterfaces());
            }
            if (this.annotation.strictness() != Mock.Strictness.TEST_LEVEL_DEFAULT) {
                Strictness strictLevel = switch (this.annotation.strictness()) {
                    case Mock.Strictness.WARN -> Strictness.WARN;
                    case Mock.Strictness.LENIENT -> Strictness.LENIENT;
                    case Mock.Strictness.STRICT_STUBS -> Strictness.STRICT_STUBS;
                    default -> throw new UnsupportedOperationException("Unknown strictness level provided: " + String.valueOf(this.annotation.strictness()));
                };
                settings = settings.strictness(strictLevel);
            }
            if (this.annotation.withoutAnnotations()) {
                settings = settings.withoutAnnotations();
            }
            if (this.annotation.stubOnly()) {
                settings = settings.stubOnly();
            }
            if (this.annotation.serializable()) {
                settings = settings.serializable();
            }
            Object mock = Mockito.mock((Class)mockClass, (MockSettings)settings);
            Type patt3562$temp = node.type();
            if (patt3562$temp instanceof Class && Wrapped.class.isAssignableFrom(tc = (Class)patt3562$temp)) {
                return () -> mock;
            }
            Type patt3713$temp = node.type();
            if (patt3713$temp instanceof ParameterizedType && Wrapped.class.isAssignableFrom((Class)(pt = (ParameterizedType)patt3713$temp).getRawType())) {
                return () -> mock;
            }
            return mock;
        });
    }
}

