/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Graph;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.common.util.TimeUtils;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphMockitoMock;
import ru.tinkoff.kora.test.extension.junit5.GraphMockitoSpy;
import ru.tinkoff.kora.test.extension.junit5.GraphMockkMock;
import ru.tinkoff.kora.test.extension.junit5.GraphMockkSpyk;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;
import ru.tinkoff.kora.test.extension.junit5.KoraAppGraph;
import ru.tinkoff.kora.test.extension.junit5.KoraAppTest;
import ru.tinkoff.kora.test.extension.junit5.KoraAppTestConfigModifier;
import ru.tinkoff.kora.test.extension.junit5.KoraAppTestGraphModifier;
import ru.tinkoff.kora.test.extension.junit5.KoraConfigFile;
import ru.tinkoff.kora.test.extension.junit5.KoraConfigModification;
import ru.tinkoff.kora.test.extension.junit5.KoraConfigString;
import ru.tinkoff.kora.test.extension.junit5.KoraGraphModification;
import ru.tinkoff.kora.test.extension.junit5.MockUtils;
import ru.tinkoff.kora.test.extension.junit5.TestComponent;
import ru.tinkoff.kora.test.extension.junit5.TestGraph;
import ru.tinkoff.kora.test.extension.junit5.TestGraphInitialized;

final class KoraJUnit5Extension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{KoraJUnit5Extension.class});
    private static final Logger logger = LoggerFactory.getLogger(KoraJUnit5Extension.class);
    private static final Map<Class<?>, Supplier<ApplicationGraphDraw>> GRAPH_SUPPLIER_MAP = new ConcurrentHashMap();

    KoraJUnit5Extension() {
    }

    @Nonnull
    private static KoraTestContext getKoraTestContext(ExtensionContext context) {
        ExtensionContext.Store storage = context.getStore(NAMESPACE);
        KoraTestContext koraTestContext = (KoraTestContext)storage.get(KoraAppTest.class, KoraTestContext.class);
        if (koraTestContext == null) {
            KoraAppTest koraAppTest = KoraJUnit5Extension.findKoraAppTest(context).orElseThrow(() -> new ExtensionConfigurationException("@KoraAppTest not found"));
            TestInstance.Lifecycle lifecycle = context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
            koraTestContext = new KoraTestContext(koraAppTest, lifecycle);
            storage.put(KoraAppTest.class, (Object)koraTestContext);
        }
        return koraTestContext;
    }

    private void prepareMocks(TestGraphInitialized graphInitialized) {
        logger.debug("Resetting mocks...");
        if (MockUtils.haveAnyMockEngine()) {
            for (Node node : graphInitialized.graphDraw().getNodes()) {
                Object mockCandidate = graphInitialized.refreshableGraph().get(node);
                MockUtils.resetIfMock(mockCandidate);
            }
        }
    }

    private void injectComponentsToFields(TestClassMetadata metadata, TestGraphInitialized graphInitialized, ExtensionContext context) {
        if (metadata.fieldsForInjection.isEmpty()) {
            return;
        }
        Object testInstance = context.getTestInstance().map(inst -> {
            if (inst.getClass().isAnnotationPresent(Nested.class)) {
                return Arrays.stream(inst.getClass().getDeclaredFields()).filter(f -> f.getType().equals(metadata.testClass())).findFirst().map(f -> {
                    try {
                        f.setAccessible(true);
                        return f.get(inst);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException("Failed retrieving parent test class inside @Nested test class: " + String.valueOf(inst.getClass()));
                    }
                }).orElseThrow(() -> new IllegalStateException("Failed searching parent test class inside @Nested test class: " + String.valueOf(inst.getClass())));
            }
            return inst;
        }).orElseThrow(() -> new ExtensionConfigurationException("@KoraAppTest can't get TestInstance for @TestComponent field injection"));
        for (Field field : metadata.fieldsForInjection) {
            Class<?>[] tags = KoraJUnit5Extension.parseTags(field);
            GraphCandidate candidate = new GraphCandidate(field.getGenericType(), tags);
            logger.debug("Looking for test method '{}' field '{}' inject candidate: {}", new Object[]{KoraJUnit5Extension.getTestMethodName(context), field.getName(), candidate});
            Object component = KoraJUnit5Extension.getComponentFromGraph(graphInitialized, candidate);
            KoraJUnit5Extension.injectToField(testInstance, field, component);
        }
    }

    private static void injectToField(Object testInstance, Field field, Object value) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw new ExtensionConfigurationException("Field '%s' annotated have illegal 'static' modifier".formatted(field.getName()));
        }
        if (Modifier.isFinal(field.getModifiers())) {
            throw new ExtensionConfigurationException("Field '%s' annotated have illegal 'final' modifier".formatted(field.getName()));
        }
        try {
            field.setAccessible(true);
            field.set(testInstance, value);
        }
        catch (Exception e) {
            throw new ExtensionConfigurationException("Failed to inject field '%s' due to: ".formatted(field.getName()) + String.valueOf(e));
        }
    }

    public static KoraTestContext getInitializedKoraTestContext(InitializeOrigin initializeOrigin, ExtensionContext context) {
        String testTarget;
        long started = TimeUtils.started();
        KoraTestContext koraTestContext = KoraJUnit5Extension.getKoraTestContext(context);
        boolean haveMetadata = koraTestContext.metadata != null;
        boolean haveGraph = koraTestContext.graph != null;
        boolean isReady = haveMetadata && haveGraph;
        String string = testTarget = koraTestContext.lifecycle == TestInstance.Lifecycle.PER_METHOD ? "method '" + KoraJUnit5Extension.getTestMethodName(context) + "'" : "class '" + KoraJUnit5Extension.getTestClassName(context) + "'";
        if (!isReady) {
            logger.info("@KoraAppTest test {} setup started...", (Object)testTarget);
        }
        long startedMeta = TimeUtils.started();
        if (!haveMetadata) {
            logger.debug("@KoraAppTest test class '{}' metadata scan started...", (Object)KoraJUnit5Extension.getTestClassName(context));
            koraTestContext.metadata = KoraJUnit5Extension.getClassMetadata(koraTestContext, initializeOrigin, context);
            logger.debug("@KoraAppTest test class '{}' metadata scan took: {}", (Object)KoraJUnit5Extension.getTestClassName(context), (Object)TimeUtils.tookForLogging((long)startedMeta));
        }
        long startedGraph = TimeUtils.started();
        if (!haveGraph) {
            logger.debug("@KoraAppTest test {} graph initialization started...", (Object)testTarget);
            koraTestContext.graph = KoraJUnit5Extension.generateTestGraph(koraTestContext.metadata, context);
            koraTestContext.graph.initialize();
            logger.debug("@KoraAppTest test {} graph initialization took: {}", (Object)testTarget, (Object)TimeUtils.tookForLogging((long)startedGraph));
        }
        if (!isReady) {
            logger.info("@KoraAppTest test {} setup took: {}", (Object)testTarget, (Object)TimeUtils.tookForLogging((long)started));
        }
        return koraTestContext;
    }

    public void beforeAll(ExtensionContext context) {
        MDC.clear();
        KoraJUnit5Extension.getKoraTestContext(context);
    }

    public void beforeEach(ExtensionContext context) {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getInitializedKoraTestContext(InitializeOrigin.METHOD, context);
        MDC.clear();
        this.prepareMocks(koraTestContext.graph.initialized());
        this.injectComponentsToFields(koraTestContext.metadata, koraTestContext.graph.initialized(), context);
    }

    public void afterEach(ExtensionContext context) {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getKoraTestContext(context);
        if (koraTestContext.lifecycle == TestInstance.Lifecycle.PER_METHOD && koraTestContext.graph != null) {
            logger.debug("@KoraAppTest test method '{}' cleanup started...", (Object)KoraJUnit5Extension.getTestMethodName(context));
            long started = TimeUtils.started();
            koraTestContext.graph.close();
            koraTestContext.graph = null;
            logger.info("@KoraAppTest test method '{}' cleanup took: {}", (Object)KoraJUnit5Extension.getTestMethodName(context), (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public void afterAll(ExtensionContext context) {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getKoraTestContext(context);
        if (koraTestContext.lifecycle == TestInstance.Lifecycle.PER_CLASS && !context.getRequiredTestClass().isAnnotationPresent(Nested.class) && koraTestContext.graph != null) {
            logger.debug("@KoraAppTest test class '{}' cleanup started...", (Object)KoraJUnit5Extension.getTestClassName(context));
            long started = TimeUtils.started();
            koraTestContext.graph.close();
            logger.info("@KoraAppTest test class '{}' cleanup took: {}", (Object)KoraJUnit5Extension.getTestClassName(context), (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    private static Optional<KoraAppTest> findKoraAppTest(ExtensionContext context) {
        Optional current = Optional.of(context);
        while (current.isPresent()) {
            Class requiredTestClass = current.get().getRequiredTestClass();
            while (!requiredTestClass.equals(Object.class)) {
                Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)requiredTestClass, KoraAppTest.class);
                if (annotation.isPresent()) {
                    return annotation;
                }
                requiredTestClass = requiredTestClass.getSuperclass();
            }
            current = current.get().getParent();
        }
        return Optional.empty();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        return KoraJUnit5Extension.isCandidate(parameterContext.getParameter()) || parameterContext.getParameter().getType().equals(KoraAppGraph.class) || parameterContext.getParameter().getType().equals(Graph.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        KoraTestContext koraTestContext = KoraJUnit5Extension.getInitializedKoraTestContext(InitializeOrigin.CONSTRUCTOR, context);
        GraphCandidate graphCandidate = KoraJUnit5Extension.getGraphCandidate(parameterContext);
        if (parameterContext.getDeclaringExecutable() instanceof Constructor) {
            logger.debug("Looking for test class '{}' constructor parameter '{}' inject candidate: {}", new Object[]{KoraJUnit5Extension.getTestClassName(context), parameterContext.getParameter().getName(), graphCandidate});
        } else {
            logger.debug("Looking for test method '{}' parameter '{}' inject candidate: {}", new Object[]{KoraJUnit5Extension.getTestMethodName(context), parameterContext.getParameter().getName(), graphCandidate});
        }
        return KoraJUnit5Extension.getComponentFromGraph(koraTestContext.graph.initialized(), graphCandidate);
    }

    private static String getTestClassName(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        String packageName = testClass.getPackageName();
        return packageName.isBlank() ? testClass.getSimpleName() : testClass.getCanonicalName().substring(packageName.length() + 1);
    }

    private static String getTestMethodName(ExtensionContext context) {
        String methodName = context.getTestMethod().map(m -> m.getName() + Arrays.stream(m.getParameters()).map(p -> p.getType().getSimpleName()).collect(Collectors.joining(", ", "(", ")"))).orElse(context.getDisplayName());
        return KoraJUnit5Extension.getTestClassName(context) + "#" + methodName;
    }

    private static List<GraphModification> getGraphModifications(TestMethodMetadata metadata, ExtensionContext context) {
        Set<GraphModification> mockComponentFromParameters = metadata.parameterMocks();
        Set<GraphModification> mockComponentFromFields = metadata.classMetadata().fieldMocks();
        Set<GraphModification> mockComponentFromConstructor = metadata.classMetadata().constructorMocks();
        HashSet<GraphModification> mocks = new HashSet<GraphModification>(mockComponentFromParameters);
        mocks.addAll(mockComponentFromFields);
        mocks.addAll(mockComponentFromConstructor);
        KoraGraphModification koraGraphModification = context.getTestInstance().filter(inst -> inst instanceof KoraAppTestGraphModifier).map(inst -> ((KoraAppTestGraphModifier)inst).graph()).orElseGet(KoraGraphModification::create);
        ArrayList<GraphModification> graphModifications = new ArrayList<GraphModification>(koraGraphModification.getModifications());
        graphModifications.addAll(mocks);
        return graphModifications;
    }

    private static TestMethodMetadata getMethodMetadata(TestClassMetadata classMetadata, ExtensionContext context) {
        HashSet<GraphCandidate> parameterComponents;
        Set<GraphModification> parameterMocks;
        block7: {
            block6: {
                if (classMetadata.initializeOrigin == InitializeOrigin.CONSTRUCTOR) {
                    context.getTestMethod().ifPresent(method -> {
                        if (Arrays.stream(method.getParameters()).anyMatch(KoraJUnit5Extension::isCandidate)) {
                            throw new ExtensionConfigurationException("@KoraAppTest when uses constructor injection, can't inject @TestComponents or @Mock as method parameters");
                        }
                    });
                }
                parameterMocks = context.getTestMethod().filter(method -> !method.isSynthetic()).stream().flatMap(m -> Stream.of(m.getParameters())).filter(KoraJUnit5Extension::isMock).map(KoraJUnit5Extension::mockParameter).collect(Collectors.toSet());
                if (classMetadata.lifecycle == TestInstance.Lifecycle.PER_CLASS && !parameterMocks.isEmpty()) {
                    throw new ExtensionConfigurationException("@KoraAppTest when run in 'TestInstance.Lifecycle.PER_CLASS' test can't inject Mocks in method parameters");
                }
                parameterComponents = new HashSet<GraphCandidate>();
                if (classMetadata.lifecycle != TestInstance.Lifecycle.PER_METHOD) break block6;
                if (classMetadata.initializeOrigin != InitializeOrigin.METHOD) break block7;
                for (Parameter parameter : context.getRequiredTestMethod().getParameters()) {
                    if (!KoraJUnit5Extension.isComponent(parameter)) continue;
                    Class<?>[] tag = KoraJUnit5Extension.parseTags(parameter);
                    Type type = parameter.getParameterizedType();
                    parameterComponents.add(new GraphCandidate(type, tag));
                }
                break block7;
            }
            if (classMetadata.lifecycle == TestInstance.Lifecycle.PER_CLASS) {
                for (Method method2 : context.getRequiredTestClass().getDeclaredMethods()) {
                    for (Parameter parameter : method2.getParameters()) {
                        if (!KoraJUnit5Extension.isComponent(parameter)) continue;
                        Class<?>[] tag = KoraJUnit5Extension.parseTags(parameter);
                        Type type = parameter.getParameterizedType();
                        parameterComponents.add(new GraphCandidate(type, tag));
                    }
                }
            }
        }
        return new TestMethodMetadata(classMetadata, parameterComponents, parameterMocks);
    }

    private static TestClassMetadata getClassMetadata(KoraTestContext koraAppTest, InitializeOrigin initializeOrigin, ExtensionContext context) {
        Class testClass = (Class)context.getTestClass().orElseThrow(() -> new ExtensionConfigurationException("@KoraAppTest can't get TestInstance for @TestComponent field injection"));
        if (initializeOrigin == InitializeOrigin.CONSTRUCTOR) {
            if (KoraAppTestGraphModifier.class.isAssignableFrom(testClass)) {
                throw new ExtensionConfigurationException("@KoraAppTest when uses constructor injection, can't use KoraAppTestGraphModifier cause it requires test class instance first, use field injection");
            }
            if (KoraAppTestConfigModifier.class.isAssignableFrom(testClass)) {
                throw new ExtensionConfigurationException("@KoraAppTest when uses constructor injection, can't use KoraAppTestConfigModifier cause it requires test class instance first, use field injection");
            }
        }
        Set<GraphCandidate> annotationCandidates = Arrays.stream(koraAppTest.annotation.components()).map(GraphCandidate::new).collect(Collectors.toSet());
        Set<GraphCandidate> koraModulesCandidates = KoraJUnit5Extension.getKoraModulesCandidates(koraAppTest);
        TestClassMetadata.Config koraAppConfig = context.getTestInstance().filter(inst -> inst instanceof KoraAppTestConfigModifier).map(inst -> {
            KoraConfigModification configModification = ((KoraAppTestConfigModifier)inst).config();
            return new TestClassMetadata.FileConfig(configModification);
        }).orElse(TestClassMetadata.Config.NONE);
        List fieldsForInjection = ReflectionUtils.findFields((Class)testClass, f -> !f.isSynthetic() && KoraJUnit5Extension.isCandidate(f), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN);
        Set<GraphCandidate> fieldComponents = fieldsForInjection.stream().filter(KoraJUnit5Extension::isComponent).map(field -> {
            Class<?>[] tags = KoraJUnit5Extension.parseTags(field);
            return new GraphCandidate(field.getGenericType(), tags);
        }).collect(Collectors.toSet());
        Set<GraphModification> fieldMocks = fieldsForInjection.stream().filter(KoraJUnit5Extension::isMock).map(f -> {
            Object fieldValue = null;
            if (KoraJUnit5Extension.isMockitoSpy(f) || KoraJUnit5Extension.isMockKSpyk(f)) {
                fieldValue = context.getTestInstance().map(inst -> {
                    try {
                        f.setAccessible(true);
                        return f.get(inst);
                    }
                    catch (IllegalAccessException e) {
                        Class<?>[] tags = KoraJUnit5Extension.parseTags(f);
                        GraphCandidate candidate = new GraphCandidate(f.getGenericType(), tags);
                        throw new IllegalArgumentException("Can't extract @Spy component '%s' for field: %s".formatted(candidate.type(), f.getName()));
                    }
                }).orElse(null);
            }
            return KoraJUnit5Extension.mockField(f, fieldValue);
        }).collect(Collectors.toSet());
        HashSet<GraphCandidate> constructorComponents = new HashSet<GraphCandidate>();
        HashSet<GraphModification> constructorMocks = new HashSet<GraphModification>();
        if (initializeOrigin == InitializeOrigin.CONSTRUCTOR) {
            Constructor<?> constructor = testClass.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            for (Parameter parameter : constructor.getParameters()) {
                if (KoraJUnit5Extension.isComponent(parameter)) {
                    Class<?>[] tag = KoraJUnit5Extension.parseTags(parameter);
                    Type type = parameter.getParameterizedType();
                    constructorComponents.add(new GraphCandidate(type, tag));
                    continue;
                }
                if (!KoraJUnit5Extension.isMock(parameter)) continue;
                constructorMocks.add(KoraJUnit5Extension.mockParameter(parameter));
            }
        }
        return new TestClassMetadata(testClass, koraAppTest.annotation, koraAppTest.lifecycle, initializeOrigin, koraAppConfig, annotationCandidates, koraModulesCandidates, fieldsForInjection, fieldComponents, fieldMocks, constructorComponents, constructorMocks);
    }

    private static Set<GraphCandidate> getKoraModulesCandidates(KoraTestContext koraAppTest) {
        Set moduleInterfaces = Arrays.stream(koraAppTest.annotation.modules()).filter(c -> {
            if (c.isInterface()) {
                return true;
            }
            throw new ExtensionConfigurationException("@KoraAppTest(modules = %s.class) is not an interface, only interfaces can be a module".formatted(c.getCanonicalName()));
        }).collect(Collectors.toSet());
        HashSet<GraphCandidate> factoryCandidates = new HashSet<GraphCandidate>();
        for (Class module : moduleInterfaces) {
            Method[] declaredMethods = module.getDeclaredMethods();
            List<Method> factoryMethods = Arrays.stream(module.getAnnotations()).anyMatch(a -> a.annotationType().getName().equals("kotlin.Metadata")) ? Arrays.stream(declaredMethods).toList() : Arrays.stream(declaredMethods).filter(Method::isDefault).toList();
            for (Method factoryMethod : factoryMethods) {
                Type returnType = factoryMethod.getGenericReturnType();
                Tag tag = factoryMethod.getAnnotation(Tag.class);
                if (tag == null) {
                    factoryCandidates.add(new GraphCandidate(returnType));
                    continue;
                }
                factoryCandidates.add(new GraphCandidate(returnType, tag.value()));
            }
        }
        return factoryCandidates;
    }

    private static GraphCandidate getGraphCandidate(ParameterContext parameterContext) {
        Type parameterType = parameterContext.getParameter().getParameterizedType();
        Class<?>[] tags = KoraJUnit5Extension.parseTags(parameterContext.getParameter());
        return new GraphCandidate(parameterType, tags);
    }

    private static Class<?>[] parseTags(AnnotatedElement object) {
        return Arrays.stream(object.getDeclaredAnnotations()).filter(a -> a.annotationType().equals(Tag.class)).map(a -> ((Tag)a).value()).findFirst().orElse(null);
    }

    private static Object getComponentFromGraph(TestGraphInitialized graph, GraphCandidate candidate) {
        ArrayList<Object> objects;
        if (KoraAppGraph.class.equals((Object)candidate.type())) {
            return graph.koraAppGraph();
        }
        if (Graph.class.equals((Object)candidate.type())) {
            return graph.refreshableGraph();
        }
        List nodes = graph.graphDraw().findNodesByType(candidate.type(), (Class[])candidate.tagsAsArray());
        if (nodes.size() == 1) {
            return graph.refreshableGraph().get((Node)nodes.get(0));
        }
        if (nodes.size() > 1) {
            throw new ExtensionConfigurationException(String.valueOf(candidate) + " expected to have one suitable component, got " + nodes.size());
        }
        Type type = candidate.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            objects = new ArrayList();
            for (Node node : graph.graphDraw().getNodes()) {
                Wrapped wo;
                Object object = graph.refreshableGraph().get(node);
                if (clazz.isInstance(object)) {
                    if (candidate.tags().isEmpty() && node.tags().length == 0) {
                        objects.add(object);
                        continue;
                    }
                    if (candidate.tags().size() == 1 && candidate.tags().get(0).getCanonicalName().equals("ru.tinkoff.kora.common.Tag.Any")) {
                        objects.add(object);
                        continue;
                    }
                    if (!Arrays.equals(candidate.tagsAsArray(), node.tags())) continue;
                    objects.add(object);
                    continue;
                }
                if (!(object instanceof Wrapped) || !clazz.isInstance((wo = (Wrapped)object).value())) continue;
                if (candidate.tags().isEmpty() && node.tags().length == 0) {
                    objects.add(wo.value());
                    continue;
                }
                if (candidate.tags().size() == 1 && candidate.tags().get(0).getCanonicalName().equals("ru.tinkoff.kora.common.Tag.Any")) {
                    objects.add(wo.value());
                    continue;
                }
                if (!Arrays.equals(candidate.tagsAsArray(), node.tags())) continue;
                objects.add(wo.value());
            }
            if (objects.size() == 1) {
                return objects.get(0);
            }
            if (objects.size() > 1) {
                throw new ExtensionConfigurationException(String.valueOf(candidate) + " expected to have one suitable component, got " + objects.size());
            }
        }
        if ((objects = candidate.type()) instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)((Object)objects);
            objects = new ArrayList<Object>();
            Class clazz = (Class)parameterizedType.getRawType();
            for (Node node : graph.graphDraw().getNodes()) {
                Wrapped wo;
                Object object = graph.refreshableGraph().get(node);
                if (clazz.isInstance(object) && KoraJUnit5Extension.doesExtendOrImplement(object.getClass(), parameterizedType)) {
                    if (candidate.tags().isEmpty() && node.tags().length == 0) {
                        objects.add(object);
                        continue;
                    }
                    if (candidate.tags().size() == 1 && candidate.tags().get(0).getCanonicalName().equals("ru.tinkoff.kora.common.Tag.Any")) {
                        objects.add(object);
                        continue;
                    }
                    if (!Arrays.equals(candidate.tagsAsArray(), node.tags())) continue;
                    objects.add(object);
                    continue;
                }
                if (!(object instanceof Wrapped) || !clazz.isInstance((wo = (Wrapped)object).value()) || !KoraJUnit5Extension.doesExtendOrImplement(object.getClass(), parameterizedType)) continue;
                if (candidate.tags().isEmpty() && node.tags().length == 0) {
                    objects.add(wo.value());
                    continue;
                }
                if (candidate.tags().size() == 1 && candidate.tags().get(0).getCanonicalName().equals("ru.tinkoff.kora.common.Tag.Any")) {
                    objects.add(wo.value());
                    continue;
                }
                if (!Arrays.equals(candidate.tagsAsArray(), node.tags())) continue;
                objects.add(wo.value());
            }
            if (objects.size() == 1) {
                return objects.get(0);
            }
            if (objects.size() > 1) {
                throw new ExtensionConfigurationException(String.valueOf(candidate) + " expected to have one suitable component, got " + objects.size());
            }
        }
        throw new ExtensionConfigurationException(String.valueOf(candidate) + " wasn't found in graph, please check @KoraAppTest configuration");
    }

    private static boolean doesImplement(Class<?> aClass, ParameterizedType parameterizedType) {
        for (Type genericInterface : aClass.getGenericInterfaces()) {
            if (!genericInterface.equals(parameterizedType)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesExtendOrImplement(Class<?> aClass, ParameterizedType parameterizedType) {
        if (KoraJUnit5Extension.doesImplement(aClass, parameterizedType)) {
            return true;
        }
        Type superclass = aClass.getGenericSuperclass();
        if (superclass == null) {
            return false;
        }
        if (superclass.equals(parameterizedType)) {
            return true;
        }
        if (superclass instanceof Class) {
            Class clazz = (Class)superclass;
            return KoraJUnit5Extension.doesExtendOrImplement(clazz, parameterizedType);
        }
        if (superclass instanceof ParameterizedType) {
            ParameterizedType clazz = (ParameterizedType)superclass;
            return KoraJUnit5Extension.doesExtendOrImplement((Class)clazz.getRawType(), parameterizedType);
        }
        return false;
    }

    private static boolean isCandidate(AnnotatedElement element) {
        return element.getAnnotation(TestComponent.class) != null;
    }

    private static boolean isComponent(AnnotatedElement element) {
        return KoraJUnit5Extension.isCandidate(element) && !KoraJUnit5Extension.isAnnotatedAsMock(element);
    }

    private static boolean isMock(AnnotatedElement element) {
        return KoraJUnit5Extension.isCandidate(element) && KoraJUnit5Extension.isAnnotatedAsMock(element);
    }

    private static boolean isAnnotatedAsMock(AnnotatedElement element) {
        return KoraJUnit5Extension.isMockitoMock(element) || KoraJUnit5Extension.isMockitoSpy(element) || KoraJUnit5Extension.isMockKMock(element) || KoraJUnit5Extension.isMockKSpyk(element);
    }

    private static boolean isMockitoMock(AnnotatedElement element) {
        return KoraJUnit5Extension.getAnnotation(element, "org.mockito.Mock").isPresent();
    }

    private static boolean isMockitoSpy(AnnotatedElement element) {
        return KoraJUnit5Extension.getAnnotation(element, "org.mockito.Spy").isPresent();
    }

    private static boolean isMockKMock(AnnotatedElement element) {
        return KoraJUnit5Extension.getAnnotation(element, "io.mockk.impl.annotations.MockK").isPresent();
    }

    private static boolean isMockKSpyk(AnnotatedElement element) {
        return KoraJUnit5Extension.getAnnotation(element, "io.mockk.impl.annotations.SpyK").isPresent();
    }

    private static Optional<Annotation> getAnnotation(AnnotatedElement element, String annotationName) {
        Field field;
        KProperty prop;
        Stream<Annotation> annotations = Arrays.stream(element.getAnnotations());
        if (MockUtils.haveKotlinReflect() && element instanceof Field && (prop = ReflectJvmMapping.getKotlinProperty((Field)(field = (Field)element))) != null) {
            annotations = Stream.concat(annotations, prop.getAnnotations().stream());
        }
        return annotations.filter(a -> a.annotationType().getCanonicalName().equals(annotationName)).findFirst();
    }

    private static GraphModification mockField(Field field, Object fieldValue) {
        if (KoraAppGraph.class.isAssignableFrom(field.getType())) {
            throw new ExtensionConfigurationException("KoraAppGraph can't be target of @Mock");
        }
        Class<?>[] tags = KoraJUnit5Extension.parseTags(field);
        GraphCandidate candidate = new GraphCandidate(field.getGenericType(), tags);
        if (KoraJUnit5Extension.isMockitoMock(field)) {
            return GraphMockitoMock.ofAnnotated(candidate, field, field.getName());
        }
        if (KoraJUnit5Extension.isMockitoSpy(field)) {
            return GraphMockitoSpy.ofField(candidate, field, fieldValue);
        }
        if (KoraJUnit5Extension.isMockKMock(field)) {
            return GraphMockkMock.ofAnnotated(candidate, field, field.getName());
        }
        if (KoraJUnit5Extension.isMockKSpyk(field)) {
            return GraphMockkSpyk.ofField(candidate, field, fieldValue);
        }
        throw new IllegalArgumentException("Unsupported Mocking behavior for field: " + field.getName());
    }

    private static GraphModification mockParameter(Parameter parameter) {
        if (KoraAppGraph.class.isAssignableFrom(parameter.getType())) {
            throw new ExtensionConfigurationException("KoraAppGraph can't be target of @Mock");
        }
        Class<?>[] tag = KoraJUnit5Extension.parseTags(parameter);
        GraphCandidate candidate = new GraphCandidate(parameter.getParameterizedType(), tag);
        if (KoraJUnit5Extension.isMockitoMock(parameter)) {
            return GraphMockitoMock.ofAnnotated(candidate, parameter, parameter.getName());
        }
        if (KoraJUnit5Extension.isMockitoSpy(parameter)) {
            return GraphMockitoSpy.ofAnnotated(candidate, parameter);
        }
        if (KoraJUnit5Extension.isMockKMock(parameter)) {
            return GraphMockkMock.ofAnnotated(candidate, parameter, parameter.getName());
        }
        if (KoraJUnit5Extension.isMockKSpyk(parameter)) {
            return GraphMockkSpyk.ofAnnotated(candidate, parameter, parameter.getName());
        }
        throw new UnsupportedOperationException("Unsupported Mocking behavior for parameter: " + parameter.getName());
    }

    private static Set<GraphCandidate> scanGraphRoots(TestMethodMetadata metadata) {
        Set<GraphCandidate> components = metadata.getComponents();
        Set<GraphCandidate> mocks = metadata.getMocks();
        Set<GraphCandidate> spies = metadata.getSpy();
        for (GraphCandidate mock : mocks) {
            if (!components.contains(mock)) continue;
            throw new IllegalStateException("@TestComponent can't be injected as Component and Mock simultaneously, check test declaration for: " + String.valueOf(mock));
        }
        for (GraphCandidate spy : spies) {
            if (components.contains(spy)) {
                throw new IllegalStateException("@TestComponent can't be injected as Component and Spy simultaneously, check test declaration for: " + String.valueOf(spy));
            }
            if (!mocks.contains(spy)) continue;
            throw new IllegalStateException("@TestComponent can't be injected as Mock and Spy simultaneously, check test declaration for: " + String.valueOf(spy));
        }
        Set mockGraphComponents = Stream.of(metadata.classMetadata.fieldMocks, metadata.parameterMocks, metadata.classMetadata.constructorMocks).flatMap(Collection::stream).map(GraphModification::candidate).collect(Collectors.toSet());
        HashSet<GraphCandidate> result = new HashSet<GraphCandidate>(components);
        result.addAll(mockGraphComponents);
        return result;
    }

    private static TestGraph generateTestGraph(TestClassMetadata classMetadata, ExtensionContext context) {
        Class<?> applicationClass = classMetadata.annotation.value();
        long started = TimeUtils.started();
        Supplier graphSupplier = GRAPH_SUPPLIER_MAP.computeIfAbsent(applicationClass, k -> {
            try {
                Class<?> clazz = KoraJUnit5Extension.class.getClassLoader().loadClass(applicationClass.getName() + "Graph");
                Constructor<?>[] constructors = clazz.getConstructors();
                Supplier supplier = (Supplier)constructors[0].newInstance(new Object[0]);
                logger.info("@KoraApp application '{}' graph class loading took: {}", (Object)applicationClass.getSimpleName(), (Object)TimeUtils.tookForLogging((long)started));
                return supplier;
            }
            catch (ClassNotFoundException e) {
                throw new ExtensionConfigurationException("@KoraAppTest#value must be annotated with @KoraApp, can't find generated application graph: " + String.valueOf(applicationClass), (Throwable)e);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
        TestMethodMetadata methodMetadata = KoraJUnit5Extension.getMethodMetadata(classMetadata, context);
        ApplicationGraphDraw graphDraw = ((ApplicationGraphDraw)graphSupplier.get()).copy();
        Set<GraphCandidate> roots = KoraJUnit5Extension.scanGraphRoots(methodMetadata);
        Set nodesForSubGraph = roots.stream().flatMap(component -> GraphUtils.findNodeByTypeOrAssignable(graphDraw, component).stream()).collect(Collectors.toSet());
        Set<GraphCandidate> mockCandidates = methodMetadata.getGraphMockCandidates(m -> {
            GraphMockkSpyk spyk;
            GraphMockitoSpy spy;
            return m instanceof GraphMockitoMock || m instanceof GraphMockkMock || m instanceof GraphMockitoSpy && !(spy = (GraphMockitoSpy)m).isSpyGraph() || m instanceof GraphMockkSpyk && !(spyk = (GraphMockkSpyk)m).isSpyGraph();
        });
        ArrayList mocks = new ArrayList();
        for (GraphCandidate mockCandidate : mockCandidates) {
            Set<Node<?>> mockNodes = GraphUtils.findNodeByTypeOrAssignable(graphDraw, mockCandidate);
            mocks.addAll(mockNodes);
        }
        ApplicationGraphDraw subGraph = nodesForSubGraph.isEmpty() ? (mocks.isEmpty() ? graphDraw : graphDraw.subgraph(mocks, (Iterable)graphDraw.getNodes())) : graphDraw.subgraph(mocks, nodesForSubGraph);
        List<GraphModification> graphModifications = KoraJUnit5Extension.getGraphModifications(methodMetadata, context);
        for (GraphModification modification : graphModifications) {
            modification.accept(subGraph);
        }
        return new TestGraph(subGraph, classMetadata);
    }

    static class KoraTestContext {
        volatile TestGraph graph;
        volatile TestClassMetadata metadata;
        final KoraAppTest annotation;
        final TestInstance.Lifecycle lifecycle;

        KoraTestContext(KoraAppTest annotation, TestInstance.Lifecycle lifecycle) {
            this.annotation = annotation;
            this.lifecycle = lifecycle;
        }
    }

    record TestClassMetadata(Class<?> testClass, KoraAppTest annotation, TestInstance.Lifecycle lifecycle, InitializeOrigin initializeOrigin, Config config, Set<GraphCandidate> annotationComponents, Set<GraphCandidate> annotationComponentsFromModules, List<Field> fieldsForInjection, Set<GraphCandidate> fieldComponents, Set<GraphModification> fieldMocks, Set<GraphCandidate> constructorComponents, Set<GraphModification> constructorMocks) {

        static interface Config {
            public static final Config NONE = new Config(){

                @Override
                public void setup(ApplicationGraphDraw graphDraw) {
                }

                @Override
                public void cleanup() {
                }
            };

            public void setup(ApplicationGraphDraw var1) throws IOException;

            public void cleanup();
        }

        static class FileConfig
        implements Config {
            private final KoraConfigModification config;
            private final Map<String, String> systemProperties;
            private Properties prevProperties;

            public FileConfig(KoraConfigModification config) {
                this.config = config;
                this.systemProperties = config.systemProperties();
            }

            @Override
            public void setup(ApplicationGraphDraw graphDraw) throws IOException {
                this.prevProperties = (Properties)System.getProperties().clone();
                KoraConfigModification koraConfigModification = this.config;
                if (koraConfigModification instanceof KoraConfigFile) {
                    KoraConfigFile kf = (KoraConfigFile)koraConfigModification;
                    System.setProperty("config.resource", kf.configFile());
                } else {
                    koraConfigModification = this.config;
                    if (koraConfigModification instanceof KoraConfigString) {
                        KoraConfigString ks = (KoraConfigString)koraConfigModification;
                        String configFileName = "kora-app-test-config-" + String.valueOf(UUID.randomUUID());
                        logger.trace("Preparing config setup with file name: {}", (Object)configFileName);
                        Path tmpFile = Files.createTempFile(configFileName, ".txt", new FileAttribute[0]);
                        Files.writeString(tmpFile, (CharSequence)ks.config(), StandardCharsets.UTF_8, new OpenOption[0]);
                        String configPath = tmpFile.toAbsolutePath().toString();
                        System.setProperty("config.file", configPath);
                    }
                }
                if (!this.systemProperties.isEmpty()) {
                    this.systemProperties.forEach(System::setProperty);
                }
            }

            @Override
            public void cleanup() {
                if (this.prevProperties != null) {
                    logger.trace("Cleaning up after config setup");
                    System.setProperties(this.prevProperties);
                    this.prevProperties = null;
                }
            }
        }
    }

    static enum InitializeOrigin {
        CONSTRUCTOR,
        METHOD;

    }

    record TestMethodMetadata(TestClassMetadata classMetadata, Set<GraphCandidate> parameterComponents, Set<GraphModification> parameterMocks) {
        public Set<GraphCandidate> getComponents() {
            HashSet<GraphCandidate> roots = new HashSet<GraphCandidate>();
            roots.addAll(this.classMetadata.annotationComponents);
            roots.addAll(this.classMetadata.annotationComponentsFromModules);
            roots.addAll(this.classMetadata.fieldComponents);
            roots.addAll(this.parameterComponents);
            roots.addAll(this.classMetadata.constructorComponents);
            return roots;
        }

        public Set<GraphCandidate> getMocks() {
            return this.getGraphMockCandidates(m -> m instanceof GraphMockitoMock || m instanceof GraphMockkMock);
        }

        public Set<GraphCandidate> getSpy() {
            return this.getGraphMockCandidates(m -> m instanceof GraphMockitoSpy || m instanceof GraphMockkSpyk);
        }

        private Set<GraphCandidate> getGraphMockCandidates(Predicate<GraphModification> predicate) {
            return Stream.of(this.classMetadata.fieldMocks, this.parameterMocks, this.classMetadata.constructorMocks).flatMap(Collection::stream).filter(predicate).map(GraphModification::candidate).collect(Collectors.toSet());
        }
    }
}

