/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import jakarta.annotation.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import org.mockito.Mockito;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.application.graph.internal.NodeImpl;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;

record GraphMockitoSpy(GraphCandidate candidate, Class<?> mockClass, @Nullable Object value) implements GraphModification
{
    public static GraphModification ofAnnotated(GraphCandidate candidate, AnnotatedElement element) {
        Class<?> classToMock = GraphMockitoSpy.getClassToMock(candidate);
        return new GraphMockitoSpy(candidate, classToMock, null);
    }

    public static GraphModification ofField(GraphCandidate candidate, Field field, Object fieldValue) {
        Class<?> classToMock = GraphMockitoSpy.getClassToMock(candidate);
        return new GraphMockitoSpy(candidate, classToMock, fieldValue);
    }

    public boolean isSpyGraph() {
        return this.value == null;
    }

    @Override
    public void accept(ApplicationGraphDraw graphDraw) {
        Set<Node<?>> nodesToMock = GraphUtils.findNodeByTypeOrAssignable(graphDraw, this.candidate());
        if (nodesToMock.isEmpty()) {
            throw new IllegalArgumentException("Can't @Spy component '%s' because it is not present in graph".formatted(this.candidate.toString()));
        }
        for (Node<?> nodeToMock : nodesToMock) {
            this.replaceNode(graphDraw, nodeToMock);
        }
    }

    private static Class<?> getClassToMock(GraphCandidate candidate) {
        ParameterizedType pt;
        Type type = candidate.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        Type type2 = candidate.type();
        if (type2 instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type2).getRawType()) instanceof Class) {
            Class clazz = (Class)type2;
            return clazz;
        }
        throw new IllegalArgumentException("Can't @Spy using Mockito for type: " + String.valueOf(candidate));
    }

    private <T> void replaceNode(ApplicationGraphDraw graphDraw, Node<T> node) {
        if (this.value != null) {
            graphDraw.replaceNode(node, g -> {
                Object spyCandidate = this.value;
                return this.getSpy(spyCandidate, node);
            });
        } else {
            graphDraw.replaceNodeKeepDependencies(node, g -> {
                Object spyCandidate = ((NodeImpl)node).factory.get(g);
                return this.getSpy(spyCandidate, node);
            });
        }
    }

    private <T> T getSpy(T spyCandidate, Node<T> node) {
        ParameterizedType pt;
        Class tc;
        Object spy = Mockito.spy(spyCandidate);
        Type type = node.type();
        if (type instanceof Class && Wrapped.class.isAssignableFrom(tc = (Class)type)) {
            return (T)((Wrapped)() -> spy);
        }
        type = node.type();
        if (type instanceof ParameterizedType && Wrapped.class.isAssignableFrom((Class)(pt = (ParameterizedType)type).getRawType())) {
            return (T)((Wrapped)() -> spy);
        }
        return (T)spy;
    }
}

