/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import io.mockk.MockKKt;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import ru.tinkoff.kora.test.extension.junit5.KoraJUnit5Extension;

final class MockUtils {
    private static final boolean isMockitoAvailable = MockUtils.isClassPresent("org.mockito.internal.util.MockUtil");
    private static final boolean isMockkAvailable = MockUtils.isClassPresent("io.mockk.MockKKt");

    private MockUtils() {
    }

    private static boolean isClassPresent(String className) {
        try {
            return KoraJUnit5Extension.class.getClassLoader().loadClass(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static boolean haveKotlinReflect() {
        return MockUtils.isClassPresent("kotlin.reflect.jvm.ReflectJvmMapping");
    }

    static boolean haveAnyMockEngine() {
        return isMockitoAvailable || isMockkAvailable;
    }

    static void resetIfMock(Object mockCandidate) {
        if (isMockitoAvailable && (MockUtil.isMock((Object)mockCandidate) || MockUtil.isSpy((Object)mockCandidate))) {
            Mockito.reset((Object[])new Object[]{mockCandidate});
        }
        if (isMockkAvailable) {
            MockKKt.clearAllMocks((boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    static <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> annotationClass) {
        T annotation = element.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        if (MockUtils.haveKotlinReflect() && element instanceof Field) {
            Field field = (Field)element;
            KProperty prop = ReflectJvmMapping.getKotlinProperty((Field)field);
            if (prop == null) {
                return null;
            }
            return (T)((Annotation)prop.getAnnotations().stream().filter(a -> a.annotationType().equals(annotationClass)).findFirst().map(annotationClass::cast).orElse(null));
        }
        return null;
    }
}

