/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Graph;
import ru.tinkoff.kora.application.graph.RefreshableGraph;
import ru.tinkoff.kora.common.util.TimeUtils;
import ru.tinkoff.kora.test.extension.junit5.DefaultKoraAppGraph;
import ru.tinkoff.kora.test.extension.junit5.KoraJUnit5Extension;
import ru.tinkoff.kora.test.extension.junit5.TestGraphContext;

final class TestGraph
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(KoraJUnit5Extension.class);
    private final ApplicationGraphDraw graph;
    private final KoraJUnit5Extension.TestMethodMetadata metadata;
    private volatile TestGraphContext graphInitialized;
    private volatile Status status;

    TestGraph(ApplicationGraphDraw graph, KoraJUnit5Extension.TestMethodMetadata metadata) {
        this.graph = graph;
        this.metadata = metadata;
        this.status = Status.CREATED;
    }

    void initialize() {
        logger.trace("@KoraAppTest dependency container initializing...");
        long started = TimeUtils.started();
        KoraJUnit5Extension.TestClassMetadata.Config config = this.metadata.classMetadata().config();
        try {
            config.setup(this.graph);
            RefreshableGraph initGraph = this.graph.init();
            this.graphInitialized = new TestGraphContext(initGraph, this.graph, new DefaultKoraAppGraph(this.graph, (Graph)initGraph));
            this.status = Status.INITIALIZED;
            logger.debug("@KoraAppTest dependency container initialized in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            config.cleanup();
        }
    }

    @Nonnull
    TestGraphContext initialized() {
        if (this.graphInitialized == null) {
            throw new IllegalStateException("Dependency Container is not initialized!");
        }
        return this.graphInitialized;
    }

    Status status() {
        return this.status;
    }

    @Override
    public void close() {
        if (this.graphInitialized != null) {
            long started = TimeUtils.started();
            logger.trace("@KoraAppTest dependency container releasing...");
            try {
                this.graphInitialized.refreshableGraph().release();
                this.status = Status.RELEASED;
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.graphInitialized = null;
            logger.debug("@KoraAppTest dependency container released in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public static enum Status {
        CREATED,
        INITIALIZED,
        RELEASED;

    }
}

