/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import io.mockk.MockKKt;
import io.mockk.impl.annotations.MockK;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;
import ru.tinkoff.kora.test.extension.junit5.MockUtils;

record GraphMockkMock(GraphCandidate candidate, Class<?> mockClass, String mockkName, boolean relaxed, boolean relaxUnitFun) implements GraphModification
{
    public static GraphModification ofAnnotated(GraphCandidate candidate, AnnotatedElement element, String defaultName) {
        MockK annotation = MockUtils.getAnnotation(element, MockK.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Can't @MockK %s because it is not annotated with @MockK");
        }
        Class<?> classToMock = GraphMockkMock.getClassToMock(candidate);
        String name = Optional.of(annotation.name()).filter(n -> !n.isBlank()).orElse(defaultName);
        return new GraphMockkMock(candidate, classToMock, name, annotation.relaxed(), annotation.relaxUnitFun());
    }

    @Override
    public void accept(ApplicationGraphDraw graphDraw) {
        Set<Node<?>> nodesToMock = GraphUtils.findNodeByTypeOrAssignable(graphDraw, this.candidate());
        if (nodesToMock.isEmpty()) {
            throw new IllegalArgumentException("Can't @MockK component %s because it is not present in graph".formatted(this.candidate.toString()));
        }
        for (Node<?> nodeToMock : nodesToMock) {
            this.replaceNode(graphDraw, nodeToMock, this.mockClass());
        }
    }

    private static Class<?> getClassToMock(GraphCandidate candidate) {
        ParameterizedType pt;
        Type type = candidate.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        Type type2 = candidate.type();
        if (type2 instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type2).getRawType()) instanceof Class) {
            Class clazz = (Class)type2;
            return clazz;
        }
        throw new IllegalArgumentException("Can't @MockK using MockK for type: " + String.valueOf(candidate));
    }

    private <T> void replaceNode(ApplicationGraphDraw graphDraw, Node<T> node, Class<?> mockClass) {
        graphDraw.replaceNode(node, g -> {
            ParameterizedType pt;
            Class tc;
            KClass kotlinClass = JvmClassMappingKt.getKotlinClass((Class)mockClass);
            Type patt2694$temp = node.type();
            boolean isWrappedClass = patt2694$temp instanceof Class && Wrapped.class.isAssignableFrom(tc = (Class)patt2694$temp);
            Type patt2809$temp = node.type();
            boolean isWrappedInterface = patt2809$temp instanceof ParameterizedType && Wrapped.class.isAssignableFrom((Class)(pt = (ParameterizedType)patt2809$temp).getRawType());
            Object mock = MockKKt.mockkClass((KClass)kotlinClass, null, (isWrappedClass || this.relaxed ? 1 : 0) != 0, (KClass[])new KClass[]{}, (isWrappedClass || this.relaxUnitFun ? 1 : 0) != 0, v -> null);
            if (isWrappedClass && !mockClass.equals(node.type())) {
                KClass kotlinTC = JvmClassMappingKt.getKotlinClass((Class)((Class)node.type()));
                Wrapped mockedWrapper = (Wrapped)MockKKt.mockkClass((KClass)kotlinTC, null, (boolean)this.relaxed, (KClass[])new KClass[0], (boolean)this.relaxUnitFun, v -> null);
                MockKKt.every(mockKMatcherScope -> mockedWrapper.value()).returns(mock);
                return mockedWrapper;
            }
            if (isWrappedInterface) {
                return () -> mock;
            }
            return mock;
        });
    }
}

