/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import io.mockk.MockKKt;
import io.mockk.impl.JvmMockKGateway;
import io.mockk.impl.annotations.SpyK;
import jakarta.annotation.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KClass;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.application.graph.internal.NodeImpl;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;
import ru.tinkoff.kora.test.extension.junit5.GraphModification;
import ru.tinkoff.kora.test.extension.junit5.GraphUtils;
import ru.tinkoff.kora.test.extension.junit5.MockUtils;

record GraphMockkSpyk(GraphCandidate candidate, Class<?> mockClass, @Nullable Object value, String spykName, boolean recordPrivateCalls) implements GraphModification
{
    static GraphModification ofAnnotated(GraphCandidate candidate, AnnotatedElement element, String defaultName) {
        Class<?> classToMock = GraphMockkSpyk.getClassToMock(candidate);
        SpyK annotation = MockUtils.getAnnotation(element, SpyK.class);
        String name = Optional.of(annotation.name()).filter(n -> !n.isBlank()).orElse(defaultName);
        return new GraphMockkSpyk(candidate, classToMock, null, name, annotation.recordPrivateCalls());
    }

    static GraphModification ofField(GraphCandidate candidate, Field field, Object fieldValue) {
        Class<?> classToMock = GraphMockkSpyk.getClassToMock(candidate);
        SpyK annotation = MockUtils.getAnnotation(field, SpyK.class);
        String name = Optional.of(annotation.name()).filter(n -> !n.isBlank()).orElseGet(field::getName);
        return new GraphMockkSpyk(candidate, classToMock, fieldValue, name, annotation.recordPrivateCalls());
    }

    public boolean isSpyGraph() {
        return this.value == null;
    }

    @Override
    public void accept(ApplicationGraphDraw graphDraw) {
        Set<Node<?>> nodesToMock = GraphUtils.findNodeByTypeOrAssignable(graphDraw, this.candidate());
        if (nodesToMock.isEmpty()) {
            throw new IllegalArgumentException("Can't @SpyK component '%s' because it is not present in graph".formatted(this.candidate.toString()));
        }
        for (Node<?> nodeToMock : nodesToMock) {
            this.replaceNode(graphDraw, nodeToMock);
        }
    }

    private static Class<?> getClassToMock(GraphCandidate candidate) {
        ParameterizedType pt;
        Type type = candidate.type();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz;
        }
        Type type2 = candidate.type();
        if (type2 instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type2).getRawType()) instanceof Class) {
            Class clazz = (Class)type2;
            return clazz;
        }
        throw new IllegalArgumentException("Can't @SpyK using MockK for type: " + String.valueOf(candidate));
    }

    private <T> void replaceNode(ApplicationGraphDraw graphDraw, Node<T> node) {
        if (this.value != null) {
            graphDraw.replaceNode(node, g -> {
                Object spy = GraphMockkSpyk.getSpy(this.value, this.spykName, this.recordPrivateCalls);
                return this.getSpy(spy, node);
            });
        } else {
            graphDraw.replaceNodeKeepDependencies(node, g -> {
                Object spyCandidate = ((NodeImpl)node).factory.get(g);
                Object spy = GraphMockkSpyk.getSpy(spyCandidate, this.spykName, this.recordPrivateCalls);
                return this.getSpy(spy, node);
            });
        }
    }

    private static <T> T getSpy(T spyCandidate, String spykName, boolean recordPrivateCalls) {
        KClass kotlinClass = JvmClassMappingKt.getKotlinClass(spyCandidate.getClass());
        return (T)JvmMockKGateway.Companion.getDefaultImplementation().getMockFactory().spyk(kotlinClass, spyCandidate, spykName, new KClass[0], recordPrivateCalls);
    }

    private <T> T getSpy(T spy, Node<T> node) {
        Optional<Class<?>> nodeClass;
        Optional<Class<?>> wrappedType = GraphUtils.findWrappedType(node.type());
        if (wrappedType.isPresent() && wrappedType.get().isInstance(spy) && (nodeClass = GraphUtils.tryCastType(node.type())).isPresent()) {
            if (nodeClass.get().equals(Wrapped.class)) {
                return (T)((Wrapped)() -> spy);
            }
            KClass kotlinTC = JvmClassMappingKt.getKotlinClass(nodeClass.get());
            Wrapped mockedWrapper = (Wrapped)MockKKt.mockkClass((KClass)kotlinTC, null, (boolean)true, (KClass[])new KClass[0], (boolean)true, v -> null);
            MockKKt.every(mockKMatcherScope -> mockedWrapper.value()).returns(spy);
            return (T)mockedWrapper;
        }
        return spy;
    }
}

