/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Node;
import ru.tinkoff.kora.application.graph.Wrapped;
import ru.tinkoff.kora.common.Tag;
import ru.tinkoff.kora.test.extension.junit5.GraphCandidate;

final class GraphUtils {
    private static final Class<?>[] TAG_ANY = new Class[]{Tag.Any.class};

    private GraphUtils() {
    }

    static <T> Set<Node<T>> findNodeByType(ApplicationGraphDraw graph, GraphCandidate candidate) {
        return GraphUtils.findNodeByType(graph, candidate.type(), candidate.tagsAsArray());
    }

    static <T> Set<Node<T>> findNodeByType(ApplicationGraphDraw graph, Type type, Class<?>[] tags) {
        if (tags == null || tags.length == 0 || Arrays.equals(TAG_ANY, tags)) {
            HashSet<Node<T>> nodes = new HashSet<Node<T>>();
            for (Node graphNode : graph.getNodes()) {
                if (graphNode.tags().length != 0) continue;
                if (graphNode.type().equals(type)) {
                    nodes.add(graphNode);
                    continue;
                }
                Type unwrappedType = GraphUtils.unwrap(graphNode.type());
                if (!unwrappedType.equals(type)) continue;
                nodes.add(graphNode);
            }
            return nodes;
        }
        for (Node graphNode : graph.getNodes()) {
            if (!Arrays.equals(tags, graphNode.tags())) continue;
            if (graphNode.type().equals(type)) {
                return Set.of(graphNode);
            }
            Type unwrappedType = GraphUtils.unwrap(graphNode.type());
            if (!unwrappedType.equals(type)) continue;
            return Set.of(graphNode);
        }
        return Set.of();
    }

    static Set<Node<?>> findNodeByTypeOrAssignable(ApplicationGraphDraw graph, GraphCandidate candidate) {
        return GraphUtils.findNodeByTypeOrAssignable(graph, candidate.type(), candidate.tagsAsArray());
    }

    static Set<Node<?>> findNodeByTypeOrAssignable(ApplicationGraphDraw graph, Type type, Class<?>[] tags) {
        if (tags == null || tags.length == 0 || Arrays.equals(TAG_ANY, tags)) {
            HashSet nodes = new HashSet();
            for (Node graphNode : graph.getNodes()) {
                if (graphNode.tags().length != 0 && !Arrays.equals(TAG_ANY, graphNode.tags())) continue;
                Type graphType = graphNode.type();
                if (GraphUtils.isTypeAssignable(graphType, type)) {
                    nodes.add(graphNode);
                    continue;
                }
                Type unwrappedType = GraphUtils.unwrap(graphType);
                if (graphType == unwrappedType || !GraphUtils.isTypeAssignable(unwrappedType, type)) continue;
                nodes.add(graphNode);
            }
            return nodes;
        }
        for (Node graphNode : graph.getNodes()) {
            if (!Arrays.equals(tags, graphNode.tags())) continue;
            Type graphType = graphNode.type();
            if (GraphUtils.isTypeAssignable(graphType, type)) {
                return Set.of(graphNode);
            }
            Type unwrappedType = GraphUtils.unwrap(graphType);
            if (graphType == unwrappedType || !GraphUtils.isTypeAssignable(unwrappedType, type)) continue;
            return Set.of(graphNode);
        }
        return Set.of();
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean isTypeAssignable(Type type, Type candidate) {
        block9: {
            Type genericInterface;
            int n;
            ParameterizedType tpt;
            int n2;
            Type[] typeArray;
            block10: {
                ParameterizedType cpt;
                block8: {
                    Type[] genericInterfaces;
                    block7: {
                        if (type.equals(candidate)) {
                            return true;
                        }
                        if (!(type instanceof Class)) break block7;
                        Class tt = (Class)type;
                        if (!(candidate instanceof ParameterizedType)) break block7;
                        cpt = (ParameterizedType)candidate;
                        typeArray = genericInterfaces = tt.getGenericInterfaces();
                        n2 = typeArray.length;
                        break block8;
                    }
                    if (!(type instanceof ParameterizedType)) break block9;
                    tpt = (ParameterizedType)type;
                    if (!(candidate instanceof Class)) break block9;
                    Class ct = (Class)candidate;
                    typeArray = genericInterfaces = ct.getGenericInterfaces();
                    n2 = typeArray.length;
                    break block10;
                }
                for (n = 0; n < n2; ++n) {
                    genericInterface = typeArray[n];
                    if (!GraphUtils.isTypeAssignable(genericInterface, cpt)) continue;
                    return true;
                }
                break block9;
            }
            for (n = 0; n < n2; ++n) {
                genericInterface = typeArray[n];
                if (!GraphUtils.isTypeAssignable(tpt, genericInterface)) continue;
                return true;
            }
        }
        List<Class<?>> typeFlat = GraphUtils.getTypeFlat(type);
        List<Class<?>> candidateFlat = GraphUtils.getTypeFlat(candidate);
        if (typeFlat.size() != candidateFlat.size()) {
            return false;
        }
        int i = 0;
        while (i < typeFlat.size()) {
            Class<?> iType = typeFlat.get(i);
            Class<?> iCandidate = candidateFlat.get(i);
            if (!iCandidate.isAssignableFrom(iType)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static List<Class<?>> getTypeFlat(Type type) {
        if (type instanceof Class) {
            Class tc = (Class)type;
            return List.of(tc);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptt = (ParameterizedType)type;
            List<Class<?>> rawFlat = GraphUtils.getTypeFlat(ptt.getRawType());
            List argsFlat = Arrays.stream(ptt.getActualTypeArguments()).flatMap(t -> GraphUtils.getTypeFlat(t).stream()).toList();
            ArrayList result = new ArrayList();
            result.addAll(rawFlat);
            result.addAll(argsFlat);
            return result;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType ptt = (GenericArrayType)type;
            return GraphUtils.getTypeFlat(ptt.getGenericComponentType());
        }
        return List.of();
    }

    static boolean isWrapped(Type type) {
        Type unwrapped = GraphUtils.unwrap(type);
        return type != unwrapped;
    }

    static boolean doesImplement(Class<?> aClass, ParameterizedType parameterizedType) {
        for (Type genericInterface : aClass.getGenericInterfaces()) {
            if (!genericInterface.equals(parameterizedType)) continue;
            return true;
        }
        return false;
    }

    static boolean doesImplementOrExtend(Class<?> aClass, ParameterizedType parameterizedType) {
        if (GraphUtils.doesImplement(aClass, parameterizedType)) {
            return true;
        }
        Type superclass = aClass.getGenericSuperclass();
        if (superclass == null) {
            return false;
        }
        if (superclass.equals(parameterizedType)) {
            return true;
        }
        if (superclass instanceof Class) {
            Class clazz = (Class)superclass;
            return GraphUtils.doesImplementOrExtend(clazz, parameterizedType);
        }
        if (superclass instanceof ParameterizedType) {
            ParameterizedType clazz = (ParameterizedType)superclass;
            return GraphUtils.doesImplementOrExtend((Class)clazz.getRawType(), parameterizedType);
        }
        return false;
    }

    static Type unwrap(Type type) {
        Class pct;
        ParameterizedType pt;
        Type type2;
        Class tc;
        if (type instanceof Class && Wrapped.class.isAssignableFrom(tc = (Class)type)) {
            return Arrays.stream(tc.getGenericInterfaces()).filter(i -> i instanceof ParameterizedType).filter(i -> {
                Class rt;
                Type patt7517$temp = ((ParameterizedType)i).getRawType();
                return patt7517$temp instanceof Class && Wrapped.class.isAssignableFrom(rt = (Class)patt7517$temp);
            }).findFirst().map(i -> ((ParameterizedType)i).getActualTypeArguments()[0]).filter(arg -> arg instanceof Class).orElse(type);
        }
        if (type instanceof ParameterizedType && (type2 = (pt = (ParameterizedType)type).getRawType()) instanceof Class && Wrapped.class.isAssignableFrom(pct = (Class)type2)) {
            return pt.getActualTypeArguments()[0];
        }
        return type;
    }

    static Optional<Class<?>> findWrappedType(Type nodeType) {
        Class ptc;
        ParameterizedType pt;
        Type type;
        Class tc;
        if (nodeType instanceof Class && Wrapped.class.isAssignableFrom(tc = (Class)nodeType)) {
            return Arrays.stream(tc.getGenericInterfaces()).filter(i -> {
                Class ptc;
                ParameterizedType pt;
                Type patt8382$temp;
                return i instanceof ParameterizedType && (patt8382$temp = (pt = (ParameterizedType)i).getRawType()) instanceof Class && (ptc = (Class)patt8382$temp).equals(Wrapped.class);
            }).map(i -> ((ParameterizedType)i).getActualTypeArguments()[0]).map(t -> GraphUtils.tryCastType(t).orElse(null)).filter(Objects::nonNull).findFirst();
        }
        if (nodeType instanceof ParameterizedType && (type = (pt = (ParameterizedType)nodeType).getRawType()) instanceof Class && Wrapped.class.isAssignableFrom(ptc = (Class)type)) {
            if (Wrapped.class.equals((Object)ptc)) {
                return GraphUtils.tryCastType(pt.getActualTypeArguments()[0]);
            }
            return Arrays.stream(ptc.getGenericInterfaces()).filter(i -> {
                Class pptc;
                ParameterizedType ppt;
                Type patt9184$temp;
                return i instanceof ParameterizedType && (patt9184$temp = (ppt = (ParameterizedType)i).getRawType()) instanceof Class && (pptc = (Class)patt9184$temp).equals(Wrapped.class);
            }).map(i -> ((ParameterizedType)i).getActualTypeArguments()[0]).map(t -> GraphUtils.tryCastType(t).orElse(null)).filter(Objects::nonNull).findFirst();
        }
        return Optional.empty();
    }

    static Optional<Class<?>> tryCastType(Type type) {
        if (type instanceof Class) {
            Class tc = (Class)type;
            return Optional.of(tc);
        }
        if (type instanceof ParameterizedType) {
            Optional<Class<?>> optional;
            ParameterizedType tp = (ParameterizedType)type;
            Type type2 = tp.getRawType();
            if (type2 instanceof Class) {
                Class ptc = (Class)type2;
                optional = Optional.of(ptc);
            } else {
                optional = GraphUtils.tryCastType(tp.getRawType());
            }
            return optional;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return GraphUtils.tryCastType(gat.getGenericComponentType());
        }
        return Optional.empty();
    }
}

