/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.test.extension.junit5;

import jakarta.annotation.Nonnull;
import java.util.concurrent.Semaphore;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.tinkoff.kora.application.graph.ApplicationGraphDraw;
import ru.tinkoff.kora.application.graph.Graph;
import ru.tinkoff.kora.application.graph.RefreshableGraph;
import ru.tinkoff.kora.common.util.TimeUtils;
import ru.tinkoff.kora.test.extension.junit5.DefaultKoraAppGraph;
import ru.tinkoff.kora.test.extension.junit5.KoraJUnit5Extension;
import ru.tinkoff.kora.test.extension.junit5.TestGraphContext;

final class TestGraph
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(KoraJUnit5Extension.class);
    private static final int PERMIT_WITH_PROPS = 64;
    private static final int PERMIT_NO_PROPS = 1;
    private static final Semaphore LOCK = new Semaphore(64);
    private final ApplicationGraphDraw graph;
    private final KoraJUnit5Extension.TestMethodMetadata metadata;
    private volatile TestGraphContext graphInitialized;
    private volatile Status status;

    TestGraph(ApplicationGraphDraw graph, KoraJUnit5Extension.TestMethodMetadata metadata) {
        this.graph = graph;
        this.metadata = metadata;
        this.status = Status.CREATED;
    }

    void initialize() {
        logger.trace("@KoraAppTest dependency container initializing...");
        long started = TimeUtils.started();
        KoraJUnit5Extension.TestClassMetadata.Config config = this.metadata.classMetadata().config();
        if (!config.systemProperties().isEmpty()) {
            LOCK.acquireUninterruptibly(64);
            this.initGraph(config, started);
            LOCK.release(64);
        } else {
            LOCK.acquireUninterruptibly(1);
            this.initGraph(config, started);
            LOCK.release(1);
        }
    }

    private void initGraph(KoraJUnit5Extension.TestClassMetadata.Config config, long started) {
        try {
            config.setup(this.graph);
            RefreshableGraph initGraph = this.graph.init();
            this.graphInitialized = new TestGraphContext(initGraph, this.graph, new DefaultKoraAppGraph(this.graph, (Graph)initGraph));
            this.status = Status.INITIALIZED;
            logger.debug("@KoraAppTest dependency container initialized in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
        catch (Exception e) {
            throw new ExtensionConfigurationException("Dependency container initialization failed after: " + TimeUtils.tookForLogging((long)started), (Throwable)e);
        }
        finally {
            config.cleanup();
        }
    }

    @Nonnull
    TestGraphContext initialized() {
        if (this.graphInitialized == null) {
            throw new ExtensionConfigurationException("Dependency container is not initialized, initialization probably failed on previous steps!");
        }
        return this.graphInitialized;
    }

    Status status() {
        return this.status;
    }

    @Override
    public void close() {
        if (this.graphInitialized != null) {
            long started = TimeUtils.started();
            logger.trace("@KoraAppTest dependency container releasing...");
            try {
                this.graphInitialized.refreshableGraph().release();
                this.status = Status.RELEASED;
            }
            catch (Error | Exception e) {
                throw new ExtensionConfigurationException("Dependency container release failed after: " + TimeUtils.tookForLogging((long)started), e);
            }
            this.graphInitialized = null;
            logger.debug("@KoraAppTest dependency container released in {}", (Object)TimeUtils.tookForLogging((long)started));
        }
    }

    public static enum Status {
        CREATED,
        INITIALIZED,
        RELEASED;

    }
}

