package ru.tinkoff.kora.validation.common.constraint;

import javax.annotation.Nonnull;

import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.validation.common.ValidationContext;
import ru.tinkoff.kora.validation.common.Validator;
import ru.tinkoff.kora.validation.common.Violation;

import java.util.Collections;
import java.util.List;
import java.util.Map;

final class NotEmptyMapValidator<K, V> implements Validator<Map<K, V>> {

    @Nonnull
    @Override
    public @NotNull List<Violation> validate(Map<K, V> value, @Nonnull ValidationContext context) {
        if (value == null) {
            return List.of(context.violates("Should be not empty, but was null"));
        } else if (value.isEmpty()) {
            return List.of(context.violates("Should be not empty, but was empty"));
        }

        return Collections.emptyList();
    }
}
