/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.tinkoff.kora.validation.common.ValidationContext;
import ru.tinkoff.kora.validation.common.Violation;
import ru.tinkoff.kora.validation.common.ViolationException;

public interface Validator<T> {
    @Nonnull
    public List<Violation> validate(@Nullable T var1, @Nonnull ValidationContext var2);

    @Nonnull
    default public List<Violation> validate(@Nullable T value) {
        return this.validate(value, ValidationContext.builder().build());
    }

    default public void validateAndThrow(@Nullable T value, @Nonnull ValidationContext context) throws ViolationException {
        List<Violation> violations = this.validate(value, context);
        if (!violations.isEmpty()) {
            throw new ViolationException(violations);
        }
    }

    default public void validateAndThrow(@Nullable T value) throws ViolationException {
        List<Violation> violations = this.validate(value);
        if (!violations.isEmpty()) {
            throw new ViolationException(violations);
        }
    }
}

