/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common;

import java.util.List;
import javax.annotation.Nonnull;
import ru.tinkoff.kora.validation.common.Violation;

public final class ViolationException
extends RuntimeException {
    private String _message;
    private final List<Violation> violations;

    public ViolationException(@Nonnull List<Violation> violations) {
        this.violations = violations;
    }

    @Nonnull
    public List<Violation> getViolations() {
        return this.violations;
    }

    @Override
    public String getMessage() {
        if (this._message == null) {
            this._message = ViolationException.buildViolationMessage(this.violations);
        }
        return this._message;
    }

    private static String buildViolationMessage(List<Violation> violations) {
        StringBuilder builder = new StringBuilder("Validation failed with violations:\n");
        for (int i = 1; i <= violations.size(); ++i) {
            Violation violation = violations.get(i - 1);
            builder.append(i).append(") Path '").append(violation.path().full()).append("' violation: ").append(violation.message()).append(';');
            if (i == violations.size()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }
}

