/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common.constraint;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.validation.common.ValidationContext;
import ru.tinkoff.kora.validation.common.Validator;
import ru.tinkoff.kora.validation.common.Violation;

final class IterableValidator<T, I extends Iterable<T>>
implements Validator<I> {
    private final Validator<T> validator;

    IterableValidator(Validator<T> validator) {
        this.validator = validator;
    }

    @Override
    @Nonnull
    @NotNull
    public List<Violation> validate(I iterable, @Nonnull ValidationContext context) {
        if (iterable != null) {
            ArrayList<Violation> violations = new ArrayList<Violation>();
            Iterator iterator = iterable.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Object t = iterator.next();
                violations.addAll(this.validator.validate(t, context.addPath(i++)));
            }
            return violations;
        }
        return Collections.emptyList();
    }
}

