/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common.constraint;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.validation.common.ValidationContext;
import ru.tinkoff.kora.validation.common.Validator;
import ru.tinkoff.kora.validation.common.Violation;

final class PatternValidator<T extends CharSequence>
implements Validator<T> {
    private final Pattern pattern;

    PatternValidator(@Language(value="RegExp") String pattern, int flags) {
        this.pattern = Pattern.compile(pattern, flags);
    }

    @Override
    @Nonnull
    @NotNull
    public List<Violation> validate(T value, @Nonnull ValidationContext context) {
        if (value == null) {
            return List.of(context.violates("Should match RegEx " + this.pattern + " but was null"));
        }
        if (!this.pattern.matcher((CharSequence)value).find()) {
            return List.of(context.violates("Should match RegEx " + this.pattern + " but was: " + value));
        }
        return Collections.emptyList();
    }
}

