/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common.constraint;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.validation.common.ValidationContext;
import ru.tinkoff.kora.validation.common.Validator;
import ru.tinkoff.kora.validation.common.Violation;
import ru.tinkoff.kora.validation.common.annotation.Range;

final class RangeDoubleNumberValidator<T extends Number>
implements Validator<T> {
    private final double from;
    private final double to;
    private final Range.Boundary boundary;
    private final Predicate<T> fromPredicate;
    private final Predicate<T> toPredicate;

    RangeDoubleNumberValidator(double from, double to, Range.Boundary boundary) {
        if (to < from) {
            throw new IllegalArgumentException("From can't be less than To, but From was " + from + " and To was " + to);
        }
        this.from = from;
        this.to = to;
        this.boundary = boundary;
        this.fromPredicate = switch (boundary) {
            default -> throw new IncompatibleClassChangeError();
            case Range.Boundary.INCLUSIVE_INCLUSIVE, Range.Boundary.INCLUSIVE_EXCLUSIVE -> v -> v.doubleValue() >= from;
            case Range.Boundary.EXCLUSIVE_INCLUSIVE, Range.Boundary.EXCLUSIVE_EXCLUSIVE -> v -> v.doubleValue() > from;
        };
        this.toPredicate = switch (boundary) {
            default -> throw new IncompatibleClassChangeError();
            case Range.Boundary.INCLUSIVE_EXCLUSIVE, Range.Boundary.EXCLUSIVE_EXCLUSIVE -> v -> v.doubleValue() < to;
            case Range.Boundary.INCLUSIVE_INCLUSIVE, Range.Boundary.EXCLUSIVE_INCLUSIVE -> v -> v.doubleValue() <= to;
        };
    }

    @Override
    @Nonnull
    @NotNull
    public List<Violation> validate(T value, @Nonnull ValidationContext context) {
        if (value == null) {
            return List.of(context.violates("Should be in range from '" + this.from + "' to '" + this.to + "', but was null"));
        }
        if (!this.fromPredicate.test(value)) {
            return List.of(context.violates("Should be in range from '" + this.from + "' to '" + this.to + "', but was smaller: " + value));
        }
        if (!this.toPredicate.test(value)) {
            return List.of(context.violates("Should be in range from '" + this.from + "' to '" + this.to + "', but was greater: " + value));
        }
        return Collections.emptyList();
    }
}

