/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common.constraint;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;
import ru.tinkoff.kora.validation.common.ValidationContext;
import ru.tinkoff.kora.validation.common.Validator;
import ru.tinkoff.kora.validation.common.Violation;

final class SizeCollectionValidator<V, T extends Collection<V>>
implements Validator<T> {
    private final int from;
    private final int to;

    public SizeCollectionValidator(int from, int to) {
        if (from < 0) {
            throw new IllegalArgumentException("From can't be less 0, but was: " + from);
        }
        if (to < from) {
            throw new IllegalArgumentException("From can't be less than To, but From was " + from + " and To was " + to);
        }
        this.from = from;
        this.to = to;
    }

    @Override
    @Nonnull
    @NotNull
    public List<Violation> validate(T value, @Nonnull ValidationContext context) {
        if (value == null) {
            return List.of(context.violates("Size should be in range from '" + this.from + "' to '" + this.to + "', but value was null"));
        }
        if (value.size() < this.from) {
            return List.of(context.violates("Size should be in range from '" + this.from + "' to '" + this.to + "', but was smaller: " + value.size()));
        }
        if (value.size() > this.to) {
            return List.of(context.violates("Size should be in range from '" + this.from + "' to '" + this.to + "', but was greater: " + value.size()));
        }
        return Collections.emptyList();
    }
}

