/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common.constraint;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import ru.tinkoff.kora.validation.common.ValidationContext;
import ru.tinkoff.kora.validation.common.Validator;
import ru.tinkoff.kora.validation.common.Violation;

final class NotBlankStringValidator<T extends CharSequence>
implements Validator<T> {
    NotBlankStringValidator() {
    }

    @Override
    @Nonnull
    public List<Violation> validate(T value, @Nonnull ValidationContext context) {
        if (value == null) {
            return List.of(context.violates("Should be not blank, but was null"));
        }
        if (value.isEmpty()) {
            return List.of(context.violates("Should be not blank, but was empty"));
        }
        if (value.toString().isBlank()) {
            return List.of(context.violates("Should be not blank, but was blank"));
        }
        return Collections.emptyList();
    }
}

