/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common.constraint;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ru.tinkoff.kora.validation.common.ValidationContext;
import ru.tinkoff.kora.validation.common.Validator;
import ru.tinkoff.kora.validation.common.Violation;

final class NotEmptyMapValidator<K, V>
implements Validator<Map<K, V>> {
    NotEmptyMapValidator() {
    }

    @Override
    @Nonnull
    public List<Violation> validate(Map<K, V> value, @Nonnull ValidationContext context) {
        if (value == null) {
            return List.of(context.violates("Should be not empty, but was null"));
        }
        if (value.isEmpty()) {
            return List.of(context.violates("Should be not empty, but was empty"));
        }
        return Collections.emptyList();
    }
}

