/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.kora.validation.common;

import jakarta.annotation.Nonnull;
import ru.tinkoff.kora.validation.common.SimpleValidationContext;
import ru.tinkoff.kora.validation.common.SimpleViolation;
import ru.tinkoff.kora.validation.common.Violation;

public interface ValidationContext {
    @Nonnull
    public Path path();

    public boolean isFailFast();

    @Nonnull
    default public ValidationContext addPath(@Nonnull String path) {
        return new SimpleValidationContext(this.path().add(path), this.isFailFast());
    }

    @Nonnull
    default public ValidationContext addPath(int pathIndex) {
        return new SimpleValidationContext(this.path().add(pathIndex), this.isFailFast());
    }

    @Nonnull
    default public Violation violates(@Nonnull String message) {
        SimpleViolation.logger.debug("Validation violation on path '{}' with error: {}", (Object)this.path(), (Object)message);
        return new SimpleViolation(message, this.path());
    }

    public static Builder builder() {
        return new SimpleValidationContext.SimpleBuilder(SimpleValidationContext.SimpleFieldPath.ROOT, false);
    }

    public static interface Path {
        public String value();

        public Path root();

        default public Path add(@Nonnull String field) {
            return new SimpleValidationContext.SimpleFieldPath(this, field);
        }

        default public Path add(int index) {
            return new SimpleValidationContext.SimpleIndexPath(this, index);
        }

        public static Path of(@Nonnull String path) {
            return new SimpleValidationContext.SimpleFieldPath(null, path);
        }

        @Nonnull
        default public String full() {
            return this.toString();
        }
    }

    public static interface Builder {
        @Nonnull
        public Builder failFast(boolean var1);

        @Nonnull
        public ValidationContext build();
    }
}

